/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FieldAccessNotGuardedInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        if ("Concurrency annotation issues" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection.getGroupDisplayName must not return null");
        }
        return "Concurrency annotation issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unguarded field access" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection.getDisplayName must not return null");
        }
        return "Unguarded field access";
    }

    @NotNull
    public String getShortName() {
        if ("FieldAccessNotGuarded" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection.getShortName must not return null");
        }
        return "FieldAccessNotGuarded";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection.buildVisitor must not be null");
        }
        Visitor visitor = new Visitor(holder);
        if (visitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection.buildVisitor must not return null");
        }
        return visitor;
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiSynchronizedStatement syncStatement;
            PsiElement referent = expression.resolve();
            if (referent == null || !(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            String guard = JCiPUtil.findGuardForMember((PsiMember)field);
            if (guard == null) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            if (containingMethod != null && JCiPUtil.isGuardedBy((PsiMember)containingMethod, guard)) {
                return;
            }
            if ("this".equals(guard) && containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                return;
            }
            PsiReferenceExpression check = expression;
            while ((syncStatement = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)check, PsiSynchronizedStatement.class)) != null) {
                PsiExpression lockExpression = syncStatement.getLockExpression();
                if (lockExpression != null && lockExpression.getText().equals(guard)) {
                    return;
                }
                check = syncStatement;
            }
            this.myHolder.registerProblem((PsiElement)expression, "Access to field <code>#ref</code> outside of declared guards #loc", new LocalQuickFix[0]);
        }
    }
}

