/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.accessStaticViaInstance;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AccessStaticViaInstanceFix;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AccessStaticViaInstance
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/accessStaticViaInstance/AccessStaticViaInstance.getGroupDisplayName must not return null");
        }
        return "";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"access.static.via.instance", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/accessStaticViaInstance/AccessStaticViaInstance.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("AccessStaticViaInstance" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/accessStaticViaInstance/AccessStaticViaInstance.getShortName must not return null");
        }
        return "AccessStaticViaInstance";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/accessStaticViaInstance/AccessStaticViaInstance.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                AccessStaticViaInstance.checkAccessStaticMemberViaInstanceReference(expression, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/accessStaticViaInstance/AccessStaticViaInstance.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    private static void checkAccessStaticMemberViaInstanceReference(PsiReferenceExpression expr, ProblemsHolder holder, boolean onTheFly) {
        PsiElement qualifierResolved;
        JavaResolveResult result = expr.advancedResolve(false);
        PsiElement resolved = result.getElement();
        if (!(resolved instanceof PsiMember)) {
            return;
        }
        PsiExpression qualifierExpression = expr.getQualifierExpression();
        if (qualifierExpression == null) {
            return;
        }
        if (qualifierExpression instanceof PsiReferenceExpression && ((qualifierResolved = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiClass || qualifierResolved instanceof PsiPackage)) {
            return;
        }
        if (!((PsiMember)resolved).hasModifierProperty("static")) {
            return;
        }
        String description = JavaErrorMessages.message("static.member.accessed.via.instance.reference", HighlightUtil.formatType(qualifierExpression.getType()), HighlightMessageUtil.getSymbolName(resolved, result.getSubstitutor()));
        holder.registerProblem((PsiElement)expr, description, new LocalQuickFix[]{new AccessStaticViaInstanceFix(expr, result, onTheFly)});
    }
}

