/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.RemoveSuppressWarningAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantSuppressInspection
extends GlobalInspectionTool {
    private BidirectionalMap<String, QuickFix> myQuickFixes = null;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.RedundantSuppressInspection");

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/RedundantSuppressInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.redundant.suppression.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/RedundantSuppressInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("RedundantSuppression" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/RedundantSuppressInspection.getShortName must not return null");
        }
        return "RedundantSuppression";
    }

    public void runInspection(AnalysisScope scope, final InspectionManager manager, final GlobalInspectionContext globalContext, final ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitClass(RefClass refClass) {
                if (!globalContext.shouldCheck((RefEntity)refClass, (GlobalInspectionTool)RedundantSuppressInspection.this)) {
                    return;
                }
                CommonProblemDescriptor[] descriptors = RedundantSuppressInspection.this.checkElement(refClass, manager, globalContext.getProject());
                if (descriptors != null) {
                    for (CommonProblemDescriptor descriptor : descriptors) {
                        if (descriptor instanceof ProblemDescriptor) {
                            PsiElement psiElement = ((ProblemDescriptor)descriptor).getPsiElement();
                            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMember.class);
                            RefElement refElement = globalContext.getRefManager().getReference((PsiElement)member);
                            if (refElement != null) {
                                problemDescriptionsProcessor.addProblemElement((RefEntity)refElement, new CommonProblemDescriptor[]{descriptor});
                                continue;
                            }
                        }
                        problemDescriptionsProcessor.addProblemElement((RefEntity)refClass, new CommonProblemDescriptor[]{descriptor});
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CommonProblemDescriptor[] checkElement(RefClass refEntity, InspectionManager manager, Project project) {
        ArrayList<ProblemDescriptor> result;
        PsiClass psiElement = refEntity.getElement();
        THashMap suppressedScopes = new THashMap();
        psiElement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((PsiElement)psiElement, (Map)suppressedScopes){
            final /* synthetic */ PsiElement val$psiElement;
            final /* synthetic */ Map val$suppressedScopes;
            {
                this.val$psiElement = psiElement;
                this.val$suppressedScopes = map;
            }

            public void visitModifierList(PsiModifierList list) {
                super.visitModifierList(list);
                PsiElement parent = list.getParent();
                if (parent instanceof PsiModifierListOwner && !(parent instanceof PsiClass)) {
                    this.checkElement(parent);
                }
            }

            public void visitComment(PsiComment comment) {
                this.checkElement((PsiElement)comment);
            }

            public void visitClass(PsiClass aClass) {
                if (aClass == this.val$psiElement) {
                    super.visitClass(aClass);
                    this.checkElement((PsiElement)aClass);
                }
            }

            private void checkElement(PsiElement owner) {
                String idsString = SuppressManager.getInstance().getSuppressedInspectionIdsIn(owner);
                if (idsString != null && idsString.length() != 0) {
                    List ids = StringUtil.split((String)idsString, (String)",");
                    Collection suppressed = (Collection)this.val$suppressedScopes.get(owner);
                    if (suppressed == null) {
                        suppressed = ids;
                    } else {
                        for (String id : ids) {
                            if (suppressed.contains(id)) continue;
                            suppressed.add(id);
                        }
                    }
                    this.val$suppressedScopes.put(owner, suppressed);
                }
            }
        });
        if (suppressedScopes.values().isEmpty()) {
            return null;
        }
        ModifiableModel model = InspectionProjectProfileManager.getInstance(manager.getProject()).getInspectionProfile().getModifiableModel();
        InspectionProfileWrapper profile = new InspectionProfileWrapper((InspectionProfile)model);
        profile.init(manager.getProject());
        THashSet suppressedTools = new THashSet();
        InspectionTool[] tools = profile.getInspectionTools((PsiElement)psiElement);
        for (Collection ids : suppressedScopes.values()) {
            for (String id : ids) {
                String shortName = id.trim();
                for (InspectionTool tool : tools) {
                    if ((!(tool instanceof LocalInspectionToolWrapper) || !((LocalInspectionToolWrapper)tool).getTool().getID().equals(shortName)) && !tool.getShortName().equals(shortName)) continue;
                    suppressedTools.add(tool);
                }
            }
        }
        AnalysisScope scope = new AnalysisScope(psiElement.getContainingFile());
        InspectionManagerEx inspectionManagerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        GlobalInspectionContextImpl globalContext = inspectionManagerEx.createNewGlobalContext(false);
        globalContext.setCurrentScope(scope);
        RefManagerImpl refManager = (RefManagerImpl)globalContext.getRefManager();
        refManager.inspectionReadActionStarted();
        try {
            result = new ArrayList<ProblemDescriptor>();
            for (InspectionTool tool : suppressedTools) {
                Collection<CommonProblemDescriptor> descriptors;
                String toolId = tool instanceof LocalInspectionToolWrapper ? ((LocalInspectionToolWrapper)tool).getTool().getID() : tool.getShortName();
                tool.initialize(globalContext);
                if (tool instanceof LocalInspectionToolWrapper) {
                    LocalInspectionToolWrapper local = (LocalInspectionToolWrapper)tool;
                    if (local.getTool() instanceof UnfairLocalInspectionTool) continue;
                    local.processFile(psiElement.getContainingFile(), false, manager);
                    descriptors = local.getProblemDescriptors();
                } else {
                    if (!(tool instanceof GlobalInspectionToolWrapper)) continue;
                    GlobalInspectionToolWrapper global = (GlobalInspectionToolWrapper)tool;
                    if (global.getTool().isGraphNeeded()) {
                        refManager.findAllDeclarations();
                    }
                    global.processFile(scope, manager, globalContext, false);
                    descriptors = global.getProblemDescriptors();
                }
                for (PsiElement suppressedScope : suppressedScopes.keySet()) {
                    String key;
                    Object fix;
                    PsiMember psiMember;
                    Collection suppressedIds = (Collection)suppressedScopes.get(suppressedScope);
                    if (!suppressedIds.contains(toolId)) continue;
                    boolean hasErrorInsideSuppressedScope = false;
                    for (CommonProblemDescriptor descriptor : descriptors) {
                        PsiElement annotation;
                        PsiElement element;
                        if (!(descriptor instanceof ProblemDescriptor) || (element = ((ProblemDescriptor)descriptor).getPsiElement()) == null || (annotation = SuppressManager.getInstance().getElementToolSuppressedIn(element, toolId)) == null || !PsiTreeUtil.isAncestor((PsiElement)suppressedScope, (PsiElement)annotation, (boolean)false)) continue;
                        hasErrorInsideSuppressedScope = true;
                        break;
                    }
                    if (hasErrorInsideSuppressedScope) continue;
                    String problemLine = null;
                    if (suppressedScope instanceof PsiMember) {
                        psiMember = (PsiMember)suppressedScope;
                    } else {
                        psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)suppressedScope, PsiDocCommentOwner.class);
                        PsiStatement statement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)suppressedScope, PsiStatement.class);
                        String string = problemLine = statement != null ? statement.getText() : null;
                    }
                    if (psiMember == null || !psiMember.isValid()) continue;
                    String description = InspectionsBundle.message((String)"inspection.redundant.suppression.description", (Object[])new Object[0]);
                    if (this.myQuickFixes == null) {
                        this.myQuickFixes = new BidirectionalMap();
                    }
                    if ((fix = (QuickFix)this.myQuickFixes.get((Object)(key = toolId + (problemLine != null ? ";" + problemLine : "")))) == null) {
                        fix = new RemoveSuppressWarningAction(toolId, problemLine);
                        this.myQuickFixes.put((Object)key, fix);
                    }
                    PsiIdentifier identifier = null;
                    if (psiMember instanceof PsiMethod) {
                        identifier = ((PsiMethod)psiMember).getNameIdentifier();
                    } else if (psiMember instanceof PsiField) {
                        identifier = ((PsiField)psiMember).getNameIdentifier();
                    } else if (psiMember instanceof PsiClass) {
                        identifier = ((PsiClass)psiMember).getNameIdentifier();
                    }
                    if (identifier == null) {
                        identifier = psiMember;
                    }
                    result.add(manager.createProblemDescriptor((PsiElement)identifier, description, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false));
                }
            }
        }
        finally {
            refManager.inspectionReadActionFinished();
            globalContext.close(true);
        }
        return (CommonProblemDescriptor[])result.toArray(new ProblemDescriptor[result.size()]);
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return this.myQuickFixes != null ? (QuickFix)this.myQuickFixes.get((Object)hint) : new RemoveSuppressWarningAction(hint);
    }

    @Nullable
    public String getHint(QuickFix fix) {
        List list;
        if (this.myQuickFixes != null && (list = this.myQuickFixes.getKeysByValue((Object)fix)) != null) {
            LOG.assertTrue(list.size() == 1);
            return (String)list.get(0);
        }
        return null;
    }

    public boolean isEnabledByDefault() {
        return false;
    }
}

