/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionMain;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.impl.PatchProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.StringBuilderSpinAllocator;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class InspectionApplication {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.InspectionApplication");
    public String myProjectPath = null;
    public String myOutPath = null;
    public String mySourceDirectory = null;
    public String myProfileName = null;
    public boolean myRunWithEditorSettings = false;
    public boolean myRunGlobalToolsOnly = false;
    private Project myProject;
    private int myVerboseLevel = 0;
    public boolean myErrorCodeRequired = true;
    @NonNls
    public static final String DESCRIPTIONS = ".descriptions";
    @NonNls
    public static final String PROFILE = "profile";
    @NonNls
    public static final String INSPECTIONS_NODE = "inspections";
    @NonNls
    public static final String XML_EXTENSION = ".xml";

    public void startup() {
        if (this.myProjectPath == null || this.myOutPath == null || this.myProfileName == null) {
            InspectionApplication.logError(this.myProjectPath + this.myOutPath + this.myProfileName);
            InspectionMain.printHelp();
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ApplicationEx application = ApplicationManagerEx.getApplicationEx();
                try {
                    ApplicationInfoEx applicationInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
                    InspectionApplication.this.logMessage(1, InspectionsBundle.message((String)"inspection.application.starting.up", (Object[])new Object[]{applicationInfo.getFullApplicationName()}));
                    application.doNotSave();
                    InspectionApplication.this.logMessageLn(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
                    InspectionApplication.this.run();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    if (InspectionApplication.this.myErrorCodeRequired) {
                        application.exit(true);
                    }
                }
            }
        });
    }

    public void run() {
        block16: {
            try {
                AnalysisScope scope;
                this.myProjectPath = this.myProjectPath.replace(File.separatorChar, '/');
                VirtualFile vfsProject = LocalFileSystem.getInstance().findFileByPath(this.myProjectPath);
                if (vfsProject == null) {
                    InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.file.cannot.be.found", (Object[])new Object[]{this.myProjectPath}));
                    InspectionMain.printHelp();
                }
                this.logMessage(1, InspectionsBundle.message((String)"inspection.application.opening.project", (Object[])new Object[0]));
                if (ConversionService.getInstance().convertSilently(this.myProjectPath, this.createConversionListener()).openingIsCanceled()) {
                    if (this.myErrorCodeRequired) {
                        System.exit(1);
                    }
                    return;
                }
                this.myProject = ProjectUtil.openOrImport(this.myProjectPath, null, false);
                if (this.myProject == null) {
                    InspectionApplication.logError("Unable to open project");
                    if (this.myErrorCodeRequired) {
                        System.exit(1);
                    }
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        VirtualFileManager.getInstance().refreshWithoutFileWatcher(false);
                    }
                });
                Profile inspectionProfile = InspectionProjectProfileManager.getInstance(this.myProject).getProfile(this.myProfileName, false);
                if (inspectionProfile == null) {
                    Collection profiles = InspectionProjectProfileManager.getInstance(this.myProject).getProfiles();
                    for (Profile profile : profiles) {
                        if (!Comparing.strEqual((String)profile.getName(), (String)this.myProfileName)) continue;
                        inspectionProfile = profile;
                        break;
                    }
                }
                if (inspectionProfile == null) {
                    inspectionProfile = InspectionProfileManager.getInstance().loadProfile(this.myProfileName);
                }
                if (inspectionProfile == null) {
                    inspectionProfile = InspectionProjectProfileManager.getInstance(this.myProject).getInspectionProfile();
                }
                PatchProjectUtil.patchProject(this.myProject);
                this.logMessageLn(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
                this.logMessage(1, InspectionsBundle.message((String)"inspection.application.initializing.project", (Object[])new Object[0]));
                final InspectionManagerEx im = (InspectionManagerEx)InspectionManager.getInstance((Project)this.myProject);
                final GlobalInspectionContextImpl inspectionContext = im.createNewGlobalContext(true);
                inspectionContext.setExternalProfile((InspectionProfile)inspectionProfile);
                im.setProfile(inspectionProfile.getName());
                if (this.mySourceDirectory == null) {
                    scope = new AnalysisScope(this.myProject);
                } else {
                    this.mySourceDirectory = this.mySourceDirectory.replace(File.separatorChar, '/');
                    VirtualFile vfsDir = LocalFileSystem.getInstance().findFileByPath(this.mySourceDirectory);
                    if (vfsDir == null) {
                        InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.directory.cannot.be.found", (Object[])new Object[]{this.mySourceDirectory}));
                        InspectionMain.printHelp();
                    }
                    PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(vfsDir);
                    scope = new AnalysisScope(psiDirectory);
                }
                this.logMessageLn(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
                if (!this.myRunWithEditorSettings) {
                    this.logMessageLn(1, InspectionsBundle.message((String)"inspection.application.chosen.profile.log message", (Object[])new Object[]{inspectionProfile.getName()}));
                }
                ProgressManager.getInstance().runProcess(new Runnable(){

                    @Override
                    public void run() {
                        if (!InspectionManagerEx.canRunInspections(InspectionApplication.this.myProject, false)) {
                            if (InspectionApplication.this.myErrorCodeRequired) {
                                System.exit(1);
                            }
                            return;
                        }
                        inspectionContext.launchInspectionsOffline(scope, InspectionApplication.this.myOutPath, InspectionApplication.this.myRunWithEditorSettings, InspectionApplication.this.myRunGlobalToolsOnly, im);
                        InspectionApplication.this.logMessageLn(1, "\n" + InspectionsBundle.message((String)"inspection.capitalized.done", (Object[])new Object[0]) + "\n");
                    }
                }, (ProgressIndicator)new ProgressIndicatorBase(){
                    private String lastPrefix = "";
                    private int myLastPercent = -1;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void setText(String text) {
                        if (InspectionApplication.this.myVerboseLevel == 0) {
                            return;
                        }
                        if (InspectionApplication.this.myVerboseLevel == 1) {
                            String prefix = InspectionApplication.getPrefix(text);
                            if (prefix == null) {
                                return;
                            }
                            if (prefix.equals(this.lastPrefix)) {
                                InspectionApplication.this.logMessage(1, ".");
                                return;
                            }
                            this.lastPrefix = prefix;
                            InspectionApplication.this.logMessageLn(1, "");
                            InspectionApplication.this.logMessageLn(1, prefix);
                            return;
                        }
                        if (InspectionApplication.this.myVerboseLevel == 3) {
                            if (!this.isIndeterminate() && this.getFraction() > 0.0) {
                                StringBuilder buf = StringBuilderSpinAllocator.alloc();
                                try {
                                    int percent = (int)(this.getFraction() * 100.0);
                                    if (this.myLastPercent == percent) {
                                        return;
                                    }
                                    this.myLastPercent = percent;
                                    buf.append(InspectionsBundle.message((String)"inspection.display.name", (Object[])new Object[0])).append(" ").append(percent).append("%");
                                    InspectionApplication.this.logMessageLn(2, buf.toString());
                                }
                                finally {
                                    StringBuilderSpinAllocator.dispose((StringBuilder)buf);
                                }
                            }
                            return;
                        }
                        InspectionApplication.this.logMessageLn(2, text);
                    }
                });
                InspectionApplication.describeInspections(this.myOutPath + File.separatorChar + DESCRIPTIONS + XML_EXTENSION, !this.myRunWithEditorSettings ? inspectionProfile.getName() : null);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                InspectionApplication.logError(e.getMessage());
                InspectionMain.printHelp();
            }
            catch (Throwable e) {
                LOG.error(e);
                InspectionApplication.logError(e.getMessage());
                if (!this.myErrorCodeRequired) break block16;
                System.exit(1);
            }
        }
    }

    private ConversionListener createConversionListener() {
        return new ConversionListener(){

            @Override
            public void conversionNeeded() {
                InspectionApplication.this.logMessageLn(1, InspectionsBundle.message((String)"inspection.application.project.has.older.format.and.will.be.converted", (Object[])new Object[0]));
            }

            @Override
            public void successfullyConverted(File backupDir) {
                InspectionApplication.this.logMessageLn(1, InspectionsBundle.message((String)"inspection.application.project.was.succesfully.converted.old.project.files.were.saved.to.0", (Object[])new Object[]{backupDir.getAbsolutePath()}));
            }

            @Override
            public void error(String message) {
                InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.cannot.convert.project.0", (Object[])new Object[]{message}));
            }

            @Override
            public void cannotWriteToFiles(List<File> readonlyFiles) {
                StringBuilder files = new StringBuilder();
                for (File file : readonlyFiles) {
                    files.append(file.getAbsolutePath()).append("; ");
                }
                InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.cannot.convert.the.project.the.following.files.are.read.only.0", (Object[])new Object[]{files.toString()}));
            }
        };
    }

    @Nullable
    private static String getPrefix(String text) {
        String prefix = null;
        int idx = text.indexOf(" in ");
        if (idx == -1) {
            idx = text.indexOf(" of ");
        }
        if (idx != -1) {
            prefix = text.substring(0, idx);
        }
        return prefix;
    }

    public void setVerboseLevel(int verboseLevel) {
        this.myVerboseLevel = verboseLevel;
    }

    private void logMessage(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.print(message);
        }
    }

    private static void logError(String message) {
        System.err.println(message);
    }

    private void logMessageLn(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.println(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void describeInspections(@NonNls String myOutputPath, String name) throws IOException {
        InspectionProfileEntry[] profileEntries = InspectionProfileImpl.getDefaultProfile().getInspectionTools(null);
        HashMap<String, HashSet<InspectionProfileEntry>> map = new HashMap<String, HashSet<InspectionProfileEntry>>();
        for (InspectionProfileEntry entry : profileEntries) {
            String groupName = entry.getGroupDisplayName();
            HashSet<InspectionProfileEntry> groupInspections = (HashSet<InspectionProfileEntry>)map.get(groupName);
            if (groupInspections == null) {
                groupInspections = new HashSet<InspectionProfileEntry>();
                map.put(groupName, groupInspections);
            }
            groupInspections.add(entry);
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(myOutputPath);
            PrettyPrintWriter xmlWriter = new PrettyPrintWriter((Writer)fw);
            xmlWriter.startNode(INSPECTIONS_NODE);
            if (name != null) {
                xmlWriter.addAttribute(PROFILE, name);
            }
            for (String groupName : map.keySet()) {
                xmlWriter.startNode("group");
                xmlWriter.addAttribute("name", groupName);
                Set entries = (Set)map.get(groupName);
                for (InspectionProfileEntry entry : entries) {
                    xmlWriter.startNode("inspection");
                    xmlWriter.addAttribute("shortName", entry.getShortName());
                    xmlWriter.addAttribute("displayName", entry.getDisplayName());
                    String description = entry.loadDescription();
                    if (description != null) {
                        xmlWriter.setValue(description);
                    } else {
                        LOG.error(entry.getShortName() + " descriptionUrl==null");
                    }
                    xmlWriter.endNode();
                }
                xmlWriter.endNode();
            }
            xmlWriter.endNode();
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }
}

