/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.zencoding;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.zencoding.FilterToken;
import com.intellij.codeInsight.template.zencoding.MarkerToken;
import com.intellij.codeInsight.template.zencoding.NumberToken;
import com.intellij.codeInsight.template.zencoding.OperationToken;
import com.intellij.codeInsight.template.zencoding.State;
import com.intellij.codeInsight.template.zencoding.TemplateToken;
import com.intellij.codeInsight.template.zencoding.Token;
import com.intellij.codeInsight.template.zencoding.XmlTemplateToken;
import com.intellij.codeInsight.template.zencoding.XmlZenCodingFilter;
import com.intellij.codeInsight.template.zencoding.XmlZenCodingFilterImpl;
import com.intellij.codeInsight.template.zencoding.ZenCodingFilter;
import com.intellij.codeInsight.template.zencoding.ZenCodingUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.IntArrayList;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class XmlZenCodingInterpreter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.zencoding.XmlZenCodingInterpreter");
    private static final String ATTRS = "ATTRS";
    private final List<Token> myTokens;
    private final CustomTemplateCallback myCallback;
    private final String mySurroundedText;
    private State myState;

    private XmlZenCodingInterpreter(List<Token> tokens, CustomTemplateCallback callback, State initialState, String surroundedText) {
        this.myTokens = tokens;
        this.myCallback = callback;
        this.mySurroundedText = surroundedText;
        this.myState = initialState;
    }

    private void finish() {
        this.myCallback.gotoEndOffset();
    }

    private void gotoChild(Object templateBoundsKey) {
        int startOfTemplate = this.myCallback.getStartOfTemplate(templateBoundsKey);
        int endOfTemplate = this.myCallback.getEndOfTemplate(templateBoundsKey);
        int offset = this.myCallback.getOffset();
        PsiFile file = this.myCallback.parseCurrentText((FileType)StdFileTypes.XML);
        PsiElement element = file.findElementAt(offset);
        if (offset < endOfTemplate && element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_END_TAG_START) {
            return;
        }
        int newOffset = -1;
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOfTemplate, (int)endOfTemplate, XmlTag.class);
        if (tag != null) {
            for (PsiElement child : tag.getChildren()) {
                if (!(child instanceof XmlToken) || ((XmlToken)child).getTokenType() != XmlTokenType.XML_END_TAG_START) continue;
                newOffset = child.getTextOffset();
            }
        }
        if (newOffset >= 0) {
            if (offset < endOfTemplate) {
                this.myCallback.fixEndOffset();
            }
            this.myCallback.moveToOffset(newOffset);
        }
    }

    public static void interpret(List<Token> tokens, int startIndex, CustomTemplateCallback callback, State initialState, String surroundedText) {
        XmlZenCodingInterpreter interpreter = new XmlZenCodingInterpreter(tokens, callback, initialState, surroundedText);
        interpreter.invoke(startIndex);
    }

    private void invoke(int startIndex) {
        Token lastToken;
        String filter = null;
        if (this.myTokens.size() > 0 && (lastToken = this.myTokens.get(this.myTokens.size() - 1)) instanceof FilterToken) {
            filter = ((FilterToken)lastToken).getSuffix();
        }
        int n = this.myTokens.size();
        TemplateToken templateToken = null;
        int number = -1;
        block6: for (int i = startIndex; i < n; ++i) {
            Token token = this.myTokens.get(i);
            switch (this.myState) {
                case OPERATION: {
                    int sign;
                    if (templateToken == null) continue block6;
                    if (token instanceof MarkerToken || token instanceof OperationToken) {
                        int n2 = sign = token instanceof OperationToken ? (int)((OperationToken)token).getSign() : 36;
                        if (sign == 43 || this.mySurroundedText == null && sign == 36) {
                            Object key = new Object();
                            this.myCallback.fixStartOfTemplate(key);
                            XmlZenCodingInterpreter.invokeTemplate(templateToken, this.myCallback, 0, filter);
                            this.myState = State.WORD;
                            if (this.myCallback.getOffset() != this.myCallback.getEndOfTemplate(key)) {
                                this.myCallback.fixEndOffset();
                            }
                            if (sign == 43) {
                                this.myCallback.gotoEndOfTemplate(key);
                            }
                            templateToken = null;
                            continue block6;
                        }
                        if (sign == 62 || this.mySurroundedText != null && sign == 36) {
                            this.startTemplateAndGotoChild(templateToken, filter);
                            templateToken = null;
                            continue block6;
                        }
                        if (sign != 42) continue block6;
                        this.myState = State.NUMBER;
                        continue block6;
                    }
                    this.fail();
                    continue block6;
                }
                case WORD: {
                    if (token instanceof TemplateToken) {
                        templateToken = (TemplateToken)token;
                        this.myState = State.OPERATION;
                        continue block6;
                    }
                    this.fail();
                    continue block6;
                }
                case NUMBER: {
                    if (token instanceof NumberToken) {
                        number = ((NumberToken)token).getNumber();
                        this.myState = State.AFTER_NUMBER;
                        continue block6;
                    }
                    this.fail();
                    continue block6;
                }
                case AFTER_NUMBER: {
                    int sign;
                    if (token instanceof MarkerToken || token instanceof OperationToken) {
                        int n3 = sign = token instanceof OperationToken ? (int)((OperationToken)token).getSign() : 36;
                        if (sign == 43 || this.mySurroundedText == null && sign == 36) {
                            this.invokeTemplateSeveralTimes(templateToken, 0, number, filter);
                            templateToken = null;
                        } else {
                            if (number > 1) {
                                this.invokeTemplateAndProcessTail(templateToken, 0, number, i + 1, filter);
                                return;
                            }
                            assert (number == 1);
                            this.startTemplateAndGotoChild(templateToken, filter);
                            templateToken = null;
                        }
                        this.myState = State.WORD;
                        continue block6;
                    }
                    this.fail();
                }
            }
        }
        if (this.mySurroundedText != null) {
            XmlZenCodingInterpreter.insertText(this.myCallback, this.mySurroundedText);
        }
        this.finish();
    }

    private void startTemplateAndGotoChild(TemplateToken templateToken, String filter) {
        Object key = new Object();
        this.myCallback.fixStartOfTemplate(key);
        XmlZenCodingInterpreter.invokeTemplate(templateToken, this.myCallback, 0, filter);
        this.myState = State.WORD;
        this.gotoChild(key);
    }

    private void invokeTemplateSeveralTimes(TemplateToken templateToken, int startIndex, int count, String filter) {
        Object key = new Object();
        this.myCallback.fixStartOfTemplate(key);
        for (int i = startIndex; i < count; ++i) {
            XmlZenCodingInterpreter.invokeTemplate(templateToken, this.myCallback, i, filter);
            this.myState = State.WORD;
            if (this.myCallback.getOffset() != this.myCallback.getEndOfTemplate(key)) {
                this.myCallback.fixEndOffset();
            }
            this.myCallback.gotoEndOfTemplate(key);
        }
    }

    private static void insertText(CustomTemplateCallback callback, String text) {
        int offset = callback.getOffset();
        callback.insertString(offset, text);
    }

    private void invokeTemplateAndProcessTail(TemplateToken templateToken, int startIndex, int count, int tailStart, String filter) {
        Object key = new Object();
        this.myCallback.fixStartOfTemplate(key);
        for (int i = startIndex; i < count; ++i) {
            Object iterKey = new Object();
            this.myCallback.fixStartOfTemplate(iterKey);
            XmlZenCodingInterpreter.invokeTemplate(templateToken, this.myCallback, i, filter);
            this.gotoChild(iterKey);
            XmlZenCodingInterpreter.interpret(this.myTokens, tailStart, this.myCallback, State.WORD, this.mySurroundedText);
            if (this.myCallback.getOffset() != this.myCallback.getEndOfTemplate(key)) {
                this.myCallback.fixEndOffset();
            }
            this.myCallback.gotoEndOfTemplate(key);
        }
        this.finish();
    }

    static boolean containsAttrsVar(TemplateImpl template) {
        for (int i = 0; i < template.getVariableCount(); ++i) {
            String varName = template.getVariableNameAt(i);
            if (!ATTRS.equals(varName)) continue;
            return true;
        }
        return false;
    }

    private static void removeVariablesWhichHasNoSegment(TemplateImpl template) {
        int i;
        HashSet segments = new HashSet();
        for (int i2 = 0; i2 < template.getSegmentsCount(); ++i2) {
            segments.add(template.getSegmentName(i2));
        }
        IntArrayList varsToRemove = new IntArrayList();
        for (i = 0; i < template.getVariableCount(); ++i) {
            String varName = template.getVariableNameAt(i);
            if (segments.contains(varName)) continue;
            varsToRemove.add(i);
        }
        for (i = 0; i < varsToRemove.size(); ++i) {
            template.removeVariable(varsToRemove.get(i));
        }
    }

    @Nullable
    private static Map<String, String> buildPredefinedValues(List<Pair<String, String>> attribute2value, int numberInIteration, CustomTemplateCallback callback) {
        String attributes = XmlZenCodingInterpreter.buildAttributesString(attribute2value, numberInIteration, callback);
        assert (attributes != null);
        attributes = attributes.length() > 0 ? ' ' + attributes : null;
        HashMap predefinedValues = null;
        if (attributes != null) {
            predefinedValues = new HashMap();
            predefinedValues.put(ATTRS, attributes);
        }
        return predefinedValues;
    }

    @Nullable
    private static String buildAttributesString(List<Pair<String, String>> attribute2value, int numberInIteration, CustomTemplateCallback callback) {
        PsiElement context = callback.getContext();
        for (ZenCodingFilter filter : (ZenCodingFilter[])ZenCodingFilter.EP_NAME.getExtensions()) {
            if (!filter.isMyContext(context)) continue;
            return filter.buildAttributesString(attribute2value, numberInIteration);
        }
        return new XmlZenCodingFilterImpl().buildAttributesString(attribute2value, numberInIteration);
    }

    private static void invokeTemplate(TemplateToken token, CustomTemplateCallback callback, final int numberInIteration, String filter) {
        if (token instanceof XmlTemplateToken && token.getTemplate() != null) {
            XmlTemplateToken xmlTemplateToken = (XmlTemplateToken)token;
            final ArrayList<Pair<String, String>> attr2value = new ArrayList<Pair<String, String>>(xmlTemplateToken.getAttribute2Value());
            TemplateImpl modifiedTemplate = token.getTemplate().copy();
            final XmlTag tag = xmlTemplateToken.getTag();
            if (tag != null) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        XmlZenCodingInterpreter.setAttributeValues(tag, attr2value, numberInIteration);
                    }
                });
                String s = XmlZenCodingInterpreter.filterXml(tag, callback, filter);
                assert (s != null);
                if (HtmlUtil.isHtmlBlockTagL(tag.getName())) {
                    boolean newLineBefore = callback.newLineBefore();
                    boolean newLineAfter = callback.newLineAfter();
                    if (!newLineBefore || !newLineAfter) {
                        StringBuilder builder = new StringBuilder();
                        if (!newLineBefore) {
                            builder.append('\n');
                        }
                        builder.append(s);
                        if (!newLineAfter) {
                            builder.append('\n');
                        }
                        s = builder.toString();
                    }
                }
                modifiedTemplate.setString(s);
                XmlZenCodingInterpreter.removeVariablesWhichHasNoSegment(modifiedTemplate);
                Map<String, String> predefinedValues = XmlZenCodingInterpreter.buildPredefinedValues(attr2value, numberInIteration, callback);
                callback.expandTemplate(modifiedTemplate, predefinedValues);
            }
        } else {
            callback.expandTemplate(token.getKey(), null);
        }
    }

    private static void setAttributeValues(XmlTag tag, List<Pair<String, String>> attr2value, int numberInIteration) {
        Iterator<Pair<String, String>> iterator = attr2value.iterator();
        while (iterator.hasNext()) {
            Pair<String, String> pair = iterator.next();
            if (tag.getAttribute((String)pair.first) == null) continue;
            tag.setAttribute((String)pair.first, ZenCodingUtil.getValue(pair, numberInIteration));
            iterator.remove();
        }
    }

    @Nullable
    private static String filterXml(XmlTag tag, CustomTemplateCallback callback, String filterSuffix) {
        PsiElement context = callback.getContext();
        for (ZenCodingFilter filter : (ZenCodingFilter[])ZenCodingFilter.EP_NAME.getExtensions()) {
            if ((filterSuffix != null || !filter.isDefaultFilter()) && (filterSuffix == null || !filterSuffix.equals(filter.getSuffix())) || !(filter instanceof XmlZenCodingFilter) || !filter.isDefaultFilter() || !filter.isMyContext(context)) continue;
            return ((XmlZenCodingFilter)filter).toString(tag, context);
        }
        return new XmlZenCodingFilterImpl().toString(tag, context);
    }

    private void fail() {
        LOG.error("Input string was checked incorrectly during isApplicable() invokation: " + this.myTokens.toString());
    }
}

