/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuessElementTypeMacro
implements Macro {
    public String getName() {
        return "guessElementType";
    }

    public String getDescription() {
        return CodeInsightBundle.message((String)"macro.guess.element.type.of.container", (Object[])new Object[0]);
    }

    public String getDefaultValue() {
        return "A";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/GuessElementTypeMacro.calculateResult must not be null");
        }
        PsiType[] types = GuessElementTypeMacro.guessTypes(params, context);
        if (types == null || types.length == 0) {
            return null;
        }
        return new PsiTypeResult(types[0], context.getProject());
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/GuessElementTypeMacro.calculateQuickResult must not be null");
        }
        return null;
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/GuessElementTypeMacro.calculateLookupItems must not be null");
        }
        PsiType[] types = GuessElementTypeMacro.guessTypes(params, context);
        if (types == null || types.length < 2) {
            return null;
        }
        LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
        for (PsiType type : types) {
            JavaTemplateUtil.addTypeLookupItem(set, type);
        }
        return set.toArray(new LookupElement[set.size()]);
    }

    @Nullable
    private static PsiType[] guessTypes(Expression[] params, ExpressionContext context) {
        if (params.length != 1) {
            return null;
        }
        Result result = params[0].calculateResult(context);
        if (result == null) {
            return null;
        }
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiExpression expr = MacroUtil.resultToPsiExpression(result, context);
        if (expr == null) {
            return null;
        }
        PsiType[] types = GuessManager.getInstance(project).guessContainerElementType(expr, new TextRange(context.getTemplateStartOffset(), context.getTemplateEndOffset()));
        for (int i = 0; i < types.length; ++i) {
            PsiType type = types[i];
            if (!(type instanceof PsiWildcardType)) continue;
            types[i] = ((PsiWildcardType)type).isExtends() ? ((PsiWildcardType)type).getBound() : PsiType.getJavaLangObject((PsiManager)expr.getManager(), (GlobalSearchScope)expr.getResolveScope());
        }
        return types;
    }
}

