/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class TemplateBuilderImpl
implements TemplateBuilder {
    private final RangeMarker myContainerElement;
    private final Map<RangeMarker, Expression> myExpressions;
    private final Map<RangeMarker, String> myVariableExpressions;
    private final Map<RangeMarker, Boolean> myAlwaysStopAtMap;
    private final Map<RangeMarker, String> myVariableNamesMap;
    private final Set<RangeMarker> myElements;
    private RangeMarker myEndElement;
    private RangeMarker mySelection;
    private final Document myDocument;
    private final PsiFile myFile;

    public TemplateBuilderImpl(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/TemplateBuilderImpl.<init> must not be null");
        }
        this.myExpressions = new HashMap<RangeMarker, Expression>();
        this.myVariableExpressions = new HashMap<RangeMarker, String>();
        this.myAlwaysStopAtMap = new HashMap<RangeMarker, Boolean>();
        this.myVariableNamesMap = new HashMap<RangeMarker, String>();
        this.myElements = new TreeSet<RangeMarker>(RangeMarker.BY_START_OFFSET);
        this.myFile = InjectedLanguageUtil.getTopLevelFile(element);
        this.myDocument = this.myFile.getViewProvider().getDocument();
        this.myContainerElement = this.wrapElement(element);
    }

    public void replaceElement(PsiElement element, Expression expression, boolean alwaysStopAt) {
        RangeMarker key = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.replaceElement(key, expression);
    }

    private RangeMarker wrapElement(PsiElement element) {
        return this.myDocument.createRangeMarker(element.getTextRange().shiftRight(PsiUtilBase.findInjectedElementOffsetInRealDocument((PsiElement)element)));
    }

    private RangeMarker wrapReference(PsiReference ref) {
        return this.myDocument.createRangeMarker(ref.getRangeInElement().shiftRight(ref.getElement().getTextRange().getStartOffset() + PsiUtilBase.findInjectedElementOffsetInRealDocument((PsiElement)ref.getElement())));
    }

    public void replaceElement(PsiElement element, String varName, Expression expression, boolean alwaysStopAt) {
        RangeMarker key = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.replaceElement(key, expression);
    }

    public void replaceElement(PsiReference ref, String varName, Expression expression, boolean alwaysStopAt) {
        RangeMarker key = this.wrapReference(ref);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.replaceElement(key, expression);
    }

    private void replaceElement(RangeMarker key, Expression expression) {
        this.myExpressions.put(key, expression);
        this.myElements.add(key);
    }

    public void replaceElement(PsiElement element, String varName, String dependantVariableName, boolean alwaysStopAt) {
        RangeMarker key = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.myVariableExpressions.put(key, dependantVariableName);
        this.myElements.add(key);
    }

    public void replaceElement(PsiReference ref, String varName, String dependantVariableName, boolean alwaysStopAt) {
        RangeMarker key = this.wrapReference(ref);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.myVariableExpressions.put(key, dependantVariableName);
        this.myElements.add(key);
    }

    public void replaceElement(PsiElement element, Expression expression) {
        RangeMarker key = this.wrapElement(element);
        this.myExpressions.put(key, expression);
        this.myElements.add(key);
    }

    public void replaceRange(TextRange rangeWithinElement, String replacementText) {
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(this.myContainerElement.getStartOffset()));
        this.myExpressions.put(key, new ConstantNode(replacementText));
        this.myElements.add(key);
    }

    public void setEndVariableAfter(PsiElement element) {
        element = element.getNextSibling();
        this.setEndVariableBefore(element);
    }

    public void setEndVariableBefore(PsiElement element) {
        if (this.myEndElement != null) {
            this.myElements.remove(this.myEndElement);
        }
        this.myEndElement = this.wrapElement(element);
        this.myElements.add(this.myEndElement);
    }

    public void setSelection(PsiElement element) {
        this.mySelection = this.wrapElement(element);
        this.myElements.add(this.mySelection);
    }

    public Template buildInlineTemplate() {
        Template template = this.buildTemplate();
        template.setInline(true);
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (RangeMarker element : this.myElements) {
            this.myDocument.deleteString(element.getStartOffset(), element.getEndOffset());
        }
        return template;
    }

    public Template buildTemplate() {
        String variableName;
        Expression expression;
        boolean alwaysStopAt;
        Boolean stop;
        TemplateManager manager = TemplateManager.getInstance(this.myFile.getProject());
        Template template = manager.createTemplate("", "");
        String text = this.getDocumentTextFragment(this.myContainerElement.getStartOffset(), this.myContainerElement.getEndOffset());
        int containerStart = this.myContainerElement.getStartOffset();
        int start = 0;
        for (RangeMarker element : this.myElements) {
            int offset = element.getStartOffset() - containerStart;
            template.addTextSegment(text.substring(start, offset));
            if (element == this.mySelection) {
                template.addSelectionStartVariable();
                template.addTextSegment(this.getDocumentTextFragment(this.mySelection.getStartOffset(), this.mySelection.getEndOffset()));
                template.addSelectionEndVariable();
            } else {
                if (element == this.myEndElement) {
                    template.addEndVariable();
                    start = offset;
                    continue;
                }
                stop = this.myAlwaysStopAtMap.get(element);
                alwaysStopAt = stop == null || stop != false;
                expression = this.myExpressions.get(element);
                String string = variableName = this.myVariableNamesMap.get(element) == null ? String.valueOf(expression.hashCode()) : this.myVariableNamesMap.get(element);
                if (expression != null) {
                    template.addVariable(variableName, expression, expression, alwaysStopAt);
                } else {
                    template.addVariableSegment(variableName);
                }
            }
            start = element.getEndOffset() - containerStart;
        }
        template.addTextSegment(text.substring(start));
        for (RangeMarker element : this.myElements) {
            String dependantVariable = this.myVariableExpressions.get(element);
            if (dependantVariable == null) continue;
            stop = this.myAlwaysStopAtMap.get(element);
            alwaysStopAt = stop == null || stop != false;
            expression = this.myExpressions.get(element);
            variableName = this.myVariableNamesMap.get(element) == null ? String.valueOf(expression.hashCode()) : this.myVariableNamesMap.get(element);
            template.addVariable(variableName, dependantVariable, dependantVariable, alwaysStopAt);
        }
        template.setToIndent(false);
        template.setToReformat(false);
        return template;
    }

    private String getDocumentTextFragment(int startOffset, int endOffset) {
        return ((Object)this.myDocument.getCharsSequence().subSequence(startOffset, endOffset)).toString();
    }

    public void replaceElement(PsiElement element, String replacementText) {
        this.replaceElement(element, (Expression)new ConstantNode(replacementText));
    }

    public void replaceElement(PsiElement element, TextRange rangeWithinElement, String replacementText) {
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(element.getTextRange().getStartOffset()));
        this.myExpressions.put(key, new ConstantNode(replacementText));
        this.myElements.add(key);
    }

    public void run() {
        Project project = this.myFile.getProject();
        VirtualFile file = this.myFile.getVirtualFile();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file);
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        Template template = this.buildTemplate();
        editor.getDocument().replaceString(this.myContainerElement.getStartOffset(), this.myContainerElement.getEndOffset(), (CharSequence)"");
        editor.getCaretModel().moveToOffset(this.myContainerElement.getStartOffset());
        TemplateManager.getInstance(this.myFile.getProject()).startTemplate(editor, template);
    }
}

