/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.problems;

import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WolfTheProblemSolverImpl
extends WolfTheProblemSolver {
    private final Map<VirtualFile, ProblemFileInfo> myProblems = new THashMap();
    private final Collection<VirtualFile> myCheckingQueue = new THashSet(10);
    private final Project myProject;
    private final List<WolfTheProblemSolver.ProblemListener> myProblemListeners = ContainerUtil.createEmptyCOWList();
    private final List<Condition<VirtualFile>> myFilters = ContainerUtil.createEmptyCOWList();
    private boolean myFiltersLoaded = false;
    private final WolfTheProblemSolver.ProblemListener fireProblemListeners = new WolfTheProblemSolver.ProblemListener(){

        public void problemsAppeared(VirtualFile file) {
            for (WolfTheProblemSolver.ProblemListener problemListener : WolfTheProblemSolverImpl.this.myProblemListeners) {
                problemListener.problemsAppeared(file);
            }
        }

        public void problemsChanged(VirtualFile file) {
            for (WolfTheProblemSolver.ProblemListener problemListener : WolfTheProblemSolverImpl.this.myProblemListeners) {
                problemListener.problemsChanged(file);
            }
        }

        public void problemsDisappeared(VirtualFile file) {
            for (WolfTheProblemSolver.ProblemListener problemListener : WolfTheProblemSolverImpl.this.myProblemListeners) {
                problemListener.problemsDisappeared(file);
            }
        }
    };
    private final VirtualFileListener myVirtualFileListener = new VirtualFileAdapter(){

        public void fileDeleted(VirtualFileEvent event) {
            this.onDeleted(event.getFile());
        }

        public void fileMoved(VirtualFileMoveEvent event) {
            this.onDeleted(event.getFile());
        }

        private void onDeleted(VirtualFile file) {
            if (file.isDirectory()) {
                WolfTheProblemSolverImpl.this.clearInvalidFiles();
            } else {
                WolfTheProblemSolverImpl.this.doRemove(file);
            }
        }
    };
    private final PsiTreeChangeListener myChangeListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove(VirtualFile problemFile) {
        ProblemFileInfo old;
        Object object = this.myProblems;
        synchronized (object) {
            old = this.myProblems.remove(problemFile);
        }
        object = this.myCheckingQueue;
        synchronized (object) {
            this.myCheckingQueue.remove(problemFile);
        }
        if (old != null) {
            this.fireProblemListeners.problemsDisappeared(problemFile);
        }
    }

    public WolfTheProblemSolverImpl(Project project, PsiManager psiManager, VirtualFileManager virtualFileManager) {
        this.myProject = project;
        this.myChangeListener = new PsiTreeChangeAdapter(){

            public void childAdded(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childRemoved(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childReplaced(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childMoved(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void propertyChanged(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childrenChanged(PsiTreeChangeEvent event) {
                WolfTheProblemSolverImpl.this.clearSyntaxErrorFlag(event);
            }
        };
        psiManager.addPsiTreeChangeListener(this.myChangeListener);
        virtualFileManager.addVirtualFileListener(this.myVirtualFileListener, (Disposable)this.myProject);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager != null) {
            fileStatusManager.addFileStatusListener(new FileStatusListener(){

                public void fileStatusesChanged() {
                    WolfTheProblemSolverImpl.this.clearInvalidFiles();
                }

                public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                    if (virtualFile == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/problems/WolfTheProblemSolverImpl$4.fileStatusChanged must not be null");
                    }
                    this.fileStatusesChanged();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInvalidFiles() {
        VirtualFile[] files;
        Map<VirtualFile, ProblemFileInfo> map = this.myProblems;
        synchronized (map) {
            files = this.myProblems.keySet().toArray(new VirtualFile[this.myProblems.size()]);
        }
        for (VirtualFile problemFile : files) {
            if (problemFile.isValid() && this.isToBeHighlighted(problemFile)) continue;
            this.doRemove(problemFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSyntaxErrorFlag(PsiTreeChangeEvent event) {
        PsiFile file = event.getFile();
        if (file == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Map<VirtualFile, ProblemFileInfo> map = this.myProblems;
        synchronized (map) {
            ProblemFileInfo info = this.myProblems.get(virtualFile);
            if (info == null) {
                return;
            }
            info.hasSyntaxErrors = false;
        }
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("Problems" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/problems/WolfTheProblemSolverImpl.getComponentName must not return null");
        }
        return "Problems";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCheckingIfVincentSolvedProblemsYet(ProgressIndicator progress, ProgressableTextEditorHighlightingPass pass) throws ProcessCanceledException {
        int size;
        ArrayList<VirtualFile> files;
        if (!this.myProject.isOpen()) {
            return;
        }
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            files = new ArrayList<VirtualFile>(this.myCheckingQueue);
            size = files.size();
        }
        pass.setProgressLimit(size);
        final StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        String oldInfo = WolfTheProblemSolverImpl.saveStatusBarInfo(statusBar);
        try {
            for (final VirtualFile virtualFile : files) {
                progress.checkCanceled();
                if (virtualFile == null) {
                    break;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        statusBar.setInfo("Checking '" + virtualFile.getPresentableUrl() + "'");
                    }
                });
                if (!virtualFile.isValid() || this.orderVincentToCleanTheCar(virtualFile, progress)) {
                    this.doRemove(virtualFile);
                }
                pass.advanceProgress(1);
            }
        }
        finally {
            WolfTheProblemSolverImpl.restoreStatusBarInfo(statusBar, oldInfo);
        }
    }

    private boolean orderVincentToCleanTheCar(VirtualFile file, ProgressIndicator progressIndicator) throws ProcessCanceledException {
        if (!this.isToBeHighlighted(file)) {
            this.clearProblems(file);
            return true;
        }
        if (this.hasSyntaxErrors(file)) {
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (this.willBeHighlightedAnyway(file)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile == null) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        try {
            GeneralHighlightingPass pass = new GeneralHighlightingPass(this.myProject, psiFile, document, 0, document.getTextLength(), false){

                @Override
                protected HighlightInfoHolder createInfoHolder(PsiFile file) {
                    return new HighlightInfoHolder(file, HighlightInfoFilter.EMPTY_ARRAY){

                        @Override
                        public boolean add(HighlightInfo info) {
                            if (info != null && info.getSeverity() == HighlightSeverity.ERROR) {
                                throw new HaveGotErrorException(info, myHasErrorElement);
                            }
                            return super.add(info);
                        }
                    };
                }
            };
            pass.collectInformation(progressIndicator);
        }
        catch (HaveGotErrorException e) {
            ProblemImpl problem = new ProblemImpl(file, e.myHighlightInfo, e.myHasErrorElement);
            this.reportProblems(file, Collections.singleton(problem));
            return false;
        }
        this.clearProblems(file);
        return true;
    }

    private static String saveStatusBarInfo(StatusBar statusBar) {
        String oldInfo = null;
        if (statusBar instanceof StatusBarEx) {
            oldInfo = ((StatusBarEx)statusBar).getInfo();
        }
        return oldInfo;
    }

    private static void restoreStatusBarInfo(final StatusBar statusBar, final String oldInfo) {
        if (statusBar instanceof StatusBarEx) {
            LaterInvocator.invokeLater(new Runnable(){

                @Override
                public void run() {
                    statusBar.setInfo(oldInfo);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSyntaxErrors(VirtualFile file) {
        Map<VirtualFile, ProblemFileInfo> map = this.myProblems;
        synchronized (map) {
            ProblemFileInfo info = this.myProblems.get(file);
            return info != null && info.hasSyntaxErrors;
        }
    }

    private boolean willBeHighlightedAnyway(VirtualFile file) {
        FileEditor[] selectedEditors;
        for (FileEditor editor : selectedEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()) {
            if (!(editor instanceof TextEditor)) continue;
            Document document = ((TextEditor)editor).getEditor().getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(document);
            if (psiFile == null || file != psiFile.getVirtualFile()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProblemFilesBeneath(Condition<VirtualFile> condition) {
        if (!this.myProject.isOpen()) {
            return false;
        }
        Map<VirtualFile, ProblemFileInfo> map = this.myProblems;
        synchronized (map) {
            if (!this.myProblems.isEmpty()) {
                Set<VirtualFile> problemFiles = this.myProblems.keySet();
                for (VirtualFile problemFile : problemFiles) {
                    if (!problemFile.isValid() || !condition.value((Object)problemFile)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public boolean hasProblemFilesBeneath(final Module scope) {
        return this.hasProblemFilesBeneath(new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                return ModuleUtil.moduleContainsFile((Module)scope, (VirtualFile)virtualFile, (boolean)false);
            }
        });
    }

    public void addProblemListener(WolfTheProblemSolver.ProblemListener listener) {
        this.myProblemListeners.add(listener);
    }

    public void addProblemListener(final WolfTheProblemSolver.ProblemListener listener, Disposable parentDisposable) {
        this.addProblemListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                WolfTheProblemSolverImpl.this.removeProblemListener(listener);
            }
        });
    }

    public void removeProblemListener(WolfTheProblemSolver.ProblemListener listener) {
        this.myProblemListeners.remove(listener);
    }

    public void registerFileHighlightFilter(final Condition<VirtualFile> filter, Disposable parentDisposable) {
        this.myFilters.add(filter);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                WolfTheProblemSolverImpl.this.myFilters.remove(filter);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(VirtualFile suspiciousFile) {
        if (!this.isToBeHighlighted(suspiciousFile)) {
            return;
        }
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            this.myCheckingQueue.add(suspiciousFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProblemFile(VirtualFile virtualFile) {
        Map<VirtualFile, ProblemFileInfo> map = this.myProblems;
        synchronized (map) {
            return this.myProblems.containsKey(virtualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isToBeHighlighted(VirtualFile virtualFile) {
        if (virtualFile == null) {
            return false;
        }
        List<Condition<VirtualFile>> list = this.myFilters;
        synchronized (list) {
            if (!this.myFiltersLoaded) {
                this.myFiltersLoaded = true;
                Collections.addAll(this.myFilters, Extensions.getExtensions((ExtensionPointName)FILTER_EP_NAME, (AreaInstance)this.myProject));
            }
        }
        for (Condition<VirtualFile> filter : this.myFilters) {
            ProgressManager.checkCanceled();
            if (!filter.value((Object)virtualFile)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void weHaveGotProblems(@NotNull VirtualFile virtualFile, @NotNull List<Problem> problems) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/problems/WolfTheProblemSolverImpl.weHaveGotProblems must not be null");
        }
        if (problems == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/problems/WolfTheProblemSolverImpl.weHaveGotProblems must not be null");
        }
        if (problems.isEmpty()) {
            return;
        }
        if (!this.isToBeHighlighted(virtualFile)) {
            return;
        }
        boolean fireListener = false;
        Object object = this.myProblems;
        synchronized (object) {
            ProblemFileInfo storedProblems = this.myProblems.get(virtualFile);
            if (storedProblems == null) {
                storedProblems = new ProblemFileInfo();
                this.myProblems.put(virtualFile, storedProblems);
                fireListener = true;
            }
            storedProblems.problems.addAll(problems);
        }
        object = this.myCheckingQueue;
        synchronized (object) {
            this.myCheckingQueue.add(virtualFile);
        }
        if (fireListener) {
            this.fireProblemListeners.problemsAppeared(virtualFile);
        }
    }

    public void clearProblems(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/problems/WolfTheProblemSolverImpl.clearProblems must not be null");
        }
        this.doRemove(virtualFile);
    }

    public Problem convertToProblem(VirtualFile virtualFile, final HighlightSeverity severity, final TextRange textRange, final String messageText) {
        if (virtualFile == null || textRange.getStartOffset() < 0 || textRange.getLength() < 0) {
            return null;
        }
        HighlightInfo info = (HighlightInfo)ApplicationManager.getApplication().runReadAction((Computable)new Computable<HighlightInfo>(){

            public HighlightInfo compute() {
                return HighlightInfo.createHighlightInfo(HighlightInfo.convertSeverity(severity), textRange, messageText);
            }
        });
        return new ProblemImpl(virtualFile, info, false);
    }

    public Problem convertToProblem(final VirtualFile virtualFile, final int line, final int column, final String[] message) {
        if (virtualFile == null || virtualFile.isDirectory() || virtualFile.getFileType().isBinary()) {
            return null;
        }
        HighlightInfo info = (HighlightInfo)ApplicationManager.getApplication().runReadAction((Computable)new Computable<HighlightInfo>(){

            public HighlightInfo compute() {
                TextRange textRange = WolfTheProblemSolverImpl.getTextRange(virtualFile, line, column);
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, StringUtil.join((String[])message, (String)"\n"));
            }
        });
        if (info == null) {
            return null;
        }
        return new ProblemImpl(virtualFile, info, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProblems(VirtualFile file, Collection<Problem> problems) {
        boolean fireChanged;
        boolean hasProblemsBefore;
        if (problems.isEmpty()) {
            this.clearProblems(file);
            return;
        }
        if (!this.isToBeHighlighted(file)) {
            return;
        }
        Object object = this.myProblems;
        synchronized (object) {
            ProblemFileInfo oldInfo = this.myProblems.remove(file);
            hasProblemsBefore = oldInfo != null;
            ProblemFileInfo newInfo = new ProblemFileInfo();
            this.myProblems.put(file, newInfo);
            for (Problem problem : problems) {
                newInfo.problems.add(problem);
                newInfo.hasSyntaxErrors = (byte)(newInfo.hasSyntaxErrors | (((ProblemImpl)problem).isSyntaxOnly() ? 1 : 0));
            }
            fireChanged = hasProblemsBefore && !oldInfo.equals(newInfo);
        }
        object = this.myCheckingQueue;
        synchronized (object) {
            this.myCheckingQueue.add(file);
        }
        if (!hasProblemsBefore) {
            this.fireProblemListeners.problemsAppeared(file);
        } else if (fireChanged) {
            this.fireProblemListeners.problemsChanged(file);
        }
    }

    @NotNull
    private static TextRange getTextRange(VirtualFile virtualFile, int line, int column) {
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (line > document.getLineCount()) {
            line = document.getLineCount();
        }
        line = line <= 0 ? 0 : line - 1;
        int offset = document.getLineStartOffset(line) + (column <= 0 ? 0 : column - 1);
        TextRange textRange = new TextRange(offset, offset);
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/problems/WolfTheProblemSolverImpl.getTextRange must not return null");
        }
        return textRange;
    }

    private static class HaveGotErrorException
    extends RuntimeException {
        private final HighlightInfo myHighlightInfo;
        private final boolean myHasErrorElement;

        private HaveGotErrorException(HighlightInfo info, boolean hasErrorElement) {
            this.myHighlightInfo = info;
            this.myHasErrorElement = hasErrorElement;
        }
    }

    private static class ProblemFileInfo {
        private final Collection<Problem> problems = new THashSet();
        private boolean hasSyntaxErrors;

        private ProblemFileInfo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProblemFileInfo that = (ProblemFileInfo)o;
            if (this.hasSyntaxErrors != that.hasSyntaxErrors) {
                return false;
            }
            return ((Object)this.problems).equals(that.problems);
        }

        public int hashCode() {
            int result = ((Object)this.problems).hashCode();
            result = 31 * result + (this.hasSyntaxErrors ? 1 : 0);
            return result;
        }
    }
}

