/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.codeInsight.lookup.RealLookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.PopupIcons;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nullable;

public class LookupCellRenderer
implements ListCellRenderer {
    private Icon myEmptyIcon = new EmptyIcon(5);
    private final Font NORMAL_FONT;
    private final Font BOLD_FONT;
    private final FontMetrics myNormalMetrics;
    private final FontMetrics myBoldMetrics;
    private final int myMaxWidth;
    public static final Color BACKGROUND_COLOR = new Color(235, 244, 254);
    private static final Color FOREGROUND_COLOR = Color.black;
    private static final Color GRAYED_FOREGROUND_COLOR = new Color(160, 160, 160);
    private static final Color SELECTED_BACKGROUND_COLOR = new Color(0, 82, 164);
    private static final Color SELECTED_FOREGROUND_COLOR = Color.white;
    private static final Color SELECTED_GRAYED_FOREGROUND_COLOR = Color.white;
    private static final Color PREFIX_FOREGROUND_COLOR = new Color(176, 0, 176);
    private static final Color SELECTED_PREFIX_FOREGROUND_COLOR = new Color(249, 236, 204);
    private static final Color EMPTY_ITEM_FOREGROUND_COLOR = FOREGROUND_COLOR;
    private static final int MAX_LENGTH = 70;
    private final LookupImpl myLookup;
    private final SimpleColoredComponent myNameComponent;
    private final SimpleColoredComponent myTailComponent;
    private final SimpleColoredComponent myTypeLabel;
    private final JLabel myArrowLabel;
    private final JPanel myPanel;
    public static final Color PREFERRED_BACKGROUND_COLOR = new Color(220, 245, 220);
    private static final String ELLIPSIS = "\u2026";

    public LookupCellRenderer(LookupImpl lookup) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.NORMAL_FONT = scheme.getFont(EditorFontType.PLAIN);
        this.BOLD_FONT = scheme.getFont(EditorFontType.BOLD);
        this.myLookup = lookup;
        this.myNameComponent = new MySimpleColoredComponent();
        this.myNameComponent.setIpad(new Insets(0, 0, 0, 0));
        this.myTailComponent = new MySimpleColoredComponent();
        this.myTailComponent.setIpad(new Insets(0, 0, 0, 0));
        this.myTailComponent.setFont(this.NORMAL_FONT);
        this.myTypeLabel = new MySimpleColoredComponent();
        this.myTypeLabel.setIpad(new Insets(0, 0, 0, 0));
        this.myTypeLabel.setFont(this.NORMAL_FONT);
        this.myArrowLabel = new JLabel("");
        this.myArrowLabel.setOpaque(true);
        this.myPanel = new LookupPanel();
        this.myPanel.add((Component)this.myNameComponent, "West");
        this.myPanel.add((Component)this.myTailComponent, "Center");
        this.myTailComponent.setBorder((Border)new EmptyBorder(0, 0, 0, 10));
        LookupPanel eastPanel = new LookupPanel();
        eastPanel.add((Component)this.myTypeLabel, "West");
        eastPanel.add((Component)this.myArrowLabel, "East");
        this.myPanel.add((Component)eastPanel, "East");
        this.myNormalMetrics = this.myLookup.getEditor().getComponent().getFontMetrics(this.NORMAL_FONT);
        this.myBoldMetrics = this.myLookup.getEditor().getComponent().getFontMetrics(this.BOLD_FONT);
        this.myMaxWidth = this.myNormalMetrics.stringWidth(StringUtil.repeatSymbol((char)'W', (int)70));
        UIUtil.removeQuaquaVisualMarginsIn((Component)this.myPanel);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        LookupElement item = (LookupElement)value;
        Color foreground = isSelected ? SELECTED_FOREGROUND_COLOR : FOREGROUND_COLOR;
        Color background = this.getItemBackground(list, index, isSelected);
        int allowedWidth = list.getFixedCellWidth() - this.getCommonIconWidth();
        RealLookupElementPresentation presentation = new RealLookupElementPresentation(allowedWidth, this.myNormalMetrics, this.myBoldMetrics);
        item.renderElement((LookupElementPresentation)presentation);
        this.myNameComponent.clear();
        this.myNameComponent.setIcon(this.getIcon(presentation.getIcon()));
        this.myNameComponent.setBackground(background);
        allowedWidth -= this.setItemTextLabel(item, foreground, isSelected, (LookupElementPresentation)presentation, allowedWidth);
        this.myTypeLabel.clear();
        if (allowedWidth > 0) {
            allowedWidth -= this.setTypeTextLabel(item, background, foreground, (LookupElementPresentation)presentation, allowedWidth);
        }
        this.myTailComponent.clear();
        this.myTailComponent.setBackground(background);
        if (allowedWidth >= 0) {
            this.setTailTextLabel(isSelected, (LookupElementPresentation)presentation, foreground, allowedWidth);
        }
        this.myArrowLabel.setIcon(this.myLookup.getActionsFor(item).isEmpty() ? PopupIcons.EMPTY_ICON : PopupIcons.HAS_NEXT_ICON_GRAYED);
        this.myArrowLabel.setBackground(background);
        this.myArrowLabel.setForeground(foreground);
        return this.myPanel;
    }

    private Color getItemBackground(JList list, int index, boolean isSelected) {
        int preferredCount = this.myLookup.getPreferredItemsCount();
        if (index <= preferredCount - 1 && preferredCount < list.getModel().getSize() - 1) {
            return isSelected ? SELECTED_BACKGROUND_COLOR : PREFERRED_BACKGROUND_COLOR;
        }
        return isSelected ? SELECTED_BACKGROUND_COLOR : BACKGROUND_COLOR;
    }

    private void setTailTextLabel(boolean isSelected, LookupElementPresentation presentation, Color foreground, int allowedWidth) {
        Color fg = LookupCellRenderer.getTailTextColor(isSelected, presentation, foreground);
        String tailText = StringUtil.notNullize((String)presentation.getTailText());
        int style = 0;
        if (presentation.isStrikeout()) {
            style |= 4;
        }
        SimpleTextAttributes attributes = new SimpleTextAttributes(style, fg);
        if (allowedWidth < 0) {
            return;
        }
        this.myTailComponent.append(LookupCellRenderer.trimLabelText(tailText, allowedWidth, this.myNormalMetrics), attributes);
    }

    private static String trimLabelText(@Nullable String text, int maxWidth, FontMetrics metrics) {
        if (text == null || StringUtil.isEmpty((String)text)) {
            return "";
        }
        int strWidth = RealLookupElementPresentation.getStringWidth((String)text, (FontMetrics)metrics);
        if (strWidth <= maxWidth) {
            return text;
        }
        if (RealLookupElementPresentation.getStringWidth((String)ELLIPSIS, (FontMetrics)metrics) > maxWidth) {
            return "";
        }
        int i = 0;
        int j = text.length();
        while (i + 1 < j) {
            int mid = (i + j) / 2;
            String candidate = text.substring(0, mid) + ELLIPSIS;
            int width = RealLookupElementPresentation.getStringWidth((String)candidate, (FontMetrics)metrics);
            if (width <= maxWidth) {
                i = mid;
                continue;
            }
            j = mid;
        }
        return text.substring(0, i) + ELLIPSIS;
    }

    private static Color getTailTextColor(boolean isSelected, LookupElementPresentation presentation, Color defaultForeground) {
        if (presentation.isTailGrayed()) {
            return isSelected ? SELECTED_GRAYED_FOREGROUND_COLOR : GRAYED_FOREGROUND_COLOR;
        }
        Color tailForeground = presentation.getTailForeground();
        if (tailForeground != null) {
            return tailForeground;
        }
        return defaultForeground;
    }

    private int setItemTextLabel(LookupElement item, Color foreground, boolean selected, LookupElementPresentation presentation, int allowedWidth) {
        int i;
        int style;
        boolean bold = presentation.isItemTextBold();
        this.myNameComponent.setFont(bold ? this.BOLD_FONT : this.NORMAL_FONT);
        int n = style = bold ? 1 : 0;
        if (presentation.isStrikeout()) {
            style |= 4;
        }
        if (presentation.isItemTextUnderlined()) {
            style |= 0x10;
        }
        FontMetrics metrics = bold ? this.myBoldMetrics : this.myNormalMetrics;
        String name = LookupCellRenderer.trimLabelText(presentation.getItemText(), allowedWidth, metrics);
        int used = RealLookupElementPresentation.getStringWidth((String)name, (FontMetrics)metrics);
        SimpleTextAttributes baseAttrs = new SimpleTextAttributes(style, foreground);
        String prefix = item.getPrefixMatcher().getPrefix();
        if (prefix.length() > 0 && (i = StringUtil.indexOfIgnoreCase((String)name, (String)prefix, (int)0)) > 0) {
            this.myNameComponent.append(name.substring(0, i), baseAttrs);
            this.myNameComponent.append(name.substring(i, i + prefix.length()), new SimpleTextAttributes(style, selected ? SELECTED_PREFIX_FOREGROUND_COLOR : PREFIX_FOREGROUND_COLOR));
            this.myNameComponent.append(name.substring(i + prefix.length()), baseAttrs);
            return used;
        }
        this.myNameComponent.append(name, baseAttrs);
        return used;
    }

    private int setTypeTextLabel(LookupElement item, Color background, Color foreground, LookupElementPresentation presentation, int allowedWidth) {
        String givenText = presentation.getTypeText();
        String labelText = LookupCellRenderer.trimLabelText(StringUtil.isEmpty((String)givenText) ? "" : "   " + givenText, allowedWidth, this.myNormalMetrics);
        int used = RealLookupElementPresentation.getStringWidth((String)labelText, (FontMetrics)this.myNormalMetrics);
        Icon icon = presentation.getTypeIcon();
        if (icon != null) {
            this.myTypeLabel.setIcon(icon);
            used += icon.getIconWidth();
        }
        Color sampleBackground = background;
        Object o = item.getObject();
        if (o instanceof LookupValueWithUIHint && StringUtil.isEmpty((String)labelText)) {
            Color proposedBackground = ((LookupValueWithUIHint)o).getColorHint();
            if (proposedBackground != null) {
                sampleBackground = proposedBackground;
            }
            this.myTypeLabel.append("  ");
            used += this.myNormalMetrics.stringWidth("WW");
        } else {
            this.myTypeLabel.append(labelText);
        }
        this.myTypeLabel.setBackground(sampleBackground);
        this.myTypeLabel.setForeground(item instanceof EmptyLookupItem ? EMPTY_ITEM_FOREGROUND_COLOR : foreground);
        return used;
    }

    private Icon getIcon(Icon icon) {
        if (icon == null) {
            return this.myEmptyIcon;
        }
        if (icon.getIconWidth() < this.myEmptyIcon.getIconWidth()) {
            RowIcon rowIcon = new RowIcon(2);
            rowIcon.setIcon(icon, 0);
            rowIcon.setIcon((Icon)new EmptyIcon(this.myEmptyIcon.getIconWidth() - icon.getIconWidth()), 1);
            return rowIcon;
        }
        return icon;
    }

    public int updateMaximumWidth(LookupElement item) {
        LookupElementPresentation p = new LookupElementPresentation();
        item.renderElement(p);
        Icon icon = p.getIcon();
        if (icon != null && icon.getIconWidth() > this.myEmptyIcon.getIconWidth()) {
            this.myEmptyIcon = new EmptyIcon(icon.getIconWidth(), 2);
        }
        int maxWidth = Math.min(RealLookupElementPresentation.calculateWidth((LookupElementPresentation)p, (FontMetrics)this.myNormalMetrics, (FontMetrics)this.myBoldMetrics), this.myMaxWidth);
        return maxWidth + this.getCommonIconWidth();
    }

    private int getCommonIconWidth() {
        return this.myEmptyIcon.getIconWidth() + this.myNameComponent.getIconTextGap() + PopupIcons.HAS_NEXT_ICON_GRAYED.getIconWidth() + this.myNormalMetrics.stringWidth("W");
    }

    public int getIconIndent() {
        return this.myNameComponent.getIconTextGap() + this.myEmptyIcon.getIconWidth();
    }

    private static class LookupPanel
    extends JPanel {
        public LookupPanel() {
            super(new BorderLayout());
        }

        @Override
        public void paint(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            super.paint(g);
        }
    }

    private static class MySimpleColoredComponent
    extends SimpleColoredComponent {
        private MySimpleColoredComponent() {
            this.setFocusBorderAroundIcon(true);
            this.setBorderInsets(new Insets(0, 0, 0, 0));
        }
    }
}

