/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;

public abstract class LookupActionHandler
extends EditorActionHandler {
    protected final EditorActionHandler myOriginalHandler;

    public LookupActionHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public boolean executeInCommand(Editor editor, DataContext dataContext) {
        return LookupManager.getActiveLookup(editor) == null;
    }

    public void execute(Editor editor, DataContext dataContext) {
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (lookup == null) {
            this.myOriginalHandler.execute(editor, dataContext);
            return;
        }
        lookup.markDirty();
        this.executeInLookup(lookup);
    }

    protected abstract void executeInLookup(LookupImpl var1);

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
        return lookup != null || this.myOriginalHandler.isEnabled(editor, dataContext);
    }
}

