/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiFile;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LazyEditor
extends UserDataHolderBase
implements Editor {
    private final PsiFile myFile;
    private Editor myEditor;

    public LazyEditor(PsiFile file) {
        this.myFile = file;
    }

    private Editor getEditor() {
        if (this.myEditor == null) {
            Project project = this.myFile.getProject();
            this.myEditor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, this.myFile.getVirtualFile(), 0), false);
            assert (this.myEditor != null);
        }
        return this.myEditor;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.getEditor().getDocument();
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.getDocument must not return null");
        }
        return document;
    }

    public boolean isViewer() {
        return this.getEditor().isViewer();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.getEditor().getComponent();
        if (jComponent == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.getComponent must not return null");
        }
        return jComponent;
    }

    @NotNull
    public JComponent getContentComponent() {
        JComponent jComponent = this.getEditor().getContentComponent();
        if (jComponent == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.getContentComponent must not return null");
        }
        return jComponent;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.getEditor().getSelectionModel();
        if (selectionModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.getSelectionModel must not return null");
        }
        return selectionModel;
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        MarkupModel markupModel = this.getEditor().getMarkupModel();
        if (markupModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.getMarkupModel must not return null");
        }
        return markupModel;
    }

    @NotNull
    public FoldingModel getFoldingModel() {
        FoldingModel foldingModel = this.getEditor().getFoldingModel();
        if (foldingModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.getFoldingModel must not return null");
        }
        return foldingModel;
    }

    @NotNull
    public ScrollingModel getScrollingModel() {
        ScrollingModel scrollingModel = this.getEditor().getScrollingModel();
        if (scrollingModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.getScrollingModel must not return null");
        }
        return scrollingModel;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModel caretModel = this.getEditor().getCaretModel();
        if (caretModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.getCaretModel must not return null");
        }
        return caretModel;
    }

    @NotNull
    public EditorSettings getSettings() {
        EditorSettings editorSettings = this.getEditor().getSettings();
        if (editorSettings == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.getSettings must not return null");
        }
        return editorSettings;
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = this.getEditor().getColorsScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.getColorsScheme must not return null");
        }
        return editorColorsScheme;
    }

    public int getLineHeight() {
        return this.getEditor().getLineHeight();
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.logicalPositionToXY must not be null");
        }
        Point point = this.getEditor().logicalPositionToXY(pos);
        if (point == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.logicalPositionToXY must not return null");
        }
        return point;
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.logicalPositionToOffset must not be null");
        }
        return this.getEditor().logicalPositionToOffset(pos);
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        if (logicalPos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.logicalToVisualPosition must not be null");
        }
        VisualPosition visualPosition = this.getEditor().logicalToVisualPosition(logicalPos);
        if (visualPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.logicalToVisualPosition must not return null");
        }
        return visualPosition;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        if (visible == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.visualPositionToXY must not be null");
        }
        Point point = this.getEditor().visualPositionToXY(visible);
        if (point == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.visualPositionToXY must not return null");
        }
        return point;
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        if (visiblePos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.visualToLogicalPosition must not be null");
        }
        LogicalPosition logicalPosition = this.getEditor().visualToLogicalPosition(visiblePos);
        if (logicalPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.visualToLogicalPosition must not return null");
        }
        return logicalPosition;
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        LogicalPosition logicalPosition = this.getEditor().offsetToLogicalPosition(offset);
        if (logicalPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.offsetToLogicalPosition must not return null");
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        VisualPosition visualPosition = this.getEditor().offsetToVisualPosition(offset);
        if (visualPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.offsetToVisualPosition must not return null");
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.xyToLogicalPosition must not be null");
        }
        LogicalPosition logicalPosition = this.getEditor().xyToLogicalPosition(p);
        if (logicalPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.xyToLogicalPosition must not return null");
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.xyToVisualPosition must not be null");
        }
        VisualPosition visualPosition = this.getEditor().xyToVisualPosition(p);
        if (visualPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.xyToVisualPosition must not return null");
        }
        return visualPosition;
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.addEditorMouseListener must not be null");
        }
        this.getEditor().addEditorMouseListener(listener);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.removeEditorMouseListener must not be null");
        }
        this.getEditor().removeEditorMouseListener(listener);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.addEditorMouseMotionListener must not be null");
        }
        this.getEditor().addEditorMouseMotionListener(listener);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.removeEditorMouseMotionListener must not be null");
        }
        this.getEditor().removeEditorMouseMotionListener(listener);
    }

    public boolean isDisposed() {
        return this.getEditor().isDisposed();
    }

    @Nullable
    public Project getProject() {
        return this.getEditor().getProject();
    }

    public boolean isInsertMode() {
        return this.getEditor().isInsertMode();
    }

    public boolean isColumnMode() {
        return this.getEditor().isColumnMode();
    }

    public boolean isOneLineMode() {
        return this.getEditor().isOneLineMode();
    }

    @NotNull
    public EditorGutter getGutter() {
        EditorGutter editorGutter = this.getEditor().getGutter();
        if (editorGutter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/LazyEditor.getGutter must not return null");
        }
        return editorGutter;
    }

    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/LazyEditor.getMouseEventArea must not be null");
        }
        return this.getEditor().getMouseEventArea(e);
    }

    public void setHeaderComponent(@Nullable JComponent header) {
        this.getEditor().setHeaderComponent(header);
    }

    public boolean hasHeaderComponent() {
        return this.getEditor().hasHeaderComponent();
    }

    @Nullable
    public JComponent getHeaderComponent() {
        return this.getEditor().getHeaderComponent();
    }

    public IndentsModel getIndentsModel() {
        return this.getEditor().getIndentsModel();
    }
}

