/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PreferredAction;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IntentionListStep
implements ListPopupStep<IntentionActionWithTextCaching>,
SpeedSearchFilter<IntentionActionWithTextCaching> {
    private final Set<IntentionActionWithTextCaching> myCachedIntentions = new THashSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final Set<IntentionActionWithTextCaching> myCachedErrorFixes = new THashSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final Set<IntentionActionWithTextCaching> myCachedInspectionFixes = new THashSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final Set<IntentionActionWithTextCaching> myCachedGutters = new THashSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final IntentionManagerSettings mySettings;
    @Nullable
    private final IntentionHintComponent myIntentionHintComponent;
    private final Editor myEditor;
    private final PsiFile myFile;
    private final Project myProject;
    private static final TObjectHashingStrategy<IntentionActionWithTextCaching> ACTION_TEXT_AND_CLASS_EQUALS = new TObjectHashingStrategy<IntentionActionWithTextCaching>(){

        public int computeHashCode(IntentionActionWithTextCaching object) {
            return object.getText().hashCode();
        }

        public boolean equals(IntentionActionWithTextCaching o1, IntentionActionWithTextCaching o2) {
            return o1.getAction().getClass() == o2.getAction().getClass() && o1.getText().equals(o2.getText());
        }
    };
    private Runnable myFinalRunnable;

    IntentionListStep(@Nullable IntentionHintComponent intentionHintComponent, ShowIntentionsPass.IntentionsInfo intentions, Editor editor, PsiFile file, Project project) {
        this.myIntentionHintComponent = intentionHintComponent;
        this.myEditor = editor;
        this.myFile = file;
        this.myProject = project;
        this.mySettings = IntentionManagerSettings.getInstance();
        this.updateActions(intentions);
    }

    boolean updateActions(ShowIntentionsPass.IntentionsInfo intentions) {
        boolean result = this.wrapActionsTo(intentions.errorFixesToShow, this.myCachedErrorFixes);
        result &= this.wrapActionsTo(intentions.inspectionFixesToShow, this.myCachedInspectionFixes);
        result &= this.wrapActionsTo(intentions.intentionsToShow, this.myCachedIntentions);
        return !(result &= this.wrapActionsTo(intentions.guttersToShow, this.myCachedGutters));
    }

    private boolean wrapActionsTo(List<HighlightInfo.IntentionActionDescriptor> descriptors, Set<IntentionActionWithTextCaching> cachedActions) {
        PsiFile element;
        int fileOffset;
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        int n = fileOffset = caretOffset > 0 && caretOffset == this.myFile.getTextLength() ? caretOffset - 1 : caretOffset;
        if (this.myFile instanceof PsiCompiledElement) {
            element = this.myFile;
        } else if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
            FileViewProvider viewProvider = this.myFile.getViewProvider();
            element = viewProvider.findElementAt(fileOffset, viewProvider.getBaseLanguage());
        } else {
            element = InjectedLanguageUtil.findElementAtNoCommit(this.myFile, fileOffset);
        }
        boolean result = this.removeInvalidActions(cachedActions, (PsiElement)element);
        for (HighlightInfo.IntentionActionDescriptor descriptor : descriptors) {
            IntentionAction action = descriptor.getAction();
            if (!this.isAvailable(action, (PsiElement)element) || element == null) continue;
            IntentionActionWithTextCaching cachedAction = this.wrapAction((PsiElement)element, descriptor);
            result &= !cachedActions.add(cachedAction);
        }
        return result;
    }

    IntentionActionWithTextCaching wrapAction(PsiElement element, HighlightInfo.IntentionActionDescriptor descriptor) {
        IntentionActionWithTextCaching cachedAction = new IntentionActionWithTextCaching(descriptor);
        List<IntentionAction> options = descriptor.getOptions(element);
        if (options != null) {
            for (IntentionAction option : options) {
                boolean isInspectionFix;
                if (!option.isAvailable(this.myProject, this.myEditor, element.getContainingFile())) continue;
                IntentionActionWithTextCaching textCaching = new IntentionActionWithTextCaching(option);
                boolean isErrorFix = this.myCachedErrorFixes.contains(textCaching);
                if (isErrorFix) {
                    cachedAction.addErrorFix(option);
                }
                if (isInspectionFix = this.myCachedInspectionFixes.contains(textCaching)) {
                    cachedAction.addInspectionFix(option);
                    continue;
                }
                cachedAction.addIntention(option);
            }
        }
        return cachedAction;
    }

    private boolean removeInvalidActions(Collection<IntentionActionWithTextCaching> cachedActions, PsiElement element) {
        boolean result = true;
        Iterator<IntentionActionWithTextCaching> iterator = cachedActions.iterator();
        while (iterator.hasNext()) {
            IntentionActionWithTextCaching cachedAction = iterator.next();
            IntentionAction action = cachedAction.getAction();
            if (this.isAvailable(action, element)) continue;
            iterator.remove();
            result = false;
        }
        return result;
    }

    private boolean isAvailable(IntentionAction action, PsiElement element) {
        return ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action, element) != null;
    }

    public String getTitle() {
        return null;
    }

    public boolean isSelectable(IntentionActionWithTextCaching action) {
        return true;
    }

    public PopupStep onChosen(IntentionActionWithTextCaching action, boolean finalChoice) {
        if (finalChoice && !(action.getAction() instanceof EmptyIntentionAction)) {
            this.applyAction(action);
            return FINAL_CHOICE;
        }
        if (this.hasSubstep(action)) {
            return this.getSubStep(action, action.getToolName());
        }
        return FINAL_CHOICE;
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    private void applyAction(final IntentionActionWithTextCaching cachedAction) {
        this.myFinalRunnable = new Runnable(){

            @Override
            public void run() {
                HintManager.getInstance().hideAllHints();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (IntentionListStep.this.myProject.isDisposed()) {
                            return;
                        }
                        PsiDocumentManager.getInstance((Project)IntentionListStep.this.myProject).commitAllDocuments();
                        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)IntentionListStep.this.myEditor, (Project)IntentionListStep.this.myProject);
                        if (file == null) {
                            return;
                        }
                        ShowIntentionActionsHandler.chooseActionAndInvoke(file, IntentionListStep.this.myEditor, cachedAction.getAction(), cachedAction.getText());
                    }
                });
            }
        };
    }

    IntentionListStep getSubStep(IntentionActionWithTextCaching action, final String title) {
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        for (IntentionAction optionIntention : action.getOptionIntentions()) {
            intentions.intentionsToShow.add(new HighlightInfo.IntentionActionDescriptor(optionIntention, IntentionListStep.getIcon(optionIntention)));
        }
        for (IntentionAction optionFix : action.getOptionErrorFixes()) {
            intentions.errorFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        for (IntentionAction optionFix : action.getOptionInspectionFixes()) {
            intentions.inspectionFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        return new IntentionListStep(this.myIntentionHintComponent, intentions, this.myEditor, this.myFile, this.myProject){

            @Override
            public String getTitle() {
                return title;
            }
        };
    }

    private static Icon getIcon(IntentionAction optionIntention) {
        return optionIntention instanceof Iconable ? ((Iconable)optionIntention).getIcon(0) : null;
    }

    public boolean hasSubstep(IntentionActionWithTextCaching action) {
        return action.getOptionIntentions().size() + action.getOptionErrorFixes().size() > 0;
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getValues() {
        ArrayList<IntentionActionWithTextCaching> result = new ArrayList<IntentionActionWithTextCaching>(this.myCachedErrorFixes);
        result.addAll(this.myCachedInspectionFixes);
        result.addAll(this.myCachedIntentions);
        result.addAll(this.myCachedGutters);
        Collections.sort(result, new Comparator<IntentionActionWithTextCaching>(){

            @Override
            public int compare(IntentionActionWithTextCaching o1, IntentionActionWithTextCaching o2) {
                int weight2;
                int weight1 = IntentionListStep.this.getWeight(o1);
                if (weight1 != (weight2 = IntentionListStep.this.getWeight(o2))) {
                    return weight2 - weight1;
                }
                return Comparing.compare((Comparable)((Object)o1.getText()), (Comparable)((Object)o2.getText()));
            }
        });
        ArrayList<IntentionActionWithTextCaching> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/IntentionListStep.getValues must not return null");
        }
        return arrayList;
    }

    private int getWeight(IntentionActionWithTextCaching action) {
        if (action.getAction() instanceof PreferredAction) {
            return 3;
        }
        if (this.myCachedErrorFixes.contains(action)) {
            return 2;
        }
        if (this.myCachedInspectionFixes.contains(action)) {
            return 1;
        }
        if (action.getAction() instanceof EmptyIntentionAction) {
            return -1;
        }
        return 0;
    }

    @NotNull
    public String getTextFor(IntentionActionWithTextCaching action) {
        String string = action.getAction().getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/IntentionListStep.getTextFor must not return null");
        }
        return string;
    }

    public Icon getIconFor(IntentionActionWithTextCaching value) {
        Icon icon;
        if (value.getIcon() != null) {
            return value.getIcon();
        }
        IntentionAction action = value.getAction();
        LocalQuickFix iconable = null;
        if (action instanceof QuickFixWrapper) {
            iconable = ((QuickFixWrapper)action).getFix();
        } else if (action instanceof IntentionActionWrapper) {
            iconable = ((IntentionActionWrapper)action).getDelegate();
        }
        if (iconable instanceof Iconable && (icon = ((Iconable)iconable).getIcon(0)) != null) {
            return icon;
        }
        if (this.mySettings.isShowLightBulb(action)) {
            return this.myCachedErrorFixes.contains(value) ? IntentionHintComponent.ourQuickFixIcon : (this.myCachedInspectionFixes.contains(value) ? IntentionHintComponent.ourBulbIcon : IntentionHintComponent.ourIntentionIcon);
        }
        return this.myCachedErrorFixes.contains(value) ? IntentionHintComponent.ourQuickFixOffIcon : IntentionHintComponent.ourIntentionOffIcon;
    }

    public void canceled() {
        if (this.myIntentionHintComponent != null) {
            this.myIntentionHintComponent.canceled(this);
        }
    }

    public int getDefaultOptionIndex() {
        return 0;
    }

    public ListSeparator getSeparatorAbove(IntentionActionWithTextCaching value) {
        List<IntentionActionWithTextCaching> values = this.getValues();
        int index = values.indexOf(value);
        if (index == 0) {
            return null;
        }
        IntentionActionWithTextCaching prev = values.get(index - 1);
        if (this.getWeight(value) != this.getWeight(prev)) {
            return new ListSeparator();
        }
        return null;
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter<IntentionActionWithTextCaching> getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    public SpeedSearchFilter<IntentionActionWithTextCaching> getSpeedSearchFilter() {
        return this;
    }

    public boolean canBeHidden(IntentionActionWithTextCaching value) {
        return true;
    }

    public String getIndexedString(IntentionActionWithTextCaching value) {
        return this.getTextFor(value);
    }
}

