/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFieldFromParameterAction
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.CreateFieldFromParameterAction");
    private String myName = "";

    @Nullable
    private static PsiType getType(PsiParameter parameter) {
        if (parameter == null) {
            return null;
        }
        PsiType type = parameter.getType();
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).toArrayType();
        }
        return type;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.create.field.from.parameter.text", (Object[])new Object[]{this.myName});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/CreateFieldFromParameterAction.getText must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/CreateFieldFromParameterAction.isAvailable must not be null");
        }
        PsiParameter myParameter = CreateFieldFromParameterAction.findParameterAtCursor(file, editor);
        if (myParameter == null) {
            return false;
        }
        this.myName = myParameter.getName();
        PsiType type = CreateFieldFromParameterAction.getType(myParameter);
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)myParameter, PsiClass.class);
        return myParameter.isValid() && myParameter.getDeclarationScope() instanceof PsiMethod && ((PsiMethod)myParameter.getDeclarationScope()).getBody() != null && myParameter.getManager().isInProject((PsiElement)myParameter) && type != null && type.isValid() && !CreateFieldFromParameterAction.isParameterAssignedToField(myParameter) && targetClass != null && !targetClass.isInterface();
    }

    static boolean isParameterAssignedToField(PsiParameter parameter) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(parameter.getDeclarationScope()), (boolean)false)) {
            PsiElement element;
            PsiExpression lExpression;
            PsiAssignmentExpression assignmentExpression;
            PsiReferenceExpression expression;
            if (!(reference instanceof PsiReferenceExpression) || !((expression = (PsiReferenceExpression)reference).getParent() instanceof PsiAssignmentExpression) || (assignmentExpression = (PsiAssignmentExpression)expression.getParent()).getRExpression() != expression || !((lExpression = assignmentExpression.getLExpression()) instanceof PsiReferenceExpression) || !((element = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static PsiParameter findParameterAtCursor(PsiFile file, Editor editor) {
        PsiParameter[] parameters;
        int offset = editor.getCaretModel().getOffset();
        PsiParameterList parameterList = (PsiParameterList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiParameterList.class, (boolean)false);
        if (parameterList == null) {
            return null;
        }
        for (PsiParameter parameter : parameters = parameterList.getParameters()) {
            TextRange range = parameter.getTextRange();
            if (range.getStartOffset() > offset || offset > range.getEndOffset()) continue;
            return parameter;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.create.field.from.parameter.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/CreateFieldFromParameterAction.getFamilyName must not return null");
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/CreateFieldFromParameterAction.invoke must not be null");
        }
        CreateFieldFromParameterAction.invoke(project, editor, file, !ApplicationManager.getApplication().isUnitTestMode());
    }

    private static void invoke(final Project project, Editor editor, PsiFile file, boolean isInteractive) {
        boolean isFinalToCalc;
        String fieldNameToCalc;
        final PsiParameter myParameter = CreateFieldFromParameterAction.findParameterAtCursor(file, editor);
        if (!CodeInsightUtilBase.prepareFileForWrite(myParameter.getContainingFile())) {
            return;
        }
        IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
        final PsiType type = CreateFieldFromParameterAction.getType(myParameter);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        final String parameterName = myParameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        final PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)myParameter, PsiClass.class);
        final PsiMethod method = (PsiMethod)myParameter.getDeclarationScope();
        final boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind, propertyName, null, type);
        String[] names = suggestedNameInfo.names;
        if (isInteractive) {
            ArrayList<String> namesList = new ArrayList<String>();
            namesList.addAll(Arrays.asList(names));
            String defaultName = styleManager.propertyNameToVariableName(propertyName, kind);
            if (namesList.contains(defaultName)) {
                Collections.swap(namesList, 0, namesList.indexOf(defaultName));
            } else {
                namesList.add(0, defaultName);
            }
            names = ArrayUtil.toStringArray(namesList);
            boolean myBeFinal = method.isConstructor();
            CreateFieldFromParameterDialog dialog = new CreateFieldFromParameterDialog(project, names, type.getCanonicalText(), targetClass, myBeFinal);
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            fieldNameToCalc = dialog.getEnteredName();
            isFinalToCalc = dialog.isDeclareFinal();
            suggestedNameInfo.nameChoosen(fieldNameToCalc);
        } else {
            isFinalToCalc = !isMethodStatic;
            fieldNameToCalc = names[0];
        }
        final boolean isFinal = isFinalToCalc;
        final String fieldName = fieldNameToCalc;
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    PsiField[] fields;
                    PsiCodeBlock methodBody;
                    PsiManager psiManager = PsiManager.getInstance((Project)project);
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
                    PsiField field = factory.createField(fieldName, type);
                    PsiModifierList modifierList = field.getModifierList();
                    modifierList.setModifierProperty("static", isMethodStatic);
                    modifierList.setModifierProperty("final", isFinal);
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)myParameter, (String)"org.jetbrains.annotations.Nullable", (boolean)false)) {
                        modifierList.addAfter((PsiElement)factory.createAnnotationFromText("@org.jetbrains.annotations.Nullable", (PsiElement)field), null);
                    }
                    if ((methodBody = method.getBody()) == null) {
                        return;
                    }
                    PsiStatement[] statements = methodBody.getStatements();
                    Ref anchorRef = new Ref();
                    int i = CreateFieldFromParameterAction.findFieldAssignmentAnchor(statements, (Ref<Pair<PsiField, Boolean>>)anchorRef, targetClass, myParameter);
                    Pair fieldAnchor = (Pair)anchorRef.get();
                    String stmtText = fieldName + " = " + parameterName + ";";
                    if (fieldName.equals(parameterName)) {
                        String prefix = isMethodStatic ? (targetClass.getName() == null ? "" : targetClass.getName() + ".") : "this.";
                        stmtText = prefix + stmtText;
                    }
                    PsiStatement assignmentStmt = factory.createStatementFromText(stmtText, (PsiElement)methodBody);
                    assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)assignmentStmt);
                    if (i == statements.length) {
                        methodBody.add((PsiElement)assignmentStmt);
                    } else {
                        methodBody.addAfter((PsiElement)assignmentStmt, i > 0 ? statements[i - 1] : null);
                    }
                    if (fieldAnchor != null) {
                        PsiVariable psiVariable = (PsiVariable)fieldAnchor.getFirst();
                        psiVariable.normalizeDeclaration();
                    }
                    boolean found = false;
                    for (PsiField f : fields = targetClass.getFields()) {
                        if (!f.getName().equals(field.getName())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        if (fieldAnchor != null) {
                            Boolean insertBefore = (Boolean)fieldAnchor.getSecond();
                            PsiField inField = (PsiField)fieldAnchor.getFirst();
                            if (insertBefore.booleanValue()) {
                                targetClass.addBefore((PsiElement)field, (PsiElement)inField);
                            } else {
                                targetClass.addAfter((PsiElement)field, (PsiElement)inField);
                            }
                        } else {
                            targetClass.add((PsiElement)field);
                        }
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    static int findFieldAssignmentAnchor(PsiStatement[] statements, @Nullable Ref<Pair<PsiField, Boolean>> anchorRef, PsiClass targetClass, PsiParameter myParameter) {
        PsiStatement psiStatement;
        int i;
        for (i = 0; i < statements.length && (psiStatement = statements[i]) instanceof PsiExpressionStatement; ++i) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)psiStatement;
            PsiExpression expression = expressionStatement.getExpression();
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                String text = methodCallExpression.getMethodExpression().getText();
                if (!text.equals("super") && !text.equals("this")) break;
                continue;
            }
            if (!(expression instanceof PsiAssignmentExpression)) break;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            PsiExpression lExpression = assignmentExpression.getLExpression();
            PsiExpression rExpression = assignmentExpression.getRExpression();
            if (!(lExpression instanceof PsiReferenceExpression) || !(rExpression instanceof PsiReferenceExpression)) break;
            PsiReferenceExpression lReference = (PsiReferenceExpression)lExpression;
            PsiReferenceExpression rReference = (PsiReferenceExpression)rExpression;
            PsiElement lElement = lReference.resolve();
            PsiElement rElement = rReference.resolve();
            if (!(lElement instanceof PsiField) || ((PsiField)lElement).getContainingClass() != targetClass || !(rElement instanceof PsiParameter)) break;
            if (myParameter.getTextRange().getStartOffset() < rElement.getTextRange().getStartOffset()) {
                if (anchorRef == null) break;
                anchorRef.set((Object)Pair.create((Object)((PsiField)lElement), (Object)Boolean.TRUE));
                break;
            }
            if (anchorRef == null) continue;
            anchorRef.set((Object)Pair.create((Object)((PsiField)lElement), (Object)Boolean.FALSE));
        }
        return i;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

