/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddOnDemandStaticImportAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.AddOnDemandStaticImportAction");

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.on.demand.static.import.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/AddOnDemandStaticImportAction.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/AddOnDemandStaticImportAction.isAvailable must not be null");
        }
        if (element == null || !PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return false;
        }
        if (!(element instanceof PsiIdentifier) || !(element.getParent() instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression refExpr = (PsiReferenceExpression)element.getParent();
        if (refExpr.getParent() instanceof PsiReferenceExpression && AddOnDemandStaticImportAction.isParameterizedReference((PsiReferenceExpression)refExpr.getParent())) {
            return false;
        }
        PsiElement resolved = refExpr.resolve();
        if (!(resolved instanceof PsiClass)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)resolved;
        PsiFile file = refExpr.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiImportList importList = ((PsiJavaFile)file).getImportList();
        if (importList == null) {
            return false;
        }
        for (PsiImportStaticStatement statement : importList.getImportStaticStatements()) {
            PsiClass staticResolve = statement.resolveTargetClass();
            if (psiClass != staticResolve) continue;
            return false;
        }
        String text = CodeInsightBundle.message((String)"intention.add.on.demand.static.import.text", (Object[])new Object[]{psiClass.getQualifiedName()});
        this.setText(text);
        return true;
    }

    public void invoke(final @NotNull Project project, final Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiFile[] roots;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/AddOnDemandStaticImportAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiReferenceExpression refExpr = (PsiReferenceExpression)element.getParent();
        final PsiClass aClass = (PsiClass)refExpr.resolve();
        PsiImportStaticStatement importStaticStatement = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory().createImportStaticStatement(aClass, "*");
        ((PsiJavaFile)file).getImportList().add((PsiElement)importStaticStatement);
        for (final PsiFile root : roots = file.getPsiRoots()) {
            PsiElement copy = root.copy();
            final PsiManager manager = root.getManager();
            final TIntArrayList expressionToDequalifyOffsets = new TIntArrayList();
            copy.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
                int delta = 0;

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    if (AddOnDemandStaticImportAction.isParameterizedReference(expression)) {
                        return;
                    }
                    PsiExpression qualifierExpression = expression.getQualifierExpression();
                    if (qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).isReferenceTo((PsiElement)aClass)) {
                        try {
                            PsiElement resolved = expression.resolve();
                            if (resolved == null) {
                                return;
                            }
                            int end = expression.getTextRange().getEndOffset();
                            qualifierExpression.delete();
                            this.delta += end - expression.getTextRange().getEndOffset();
                            PsiElement after = expression.resolve();
                            if (manager.areElementsEquivalent(after, resolved)) {
                                expressionToDequalifyOffsets.add(expression.getTextRange().getStartOffset() + this.delta);
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    super.visitElement((PsiElement)expression);
                }
            });
            expressionToDequalifyOffsets.forEachDescending(new TIntProcedure(){

                public boolean execute(int offset) {
                    PsiReferenceExpression expression = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)root, (int)offset, PsiReferenceExpression.class, (boolean)false);
                    PsiExpression qualifierExpression = expression.getQualifierExpression();
                    if (qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).isReferenceTo((PsiElement)aClass)) {
                        qualifierExpression.delete();
                        HighlightManager.getInstance((Project)project).addRangeHighlight(editor, expression.getTextRange().getStartOffset(), expression.getTextRange().getEndOffset(), EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES), false, null);
                    }
                    return true;
                }
            });
        }
    }

    private static boolean isParameterizedReference(PsiReferenceExpression expression) {
        return expression.getParameterList() != null && expression.getParameterList().getFirstChild() != null;
    }
}

