/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.hint.DeclarationRangeUtil;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.LightweightHint;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowContainerInfoHandler
implements CodeInsightActionHandler {
    private static final Key<WeakReference<LightweightHint>> MY_LAST_HINT_KEY = Key.create((String)"MY_LAST_HINT_KEY");
    private static final Key<PsiElement> CONTAINER_KEY = Key.create((String)"CONTAINER_KEY");

    public void invoke(@NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        LightweightHint hint;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/ShowContainerInfoHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/ShowContainerInfoHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/hint/ShowContainerInfoHandler.invoke must not be null");
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement container = null;
        WeakReference ref = (WeakReference)editor.getUserData(MY_LAST_HINT_KEY);
        if (ref != null && (hint = (LightweightHint)ref.get()) != null && hint.isVisible()) {
            hint.hide();
            container = (PsiElement)hint.getUserData(CONTAINER_KEY);
            if (!container.isValid()) {
                container = null;
            }
        }
        if (container == null && (container = file.findElementAt(offset = editor.getCaretModel().getOffset())) == null) {
            return;
        }
        if (file instanceof PsiJavaFile || file instanceof XmlFile) {
            do {
                if ((container = ShowContainerInfoHandler.findContainer(container)) != null) continue;
                return;
            } while (ShowContainerInfoHandler.isDeclarationVisible(container, editor));
        } else {
            block14: {
                StructureViewModel model;
                Object element;
                container = null;
                StructureViewBuilder builder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(file);
                if (builder instanceof TreeBasedStructureViewBuilder && (element = (model = ((TreeBasedStructureViewBuilder)builder).createStructureViewModel()).getCurrentEditorElement()) instanceof PsiElement) {
                    container = (PsiElement)element;
                    block1: while (true) {
                        if (container == null || container instanceof PsiFile) {
                            return;
                        }
                        if (!ShowContainerInfoHandler.isDeclarationVisible(container, editor)) break block14;
                        container = container.getParent();
                        do {
                            if (container == null || DeclarationRangeUtil.getPossibleDeclarationAtRange(container) != null) continue block1;
                        } while (!((container = container.getParent()) instanceof PsiFile));
                        break;
                    }
                    return;
                }
            }
            if (container == null) {
                return;
            }
        }
        final TextRange range = DeclarationRangeUtil.getDeclarationRange(container);
        final PsiElement _container = container;
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                LightweightHint hint = EditorFragmentComponent.showEditorFragmentHint(editor, range, true, true);
                if (hint != null) {
                    hint.putUserData(CONTAINER_KEY, _container);
                    editor.putUserData(MY_LAST_HINT_KEY, new WeakReference<LightweightHint>(hint));
                }
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static PsiElement findContainer(PsiElement element) {
        PsiElement container = element.getParent();
        while (true) {
            if (container instanceof PsiFile) {
                return null;
            }
            if (container instanceof PsiMethod || container instanceof PsiClass || container instanceof PsiClassInitializer || container instanceof XmlTag) break;
            container = container.getParent();
        }
        return container;
    }

    private static boolean isDeclarationVisible(PsiElement container, Editor editor) {
        Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
        TextRange range = DeclarationRangeUtil.getPossibleDeclarationAtRange(container);
        if (range == null) {
            return false;
        }
        LogicalPosition pos = editor.offsetToLogicalPosition(range.getStartOffset());
        Point loc = editor.logicalPositionToXY(pos);
        return loc.y >= viewRect.y;
    }
}

