/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentFragment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.LightweightHint;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

public class DocumentFragmentTooltipRenderer
implements TooltipRenderer {
    private final DocumentFragment myDocumentFragment;

    public DocumentFragmentTooltipRenderer(DocumentFragment documentFragment) {
        this.myDocumentFragment = documentFragment;
    }

    @Override
    public LightweightHint show(Editor editor, Point p, boolean alignToRight, TooltipGroup group) {
        JComponent editorComponent = editor.getComponent();
        TextRange range = this.myDocumentFragment.getTextRange();
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        Document doc = this.myDocumentFragment.getDocument();
        int endLine = doc.getLineNumber(endOffset);
        int startLine = doc.getLineNumber(startOffset);
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        p = editor.logicalPositionToXY(new LogicalPosition(startLine, 0));
        p = SwingUtilities.convertPoint(((EditorEx)editor).getGutterComponentEx(), p, layeredPane);
        p.x -= 3;
        p.y += editor.getLineHeight();
        Point screen = new Point(p);
        SwingUtilities.convertPointToScreen(screen, layeredPane);
        int maxLineCount = (Toolkit.getDefaultToolkit().getScreenSize().height - screen.y) / editor.getLineHeight();
        if (endLine - startLine > maxLineCount) {
            endOffset = doc.getLineEndOffset(Math.min(startLine + maxLineCount, doc.getLineCount() - 1));
        }
        FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
        foldingModel.setFoldingEnabled(false);
        TextRange textRange = new TextRange(startOffset, endOffset);
        LightweightHint hint = EditorFragmentComponent.showEditorFragmentHintAt(editor, textRange, p.x, p.y, false, false, true);
        foldingModel.setFoldingEnabled(true);
        return hint;
    }
}

