/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import org.jetbrains.annotations.NotNull;

public class ClassDeclarationRangeHandler
implements DeclarationRangeHandler {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TextRange getDeclarationRange(@NotNull PsiElement container) {
        PsiReferenceList implementsList;
        int endOffset;
        TextRange textRange;
        if (container == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/ClassDeclarationRangeHandler.getDeclarationRange must not be null");
        }
        PsiClass aClass = (PsiClass)container;
        if (aClass instanceof PsiAnonymousClass) {
            int endOffset2;
            PsiConstructorCall call = (PsiConstructorCall)aClass.getParent();
            int startOffset = call.getTextRange().getStartOffset();
            textRange = new TextRange(startOffset, endOffset2 = call.getArgumentList().getTextRange().getEndOffset());
            if (textRange == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/ClassDeclarationRangeHandler.getDeclarationRange must not return null");
            return textRange;
        }
        PsiModifierList modifierList = aClass.getModifierList();
        int startOffset = modifierList == null ? aClass.getTextRange().getStartOffset() : modifierList.getTextRange().getStartOffset();
        textRange = new TextRange(startOffset, endOffset = (implementsList = aClass.getImplementsList()) == null ? aClass.getTextRange().getEndOffset() : implementsList.getTextRange().getEndOffset());
        if (textRange != null) return textRange;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/ClassDeclarationRangeHandler.getDeclarationRange must not return null");
    }
}

