/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.find.EditorSearchComponent;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageTargetUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightUsagesHandler
extends HighlightHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.highlighting.HighlightUsagesHandler");

    public static void invoke(@NotNull Project project, @NotNull Editor editor, PsiFile file) {
        ResolveResult[] results;
        PsiReference ref;
        PsiElement targetElement;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightUsagesHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightUsagesHandler.invoke must not be null");
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (file == null && !selectionModel.hasSelection()) {
            selectionModel.selectWordAtCaret(false);
        }
        if (file == null || selectionModel.hasSelection()) {
            HighlightUsagesHandler.doRangeHighlighting(editor, project);
            return;
        }
        HighlightUsagesHandlerBase handler = HighlightUsagesHandler.createCustomHandler(editor, file);
        if (handler != null) {
            handler.highlightUsages();
            return;
        }
        UsageTarget[] usageTargets = UsageTargetUtil.findUsageTargets((Editor)editor, (PsiFile)file);
        if (usageTargets == null && (targetElement = HighlightUsagesHandler.getTargetElement(editor, file)) != null) {
            usageTargets = new UsageTarget[]{new PsiElement2UsageTargetAdapter(targetElement)};
        }
        if (usageTargets == null && (ref = TargetElementUtilBase.findReference(editor)) instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)ref).multiResolve(false)).length > 0) {
            usageTargets = new UsageTarget[results.length];
            for (int i = 0; i < results.length; ++i) {
                usageTargets[i] = new PsiElement2UsageTargetAdapter(results[i].getElement());
            }
        }
        if (usageTargets == null) {
            if (file.findElementAt(editor.getCaretModel().getOffset()) instanceof PsiWhiteSpace) {
                return;
            }
            selectionModel.selectWordAtCaret(false);
            String selection = selectionModel.getSelectedText();
            LOG.assertTrue(selection != null);
            for (int i = 0; i < selection.length(); ++i) {
                if (Character.isJavaIdentifierPart(selection.charAt(i))) continue;
                selectionModel.removeSelection();
                return;
            }
            HighlightUsagesHandler.doRangeHighlighting(editor, project);
            selectionModel.removeSelection();
            return;
        }
        boolean clearHighlights = HighlightUsagesHandler.isClearHighlights(editor);
        UsageTarget target = usageTargets[0];
        target.highlightUsages(file, editor, clearHighlights);
    }

    @Nullable
    public static HighlightUsagesHandlerBase createCustomHandler(Editor editor, PsiFile file) {
        for (HighlightUsagesHandlerFactory factory : (HighlightUsagesHandlerFactory[])Extensions.getExtensions(HighlightUsagesHandlerFactory.EP_NAME)) {
            HighlightUsagesHandlerBase handler = factory.createHighlightUsagesHandler(editor, file);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetElement(Editor editor, PsiFile file) {
        int offset;
        PsiElement element;
        PsiElement target = TargetElementUtilBase.findTargetElement(editor, TargetElementUtilBase.getInstance().getReferenceSearchFlags());
        if (target == null && (element = file.findElementAt(offset = TargetElementUtilBase.adjustOffset(editor.getDocument(), editor.getCaretModel().getOffset()))) == null) {
            return null;
        }
        return target;
    }

    private static void doRangeHighlighting(Editor editor, Project project) {
        EditorSearchComponent oldSearch;
        JComponent oldHeader;
        if (!editor.getSelectionModel().hasSelection()) {
            return;
        }
        String text = editor.getSelectionModel().getSelectedText();
        if (text == null) {
            return;
        }
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        if ((oldHeader = editor.getHeaderComponent()) instanceof EditorSearchComponent && (oldSearch = (EditorSearchComponent)oldHeader).hasMatches()) {
            String oldText = oldSearch.getTextInField();
            if (!oldSearch.isRegexp()) {
                oldText = StringUtil.escapeToRegexp((String)oldText);
                oldSearch.setRegexp(true);
            }
            String newText = oldText + '|' + StringUtil.escapeToRegexp((String)text);
            oldSearch.setTextInField(newText);
            return;
        }
        EditorSearchComponent header = new EditorSearchComponent(editor, project);
        editor.setHeaderComponent((JComponent)header);
    }

    public static void highlightOtherOccurrences(List<PsiElement> otherOccurrences, Editor editor, boolean clearHighlights) {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        PsiElement[] elements = otherOccurrences.toArray(new PsiElement[otherOccurrences.size()]);
        HighlightUsagesHandler.doHighlightElements(editor, elements, attributes, clearHighlights);
    }

    public static void highlightReferences(@NotNull Project project, @NotNull PsiElement element, @NotNull List<PsiReference> refs, Editor editor, PsiFile file, boolean clearHighlights) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightUsagesHandler.highlightReferences must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightUsagesHandler.highlightReferences must not be null");
        }
        if (refs == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightUsagesHandler.highlightReferences must not be null");
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        TextAttributes writeAttributes = manager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        HighlightUsagesHandler.setupFindModel(project);
        ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)element);
        if (detector != null) {
            ArrayList<PsiReference> readRefs = new ArrayList<PsiReference>();
            ArrayList<PsiReference> writeRefs = new ArrayList<PsiReference>();
            for (PsiReference ref : refs) {
                if (detector.getReferenceAccess(element, ref) == ReadWriteAccessDetector.Access.Read) {
                    readRefs.add(ref);
                    continue;
                }
                writeRefs.add(ref);
            }
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, readRefs, attributes, clearHighlights);
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, writeRefs, writeAttributes, clearHighlights);
        } else {
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, refs, attributes, clearHighlights);
        }
        TextRange range = HighlightUsagesHandler.getNameIdentifierRange(file, element);
        if (range != null) {
            TextAttributes nameAttributes = attributes;
            if (detector != null && detector.isDeclarationWriteAccess(element)) {
                nameAttributes = writeAttributes;
            }
            HighlightUsagesHandler.highlightRanges(highlightManager, editor, nameAttributes, clearHighlights, Arrays.asList(range));
        }
    }

    @Nullable
    public static TextRange getNameIdentifierRange(PsiFile file, PsiElement element) {
        PsiElement navElement;
        PsiDeclaredTarget declaredTarget;
        TextRange range;
        PomTarget target;
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)element.getProject());
        if (element instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof PsiDeclaredTarget && (range = (declaredTarget = (PsiDeclaredTarget)target).getNameIdentifierRange()) != null && PsiUtilBase.isUnderPsiRoot((PsiFile)file, (PsiElement)(navElement = declaredTarget.getNavigationElement()))) {
            return injectedManager.injectedToHost(navElement, range.shiftRight(navElement.getTextRange().getStartOffset()));
        }
        if (!PsiUtilBase.isUnderPsiRoot((PsiFile)file, (PsiElement)element)) {
            return null;
        }
        PsiElement identifier = HighlightUsagesHandler.getNameIdentifier(element);
        if (identifier != null && PsiUtilBase.isUnderPsiRoot((PsiFile)file, (PsiElement)identifier)) {
            return injectedManager.injectedToHost(identifier, identifier.getTextRange());
        }
        return null;
    }

    public static void doHighlightElements(Editor editor, PsiElement[] elements, TextAttributes attributes, boolean clearHighlights) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
        ArrayList<TextRange> textRanges = new ArrayList<TextRange>(elements.length);
        for (PsiElement element : elements) {
            TextRange range = element.getTextRange();
            range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, range);
            textRanges.add(range);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, attributes, clearHighlights, textRanges);
    }

    public static void highlightRanges(HighlightManager highlightManager, Editor editor, TextAttributes attributes, boolean clearHighlights, List<TextRange> textRanges) {
        if (clearHighlights) {
            HighlightUsagesHandler.clearHighlights(editor, highlightManager, textRanges, attributes);
            return;
        }
        ArrayList highlighters = new ArrayList();
        for (TextRange range : textRanges) {
            highlightManager.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, false, highlighters);
        }
        for (RangeHighlighter highlighter : highlighters) {
            HighlightUsagesHandler.setLineTextErrorStripeTooltip(highlighter);
        }
    }

    public static boolean isClearHighlights(Editor editor) {
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)HighlightManager.getInstance((Project)editor.getProject())).getHighlighters(editor);
        int caretOffset = editor.getCaretModel().getOffset();
        for (RangeHighlighter highlighter : highlighters) {
            if (!new TextRange(highlighter.getStartOffset(), highlighter.getEndOffset()).grown(1).contains(caretOffset)) continue;
            return true;
        }
        return false;
    }

    private static void clearHighlights(Editor editor, HighlightManager highlightManager, List<TextRange> rangesToHighlight, TextAttributes attributes) {
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)highlightManager).getHighlighters(editor);
        Arrays.sort(highlighters, new Comparator<RangeHighlighter>(){

            @Override
            public int compare(RangeHighlighter o1, RangeHighlighter o2) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        Collections.sort(rangesToHighlight, new Comparator<TextRange>(){

            @Override
            public int compare(TextRange o1, TextRange o2) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        int i = 0;
        int j = 0;
        while (i < highlighters.length && j < rangesToHighlight.size()) {
            RangeHighlighter highlighter = highlighters[i];
            TextRange highlighterRange = new TextRange(highlighter.getStartOffset(), highlighter.getEndOffset());
            TextRange refRange = rangesToHighlight.get(j);
            if (refRange.equals((Object)highlighterRange) && attributes.equals((Object)highlighter.getTextAttributes()) && highlighter.getLayer() == 5999) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
                ++i;
                continue;
            }
            if (refRange.getStartOffset() > highlighterRange.getEndOffset()) {
                ++i;
                continue;
            }
            if (refRange.getEndOffset() < highlighterRange.getStartOffset()) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
    }

    private static void doHighlightRefs(HighlightManager highlightManager, @NotNull Editor editor, @NotNull List<PsiReference> refs, TextAttributes attributes, boolean clearHighlights) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightUsagesHandler.doHighlightRefs must not be null");
        }
        if (refs == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightUsagesHandler.doHighlightRefs must not be null");
        }
        ArrayList<TextRange> textRanges = new ArrayList<TextRange>(refs.size());
        for (PsiReference ref : refs) {
            TextRange range = HighlightUsagesHandler.getRangeToHighlight(ref);
            textRanges.add(range);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, attributes, clearHighlights, textRanges);
    }

    public static TextRange getRangeToHighlight(PsiReference ref) {
        PsiElement element = ref.getElement();
        TextRange rangeInElement = ref.getRangeInElement();
        TextRange range = element.getTextRange().cutOut(rangeInElement);
        range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, range);
        return range;
    }

    @Nullable
    public static PsiElement getNameIdentifier(@NotNull PsiElement element) {
        PsiElement potentialIdentifier;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightUsagesHandler.getNameIdentifier must not be null");
        }
        if (element instanceof PsiNameIdentifierOwner) {
            return ((PsiNameIdentifierOwner)element).getNameIdentifier();
        }
        if (element.isPhysical() && element instanceof PsiNamedElement && element.getContainingFile() != null && element.getTextRange() != null && (potentialIdentifier = element.findElementAt(element.getTextOffset() - element.getTextRange().getStartOffset())) != null && Comparing.equal((String)potentialIdentifier.getText(), (String)((PsiNamedElement)element).getName(), (boolean)false)) {
            return potentialIdentifier;
        }
        return null;
    }

    public static void setStatusText(Project project, String elementName, int refCount, boolean clearHighlights) {
        String message = clearHighlights ? "" : (refCount > 0 ? CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.message" : "status.bar.highlighted.usages.no.target.message"), (Object[])new Object[]{refCount, elementName, HighlightUsagesHandler.getShortcutText()}) : CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.not.found.message" : "status.bar.highlighted.usages.not.found.no.target.message"), (Object[])new Object[]{elementName}));
        WindowManager.getInstance().getStatusBar(project).setInfo(message);
    }

    private static String getElementName(PsiElement element) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE);
    }

    public static String getShortcutText() {
        Shortcut shortcut = ActionManager.getInstance().getAction("HighlightUsagesInFile").getShortcutSet().getShortcuts()[0];
        return KeymapUtil.getShortcutText((Shortcut)shortcut);
    }

    public static class DoHighlightRunnable
    implements Runnable {
        private final List<PsiReference> myRefs;
        private final Project myProject;
        private final PsiElement myTarget;
        private final Editor myEditor;
        private final PsiFile myFile;
        private final boolean myClearHighlights;

        public DoHighlightRunnable(@NotNull List<PsiReference> refs, @NotNull Project project, @NotNull PsiElement target, Editor editor, PsiFile file, boolean clearHighlights) {
            if (refs == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightUsagesHandler$DoHighlightRunnable.<init> must not be null");
            }
            if (project == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightUsagesHandler$DoHighlightRunnable.<init> must not be null");
            }
            if (target == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightUsagesHandler$DoHighlightRunnable.<init> must not be null");
            }
            this.myRefs = refs;
            this.myProject = project;
            this.myTarget = target;
            this.myEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
            this.myFile = file;
            this.myClearHighlights = clearHighlights;
        }

        @Override
        public void run() {
            HighlightUsagesHandler.highlightReferences(this.myProject, this.myTarget, this.myRefs, this.myEditor, this.myFile, this.myClearHighlights);
            HighlightUsagesHandler.setStatusText(this.myProject, HighlightUsagesHandler.getElementName(this.myTarget), this.myRefs.size(), this.myClearHighlights);
        }
    }
}

