/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.highlighting.BraceHighlighter;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BraceHighlightingHandler {
    private static final Key<List<RangeHighlighter>> BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY = Key.create((String)"BraceHighlighter.BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY");
    private static final Key<RangeHighlighter> LINE_MARKER_IN_EDITOR_KEY = Key.create((String)"BraceHighlighter.LINE_MARKER_IN_EDITOR_KEY");
    private final Project myProject;
    private final Editor myEditor;
    private final Alarm myAlarm;
    private final DocumentEx myDocument;
    private final PsiFile myPsiFile;
    private final FileType myFileType;
    private final CodeInsightSettings myCodeInsightSettings;

    private BraceHighlightingHandler(@NotNull Project project, @NotNull Editor editor, @NotNull Alarm alarm, PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlightingHandler.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlightingHandler.<init> must not be null");
        }
        if (alarm == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlightingHandler.<init> must not be null");
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myAlarm = alarm;
        this.myDocument = (DocumentEx)this.myEditor.getDocument();
        this.myPsiFile = psiFile;
        this.myCodeInsightSettings = CodeInsightSettings.getInstance();
        this.myFileType = this.myPsiFile == null ? null : this.myPsiFile.getFileType();
    }

    static void lookForInjectedAndMatchBracesInOtherThread(final @NotNull Editor editor, final @NotNull Alarm alarm, final @NotNull Processor<BraceHighlightingHandler> processor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread must not be null");
        }
        if (alarm == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread must not be null");
        }
        final Project project = editor.getProject();
        if (project == null) {
            return;
        }
        final int offset = editor.getCaretModel().getOffset();
        Job job = JobScheduler.getInstance().createJob("Brace highlighter", 100);
        job.addTask(new Runnable(){

            @Override
            public void run() {
                if (BraceHighlightingHandler.isReallyDisposed(editor, project)) {
                    return;
                }
                final PsiFile injected = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

                    public PsiFile compute() {
                        Document document = editor.getDocument();
                        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                        return null != psiFile ? BraceHighlightingHandler.getInjectedFileIfAny(editor, project, offset, psiFile, alarm) : null;
                    }
                });
                ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                    public void run() {
                        if (!BraceHighlightingHandler.isReallyDisposed(editor, project)) {
                            Editor newEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injected);
                            BraceHighlightingHandler handler = new BraceHighlightingHandler(project, newEditor, alarm, injected);
                            processor.process((Object)handler);
                        }
                    }
                }, ModalityState.stateForComponent((Component)editor.getComponent()));
            }
        });
        job.schedule();
    }

    private static boolean isReallyDisposed(Editor editor, Project project) {
        Project editorProject = editor.getProject();
        return editorProject == null || editorProject.isDisposed() || project.isDisposed() || !editor.getComponent().isShowing() || editor.isViewer();
    }

    private static PsiFile getInjectedFileIfAny(final @NotNull Editor editor, final @NotNull Project project, int offset, @NotNull PsiFile psiFile, final @NotNull Alarm alarm) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlightingHandler.getInjectedFileIfAny must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlightingHandler.getInjectedFileIfAny must not be null");
        }
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlightingHandler.getInjectedFileIfAny must not be null");
        }
        if (alarm == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlightingHandler.getInjectedFileIfAny must not be null");
        }
        Document document = editor.getDocument();
        if (!PsiDocumentManager.getInstance((Project)project).isUncommited(document)) {
            PsiFile injected;
            PsiElement injectedElement = InjectedLanguageUtil.findInjectedElementNoCommit(psiFile, offset);
            if (injectedElement != null && (injected = injectedElement.getContainingFile()) != null) {
                return injected;
            }
        } else {
            PsiDocumentManager.getInstance((Project)project).performForCommittedDocument(document, new Runnable(){

                @Override
                public void run() {
                    if (!project.isDisposed() && !editor.isDisposed()) {
                        BraceHighlighter.updateBraces(editor, alarm);
                    }
                }
            });
        }
        return psiFile;
    }

    public void updateBraces() {
        HighlighterIterator i;
        if (this.myPsiFile == null) {
            return;
        }
        this.clearBraceHighlighters();
        if (!this.myCodeInsightSettings.HIGHLIGHT_BRACES) {
            return;
        }
        if (this.myEditor.getSelectionModel().hasSelection()) {
            return;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        if (this.myEditor.offsetToLogicalPosition((int)offset).column != this.myEditor.getCaretModel().getLogicalPosition().column) {
            int caretLineNumber = this.myEditor.getCaretModel().getLogicalPosition().line;
            if (caretLineNumber >= this.myDocument.getLineCount()) {
                return;
            }
            offset = this.myDocument.getLineEndOffset(caretLineNumber) + this.myDocument.getLineSeparatorLength(caretLineNumber);
        }
        int originalOffset = offset;
        HighlighterIterator iterator = this.getEditorHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            --offset;
        } else if (BraceMatchingUtil.isRBraceToken(iterator, chars, this.myFileType)) {
            --offset;
        } else if (!BraceMatchingUtil.isLBraceToken(iterator, chars, this.myFileType) && --offset >= 0 && !BraceMatchingUtil.isRBraceToken(i = this.getEditorHighlighter().createIterator(offset), chars, this.myFileType)) {
            ++offset;
        }
        if (offset < 0) {
            this.removeLineMarkers();
            return;
        }
        iterator = this.getEditorHighlighter().createIterator(offset);
        this.myAlarm.cancelAllRequests();
        if (BraceMatchingUtil.isLBraceToken(iterator, chars, this.myFileType) || BraceMatchingUtil.isRBraceToken(iterator, chars, this.myFileType)) {
            this.doHighlight(offset, originalOffset);
        }
        if (!this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            this.removeLineMarkers();
            return;
        }
        final int _offset = offset;
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!BraceHighlightingHandler.this.myProject.isDisposed() && !BraceHighlightingHandler.this.myEditor.isDisposed()) {
                    BraceHighlightingHandler.this.highlightScope(_offset);
                }
            }
        }, 300);
    }

    private EditorHighlighter getEditorHighlighter() {
        return ((EditorEx)this.myEditor).getHighlighter();
    }

    private void highlightScope(int offset) {
        CharSequence chars;
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        if (this.myEditor.getDocument().getTextLength() <= offset) {
            return;
        }
        HighlighterIterator iterator = this.getEditorHighlighter().createIterator(offset);
        if (BraceMatchingUtil.isStructuralBraceToken(this.myFileType, iterator, chars = this.myDocument.getCharsSequence()) && (BraceMatchingUtil.isRBraceToken(iterator, chars, this.myFileType) || BraceMatchingUtil.isLBraceToken(iterator, chars, this.myFileType))) {
            return;
        }
        if (!BraceMatchingUtil.findStructuralLeftBrace(this.myFileType, iterator, chars)) {
            this.removeLineMarkers();
            return;
        }
        this.highlightLeftBrace(iterator, true);
    }

    private void doHighlight(int offset, int originalOffset) {
        CharSequence chars;
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        HighlighterIterator iterator = this.getEditorHighlighter().createIterator(offset);
        if (BraceMatchingUtil.isLBraceToken(iterator, chars = this.myDocument.getCharsSequence(), this.myFileType)) {
            IElementType tokenType = iterator.getTokenType();
            iterator.advance();
            if (!iterator.atEnd() && BraceMatchingUtil.isRBraceToken(iterator, chars, this.myFileType) && BraceMatchingUtil.isPairBraces(tokenType, iterator.getTokenType(), this.myFileType) && originalOffset == iterator.getStart()) {
                return;
            }
            iterator.retreat();
            this.highlightLeftBrace(iterator, false);
            if (offset > 0 && BraceMatchingUtil.isRBraceToken(iterator = this.getEditorHighlighter().createIterator(offset - 1), chars, this.myFileType)) {
                this.highlightRightBrace(iterator);
            }
        } else if (BraceMatchingUtil.isRBraceToken(iterator, chars, this.myFileType)) {
            this.highlightRightBrace(iterator);
        }
    }

    private void highlightRightBrace(HighlighterIterator iterator) {
        int brace1End = iterator.getEnd();
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), this.myFileType, iterator, false);
        int brace2Start = iterator.atEnd() ? -1 : iterator.getStart();
        this.highlightBraces(brace2Start, brace1End - 1, matched, false);
    }

    private void highlightLeftBrace(HighlighterIterator iterator, boolean scopeHighlighting) {
        int brace1Start = iterator.getStart();
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), this.myFileType, iterator, true);
        int brace2End = iterator.atEnd() ? -1 : iterator.getEnd() - 1;
        this.highlightBraces(brace1Start, brace2End, matched, scopeHighlighting);
    }

    private void highlightBraces(int lBraceOffset, int rBraceOffset, boolean matched, boolean scopeHighlighting) {
        TextAttributes attributes;
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes textAttributes = attributes = matched ? scheme.getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES) : scheme.getAttributes(CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
        if (rBraceOffset >= 0 && !scopeHighlighting) {
            this.highlightBrace(rBraceOffset, matched);
        }
        if (lBraceOffset >= 0 && !scopeHighlighting) {
            this.highlightBrace(lBraceOffset, matched);
        }
        if (!this.myEditor.equals(FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor())) {
            return;
        }
        if (lBraceOffset >= 0 && rBraceOffset >= 0) {
            final int endLine = this.myEditor.offsetToLogicalPosition((int)rBraceOffset).line;
            final int startLine = this.myEditor.offsetToLogicalPosition((int)lBraceOffset).line;
            if (endLine - startLine > 0) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (BraceHighlightingHandler.this.myProject.isDisposed() || BraceHighlightingHandler.this.myEditor.isDisposed()) {
                            return;
                        }
                        Color color = attributes.getBackgroundColor();
                        if (color == null) {
                            return;
                        }
                        color = color.darker();
                        BraceHighlightingHandler.this.lineMarkFragment(startLine, endLine, color);
                    }
                };
                if (!scopeHighlighting) {
                    this.myAlarm.addRequest(runnable, 300);
                } else {
                    runnable.run();
                }
            } else if (!this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
                this.removeLineMarkers();
            }
            if (!scopeHighlighting) {
                this.showScopeHint(lBraceOffset, lBraceOffset + 1);
            }
        } else if (!this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            this.removeLineMarkers();
        }
    }

    private void highlightBrace(int rBraceOffset, boolean matched) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = matched ? scheme.getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES) : scheme.getAttributes(CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
        RangeHighlighter rbraceHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(rBraceOffset, rBraceOffset + 1, 6001, attributes, HighlighterTargetArea.EXACT_RANGE);
        rbraceHighlighter.setGreedyToLeft(false);
        rbraceHighlighter.setGreedyToRight(false);
        this.registerHighlighter(rbraceHighlighter);
    }

    private void registerHighlighter(RangeHighlighter highlighter) {
        ArrayList<RangeHighlighter> highlighters = (ArrayList<RangeHighlighter>)this.myEditor.getUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY);
        if (highlighters == null) {
            highlighters = new ArrayList<RangeHighlighter>();
            this.myEditor.putUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY, highlighters);
        }
        highlighters.add(highlighter);
    }

    private void showScopeHint(final int lbraceStart, final int lbraceEnd) {
        LogicalPosition bracePosition = this.myEditor.offsetToLogicalPosition(lbraceStart);
        Point braceLocation = this.myEditor.logicalPositionToXY(bracePosition);
        final int y = braceLocation.y;
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!BraceHighlightingHandler.this.myEditor.getComponent().isShowing()) {
                    return;
                }
                Rectangle viewRect = BraceHighlightingHandler.this.myEditor.getScrollingModel().getVisibleArea();
                if (y < viewRect.y) {
                    int start = lbraceStart;
                    if (!(BraceHighlightingHandler.this.myPsiFile instanceof PsiPlainTextFile)) {
                        PsiDocumentManager.getInstance((Project)BraceHighlightingHandler.this.myProject).commitAllDocuments();
                        start = BraceMatchingUtil.getBraceMatcher(BraceHighlightingHandler.this.myFileType, PsiUtilBase.getLanguageAtOffset((PsiFile)BraceHighlightingHandler.this.myPsiFile, (int)lbraceStart)).getCodeConstructStart(BraceHighlightingHandler.this.myPsiFile, lbraceStart);
                    }
                    TextRange range = new TextRange(start, lbraceEnd);
                    int line1 = BraceHighlightingHandler.this.myDocument.getLineNumber(range.getStartOffset());
                    int line2 = BraceHighlightingHandler.this.myDocument.getLineNumber(range.getEndOffset());
                    line1 = Math.max(line1, line2 - 5);
                    range = new TextRange(BraceHighlightingHandler.this.myDocument.getLineStartOffset(line1), range.getEndOffset());
                    EditorFragmentComponent.showEditorFragmentHint(BraceHighlightingHandler.this.myEditor, range, true, true);
                }
            }
        }, 300, ModalityState.stateForComponent((Component)this.myEditor.getComponent()));
    }

    public void clearBraceHighlighters() {
        List highlighters = (List)this.myEditor.getUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY);
        if (highlighters == null) {
            return;
        }
        this.myEditor.putUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY, null);
        Iterator i$ = highlighters.iterator();
        while (i$.hasNext()) {
            RangeHighlighter highlighter;
            RangeHighlighter rangeHighlighter = highlighter = (RangeHighlighter)i$.next();
            this.myEditor.getMarkupModel().removeHighlighter(rangeHighlighter);
        }
    }

    private void lineMarkFragment(int startLine, int endLine, Color color) {
        this.removeLineMarkers();
        if (startLine >= endLine || endLine >= this.myDocument.getLineCount()) {
            return;
        }
        int startOffset = this.myDocument.getLineStartOffset(startLine);
        int endOffset = this.myDocument.getLineStartOffset(endLine);
        RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 0, null, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new MyLineMarkerRenderer(color));
        this.myEditor.putUserData(LINE_MARKER_IN_EDITOR_KEY, (Object)highlighter);
    }

    private void removeLineMarkers() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighter marker = (RangeHighlighter)this.myEditor.getUserData(LINE_MARKER_IN_EDITOR_KEY);
        if (marker != null && ((MarkupModelEx)this.myEditor.getMarkupModel()).containsHighlighter(marker)) {
            this.myEditor.getMarkupModel().removeHighlighter(marker);
        }
        this.myEditor.putUserData(LINE_MARKER_IN_EDITOR_KEY, null);
    }

    private static class MyLineMarkerRenderer
    implements LineMarkerRenderer {
        private static final int DEEPNESS = 2;
        private static final int THICKNESS = 2;
        private final Color myColor;

        private MyLineMarkerRenderer(Color color) {
            this.myColor = color;
        }

        public void paint(Editor editor, Graphics g, Rectangle r) {
            int height = r.height + editor.getLineHeight();
            g.setColor(this.myColor);
            g.fillRect(r.x, r.y, 2, height);
            g.fillRect(r.x + 2, r.y, 2, 2);
            g.fillRect(r.x + 2, r.y + height - 2, 2, 2);
        }
    }
}

