/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.codeInsight.template.impl.SurroundWithTemplateHandler;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.WrapWithCustomTemplateAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PopupActionChooser {
    private final String myTitle;
    private boolean hasEnabledSurrounders;

    public PopupActionChooser(String title) {
        this.myTitle = title;
    }

    public void invoke(Project project, Editor editor, PsiFile file, Surrounder[] surrounders, PsiElement[] elements) {
        DefaultActionGroup applicable = new DefaultActionGroup();
        this.hasEnabledSurrounders = false;
        HashSet<Character> usedMnemonicsSet = new HashSet<Character>();
        int index = 0;
        for (Surrounder surrounder : surrounders) {
            if (!surrounder.isApplicable(elements)) continue;
            char mnemonic = index < 9 ? (char)((char)(48 + index + 1)) : (index == 9 ? (char)'0' : (char)(65 + index - 10));
            ++index;
            usedMnemonicsSet.add(Character.valueOf(Character.toUpperCase(mnemonic)));
            applicable.add((AnAction)new InvokeSurrounderAction(surrounder, project, editor, elements, mnemonic));
            this.hasEnabledSurrounders = true;
        }
        List<CustomLiveTemplate> customTemplates = SurroundWithTemplateHandler.getApplicableCustomTemplates(editor, file);
        ArrayList<TemplateImpl> templates = SurroundWithTemplateHandler.getApplicableTemplates(editor, file, true);
        if (!templates.isEmpty() || !customTemplates.isEmpty()) {
            applicable.addSeparator("Live templates");
        }
        for (TemplateImpl template : templates) {
            applicable.add((AnAction)new InvokeTemplateAction(template, editor, project, usedMnemonicsSet));
            this.hasEnabledSurrounders = true;
        }
        for (CustomLiveTemplate customTemplate : customTemplates) {
            applicable.add((AnAction)new WrapWithCustomTemplateAction(customTemplate, editor, file, usedMnemonicsSet));
            this.hasEnabledSurrounders = true;
        }
        if (!templates.isEmpty() || !customTemplates.isEmpty()) {
            applicable.addSeparator();
            applicable.add((AnAction)new ConfigureTemplatesAction());
        }
        if (this.hasEnabledSurrounders) {
            DataContext context = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(this.myTitle, (ActionGroup)applicable, context, JBPopupFactory.ActionSelectionAid.MNEMONICS, true);
            popup.showInBestPositionFor(editor);
        }
    }

    public boolean isHasEnabledSurrounders() {
        return this.hasEnabledSurrounders;
    }

    private static class ConfigureTemplatesAction
    extends AnAction {
        private ConfigureTemplatesAction() {
            super("Configure Live Templates...");
        }

        public void actionPerformed(AnActionEvent e) {
            ShowSettingsUtil.getInstance().showSettingsDialog((Project)e.getData(PlatformDataKeys.PROJECT), "Live Templates");
        }
    }

    private static class InvokeSurrounderAction
    extends AnAction {
        private final Surrounder mySurrounder;
        private final Project myProject;
        private final Editor myEditor;
        private final PsiElement[] myElements;

        public InvokeSurrounderAction(Surrounder surrounder, Project project, Editor editor, PsiElement[] elements, char mnemonic) {
            super('\u001b' + String.valueOf(mnemonic) + ". " + surrounder.getTemplateDescription());
            this.mySurrounder = surrounder;
            this.myProject = project;
            this.myEditor = editor;
            this.myElements = elements;
        }

        public void actionPerformed(AnActionEvent e) {
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            SurroundWithHandler.doSurround(InvokeSurrounderAction.this.myProject, InvokeSurrounderAction.this.myEditor, InvokeSurrounderAction.this.mySurrounder, InvokeSurrounderAction.this.myElements);
                        }
                    };
                    ApplicationManager.getApplication().runWriteAction(action);
                }
            }, null, null);
        }
    }
}

