/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenerationInfo {
    public static final GenerationInfo[] EMPTY_ARRAY = new GenerationInfo[0];

    public abstract void insert(PsiClass var1, PsiElement var2, boolean var3) throws IncorrectOperationException;

    public abstract PsiMember getPsiMember();

    @Nullable
    public PsiElement findInsertionAnchor(@NotNull PsiClass aClass, @NotNull PsiElement leaf) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/GenerationInfo.findInsertionAnchor must not be null");
        }
        if (leaf == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/generation/GenerationInfo.findInsertionAnchor must not be null");
        }
        PsiElement element = leaf;
        while (element.getParent() != aClass) {
            element = element.getParent();
        }
        PsiJavaToken lBrace = aClass.getLBrace();
        if (lBrace == null) {
            return null;
        }
        PsiJavaToken rBrace = aClass.getRBrace();
        if (!GenerateMembersUtil.isChildInRange(element, lBrace.getNextSibling(), (PsiElement)rBrace)) {
            return null;
        }
        PsiElement prev = leaf.getPrevSibling();
        if (prev != null && prev.getNode() != null && prev.getNode().getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            element = leaf.getNextSibling();
        }
        return element;
    }
}

