/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateMembersUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateMembersUtil");

    private GenerateMembersUtil() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersAtOffset(PsiFile file, int offset, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        PsiField field;
        PsiTypeElement typeElement;
        PsiElement element;
        List<T> list;
        if (memberPrototypes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/generation/GenerateMembersUtil.insertMembersAtOffset must not be null");
        }
        if (memberPrototypes.isEmpty()) {
            list = memberPrototypes;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/GenerateMembersUtil.insertMembersAtOffset must not return null");
            return list;
        }
        PsiElement leaf = file.findElementAt(offset);
        if (leaf == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/GenerateMembersUtil.insertMembersAtOffset must not return null");
            return list;
        }
        PsiClass aClass = GenerateMembersUtil.findClassAtOffset(file, leaf);
        if (aClass == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/GenerateMembersUtil.insertMembersAtOffset must not return null");
            return list;
        }
        PsiElement anchor = ((GenerationInfo)memberPrototypes.get(0)).findInsertionAnchor(aClass, leaf);
        if (anchor instanceof PsiWhiteSpace) {
            ASTNode spaceNode = anchor.getNode();
            anchor = anchor.getNextSibling();
            assert (spaceNode != null);
            if (spaceNode.getStartOffset() <= offset && spaceNode.getStartOffset() + spaceNode.getTextLength() >= offset) {
                ASTNode singleNewLineWhitespace = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory().createWhiteSpaceFromText(spaceNode.getText().substring(0, offset - spaceNode.getStartOffset())).getNode();
                spaceNode.getTreeParent().replaceChild(spaceNode, singleNewLineWhitespace);
            }
        }
        for (element = anchor; !(element == null || element instanceof PsiField || element instanceof PsiMethod || element instanceof PsiClassInitializer); element = element.getNextSibling()) {
        }
        if (element instanceof PsiField && (typeElement = (field = (PsiField)element).getTypeElement()) != null && !field.equals(typeElement.getParent())) {
            field.normalizeDeclaration();
            anchor = field;
        }
        if ((list = GenerateMembersUtil.insertMembersBeforeAnchor(aClass, anchor, memberPrototypes)) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/GenerateMembersUtil.insertMembersAtOffset must not return null");
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersBeforeAnchor(PsiClass aClass, PsiElement anchor, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        if (memberPrototypes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/generation/GenerateMembersUtil.insertMembersBeforeAnchor must not be null");
        }
        boolean before = true;
        for (GenerationInfo memberPrototype : memberPrototypes) {
            memberPrototype.insert(aClass, anchor, before);
            before = false;
            anchor = memberPrototype.getPsiMember();
        }
        List<T> list = memberPrototypes;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/GenerateMembersUtil.insertMembersBeforeAnchor must not return null");
        }
        return list;
    }

    public static void positionCaret(@NotNull Editor editor, @NotNull PsiElement firstMember, boolean toEditMethodBody) {
        PsiMethod method;
        PsiCodeBlock body;
        PsiMethod method2;
        PsiCodeBlock body2;
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/GenerateMembersUtil.positionCaret must not be null");
        }
        if (firstMember == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/generation/GenerateMembersUtil.positionCaret must not be null");
        }
        LOG.assertTrue(firstMember.isValid());
        if (toEditMethodBody && (body2 = (method2 = (PsiMethod)firstMember).getBody()) != null) {
            PsiElement l = body2.getFirstBodyElement();
            while (l instanceof PsiWhiteSpace) {
                l = l.getNextSibling();
            }
            if (l == null) {
                l = body2;
            }
            PsiElement r = body2.getLastBodyElement();
            while (r instanceof PsiWhiteSpace) {
                r = r.getPrevSibling();
            }
            if (r == null) {
                r = body2;
            }
            int start = l.getTextRange().getStartOffset();
            int end = r.getTextRange().getEndOffset();
            editor.getCaretModel().moveToOffset(Math.min(start, end));
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (start < end) {
                editor.getSelectionModel().setSelection(start, end);
            }
            return;
        }
        int offset = firstMember instanceof PsiMethod ? ((body = (method = (PsiMethod)firstMember).getBody()) == null ? method.getTextRange().getStartOffset() : body.getLBrace().getTextRange().getEndOffset()) : firstMember.getTextRange().getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    public static PsiElement insert(PsiClass aClass, PsiMember member, PsiElement anchor, boolean before) throws IncorrectOperationException {
        if (member instanceof PsiMethod && !aClass.isInterface()) {
            PsiParameter[] parameters = ((PsiMethod)member).getParameterList().getParameters();
            boolean generateFinals = CodeStyleSettingsManager.getSettings((Project)aClass.getProject()).GENERATE_FINAL_PARAMETERS;
            for (PsiParameter parameter : parameters) {
                PsiModifierList modifierList = parameter.getModifierList();
                assert (modifierList != null);
                modifierList.setModifierProperty("final", generateFinals);
            }
        }
        if (anchor != null) {
            return before ? aClass.addBefore((PsiElement)member, anchor) : aClass.addAfter((PsiElement)member, anchor);
        }
        return aClass.add((PsiElement)member);
    }

    @Nullable
    private static PsiClass findClassAtOffset(PsiFile file, PsiElement leaf) {
        for (PsiElement element = leaf; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.isEnum()) {
                PsiElement lastChild = null;
                for (PsiElement child : psiClass.getChildren()) {
                    if (child instanceof PsiJavaToken && ";".equals(child.getText())) {
                        lastChild = child;
                        break;
                    }
                    if ((!(child instanceof PsiJavaToken) || !",".equals(child.getText())) && !(child instanceof PsiEnumConstant)) continue;
                    lastChild = child;
                }
                if (lastChild != null) {
                    int adjustedOffset = lastChild.getTextRange().getEndOffset();
                    if (leaf.getTextRange().getEndOffset() <= adjustedOffset) {
                        return GenerateMembersUtil.findClassAtOffset(file, file.findElementAt(adjustedOffset));
                    }
                }
            }
            return psiClass;
        }
        return null;
    }

    public static PsiMethod substituteGenericMethod(PsiMethod method, PsiSubstitutor substitutor) {
        Project project = method.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        PsiTypeParameter[] typeParams = method.getTypeParameters();
        try {
            PsiClassType[] thrownTypes;
            PsiMethod newMethod;
            PsiType returnType = method.getReturnType();
            if (method.isConstructor()) {
                newMethod = factory.createConstructor();
                newMethod.getNameIdentifier().replace((PsiElement)factory.createIdentifier(method.getName()));
            } else {
                newMethod = factory.createMethod(method.getName(), GenerateMembersUtil.substituteType(substitutor, returnType));
            }
            VisibilityUtil.setVisibility((PsiModifierList)newMethod.getModifierList(), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList()));
            PsiElement navigationElement = method.getNavigationElement();
            PsiDocComment docComment = ((PsiDocCommentOwner)navigationElement).getDocComment();
            if (docComment != null) {
                newMethod.addAfter((PsiElement)docComment, null);
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            HashMap m = new HashMap();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiType parameterType = parameter.getType();
                PsiType substituted = GenerateMembersUtil.substituteType(substitutor, parameterType);
                String paramName = parameter.getName();
                String[] baseSuggestions = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)parameterType).names;
                boolean isBaseNameGenerated = false;
                for (String s : baseSuggestions) {
                    if (!s.equals(paramName)) continue;
                    isBaseNameGenerated = true;
                    break;
                }
                if (paramName == null || isBaseNameGenerated && !substituted.equals(parameterType)) {
                    Pair pair = (Pair)m.get(substituted);
                    if (pair != null) {
                        paramName = (String)pair.first + pair.second;
                        m.put(substituted, Pair.create((Object)pair.first, (Object)((Integer)pair.second + 1)));
                    } else {
                        String[] names = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)substituted).names;
                        paramName = names.length > 0 ? names[0] : "p" + i;
                        m.put(substituted, new Pair((Object)paramName, (Object)1));
                    }
                }
                if (paramName == null) {
                    paramName = "p" + i;
                }
                PsiParameter newParameter = factory.createParameter(paramName, substituted);
                if (parameter.getLanguage() == StdLanguages.JAVA) {
                    newParameter.getModifierList().replace((PsiElement)parameter.getModifierList());
                }
                newMethod.getParameterList().add((PsiElement)newParameter);
            }
            for (PsiTypeParameter typeParam : typeParams) {
                if (substitutor.substitute(typeParam) == null) continue;
                newMethod.getTypeParameterList().add((PsiElement)typeParam);
            }
            for (PsiClassType thrownType : thrownTypes = method.getThrowsList().getReferencedTypes()) {
                newMethod.getThrowsList().add((PsiElement)factory.createReferenceElementByType((PsiClassType)GenerateMembersUtil.substituteType(substitutor, (PsiType)thrownType)));
            }
            return newMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return method;
        }
    }

    private static PsiType substituteType(PsiSubstitutor substitutor, PsiType type) {
        PsiType psiType = substitutor.substitute(type);
        if (psiType != null) {
            return psiType;
        }
        return TypeConversionUtil.erasure((PsiType)type);
    }

    public static PsiSubstitutor correctSubstitutor(PsiMethod method, PsiSubstitutor substitutor) {
        PsiClass hisClass = method.getContainingClass();
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (typeParameters.length > 0 && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)hisClass, (PsiSubstitutor)substitutor)) {
            substitutor = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createRawSubstitutor(substitutor, typeParameters);
        }
        return substitutor;
    }

    public static boolean isChildInRange(PsiElement child, PsiElement first, PsiElement last) {
        if (child.equals(first)) {
            return true;
        }
        do {
            if (child.equals(first)) {
                return false;
            }
            if (!child.equals(last)) continue;
            return true;
        } while ((child = child.getNextSibling()) != null);
        return false;
    }
}

