/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.DocumentFoldingInfo;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.util.containers.WeakList;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFoldingManagerImpl
extends CodeFoldingManager
implements ProjectComponent {
    private final Project myProject;
    private final WeakList<Document> myDocumentsWithFoldingInfo = new WeakList();
    private final Key<DocumentFoldingInfo> FOLDING_INFO_IN_DOCUMENT_KEY = Key.create((String)"FOLDING_INFO_IN_DOCUMENT_KEY");
    private static final Key<Boolean> FOLDING_STATE_INFO_IN_DOCUMENT_KEY = Key.create((String)"FOLDING_STATE_IN_DOCUMENT");

    CodeFoldingManagerImpl(Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(Document doc) {
                CodeFoldingManagerImpl.resetFoldingInfo(doc);
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("CodeFoldingManagerImpl" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.getComponentName must not return null");
        }
        return "CodeFoldingManagerImpl";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        for (Document document : this.myDocumentsWithFoldingInfo) {
            if (document == null) continue;
            document.putUserData(this.FOLDING_INFO_IN_DOCUMENT_KEY, null);
        }
    }

    public void projectOpened() {
        final EditorMouseMotionAdapter myMouseMotionListener = new EditorMouseMotionAdapter(){
            LightweightHint myCurrentHint = null;
            FoldRegion myCurrentFold = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseMoved(EditorMouseEvent e) {
                if (CodeFoldingManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (e.getArea() != EditorMouseEventArea.FOLDING_OUTLINE_AREA) {
                    return;
                }
                LightweightHint hint = null;
                try {
                    Editor editor = e.getEditor();
                    if (PsiDocumentManager.getInstance((Project)CodeFoldingManagerImpl.this.myProject).isUncommited(editor.getDocument())) {
                        return;
                    }
                    MouseEvent mouseEvent = e.getMouseEvent();
                    FoldRegion fold = ((EditorEx)editor).getGutterComponentEx().findFoldingAnchorAt(mouseEvent.getX(), mouseEvent.getY());
                    if (fold == null) {
                        return;
                    }
                    if (fold == this.myCurrentFold && this.myCurrentHint != null) {
                        hint = this.myCurrentHint;
                        return;
                    }
                    TextRange psiElementRange = EditorFoldingInfo.get(editor).getPsiElementRange(fold);
                    if (psiElementRange == null) {
                        return;
                    }
                    int textOffset = psiElementRange.getStartOffset();
                    Point foldStartXY = editor.visualPositionToXY(editor.offsetToVisualPosition(textOffset));
                    Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
                    if (visibleArea.y > foldStartXY.y) {
                        if (this.myCurrentHint != null) {
                            this.myCurrentHint.hide();
                            this.myCurrentHint = null;
                        }
                        TextRange textRange = new TextRange(textOffset, fold.getStartOffset());
                        hint = EditorFragmentComponent.showEditorFragmentHint(editor, textRange, true, true);
                        this.myCurrentFold = fold;
                        this.myCurrentHint = hint;
                    }
                }
                finally {
                    if (hint == null) {
                        if (this.myCurrentHint != null) {
                            this.myCurrentHint.hide();
                            this.myCurrentHint = null;
                        }
                        this.myCurrentFold = null;
                    }
                }
            }
        };
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                EditorFactory.getInstance().getEventMulticaster().addEditorMouseMotionListener((EditorMouseMotionListener)myMouseMotionListener, (Disposable)CodeFoldingManagerImpl.this.myProject);
            }
        });
    }

    @Override
    public void releaseFoldings(Editor editor) {
        Project project = editor.getProject();
        if (project != null && !project.equals(this.myProject)) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file == null || !file.getViewProvider().isPhysical() || !file.isValid()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
        Editor[] otherEditors = EditorFactory.getInstance().getEditors(document, this.myProject);
        if (otherEditors.length == 0) {
            this.getDocumentFoldingInfo(document).loadFromEditor(editor);
        }
        EditorFoldingInfo.get(editor).dispose();
    }

    @Override
    public void buildInitialFoldings(final Editor editor) {
        Project project = editor.getProject();
        if (project == null || !project.equals(this.myProject)) {
            return;
        }
        final Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file == null || !file.getViewProvider().isPhysical() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!((FoldingModelEx)editor.getFoldingModel()).isFoldingEnabled()) {
            return;
        }
        if (project.isDisposed() || editor.isDisposed() || !file.isValid()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
        Runnable operation = new Runnable(){

            @Override
            public void run() {
                Editor[] editors;
                Runnable runnable = CodeFoldingManagerImpl.this.updateFoldRegions(editor, true, true);
                if (runnable != null) {
                    runnable.run();
                }
                DocumentFoldingInfo documentFoldingInfo = CodeFoldingManagerImpl.this.getDocumentFoldingInfo(document);
                for (Editor otherEditor : editors = EditorFactory.getInstance().getEditors(document, CodeFoldingManagerImpl.this.myProject)) {
                    if (otherEditor == editor) continue;
                    documentFoldingInfo.loadFromEditor(otherEditor);
                    break;
                }
                documentFoldingInfo.setToEditor(editor);
                documentFoldingInfo.clear();
            }
        };
        editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret(operation);
    }

    public void projectClosed() {
    }

    @Override
    public FoldRegion findFoldRegion(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.findFoldRegion must not be null");
        }
        return FoldingUtil.findFoldRegion(editor, startOffset, endOffset);
    }

    @Override
    public FoldRegion[] getFoldRegionsAtOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.getFoldRegionsAtOffset must not be null");
        }
        return FoldingUtil.getFoldRegionsAtOffset(editor, offset);
    }

    @Override
    public void updateFoldRegions(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.updateFoldRegions must not be null");
        }
        this.updateFoldRegions(editor, false);
    }

    public void updateFoldRegions(Editor editor, boolean quick) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        Runnable runnable = this.updateFoldRegions(editor, false, quick);
        if (runnable != null) {
            runnable.run();
        }
    }

    @Override
    public void forceDefaultState(final @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.forceDefaultState must not be null");
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        Runnable runnable = this.updateFoldRegions(editor, true, false);
        if (runnable != null) {
            runnable.run();
        }
        final FoldRegion[] regions = editor.getFoldingModel().getAllFoldRegions();
        editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                EditorFoldingInfo foldingInfo = EditorFoldingInfo.get(editor);
                for (FoldRegion region : regions) {
                    PsiElement element = foldingInfo.getPsiElement(region);
                    if (element == null) continue;
                    region.setExpanded(!FoldingPolicy.isCollapseByDefault(element));
                }
            }
        });
    }

    @Override
    @Nullable
    public Runnable updateFoldRegionsAsync(@NotNull Editor editor, boolean firstTime) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.updateFoldRegionsAsync must not be null");
        }
        return this.updateFoldRegions(editor, firstTime, false);
    }

    @Nullable
    private Runnable updateFoldRegions(Editor editor, boolean applyDefaultState, boolean quick) {
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        if (file != null) {
            editor.getDocument().putUserData(FOLDING_STATE_INFO_IN_DOCUMENT_KEY, (Object)Boolean.TRUE);
            return FoldingUpdate.updateFoldRegions(editor, file, applyDefaultState, quick);
        }
        return null;
    }

    @Override
    public CodeFoldingState saveFoldingState(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.saveFoldingState must not be null");
        }
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(editor.getDocument());
        info.loadFromEditor(editor);
        return info;
    }

    @Override
    public void restoreFoldingState(@NotNull Editor editor, @NotNull CodeFoldingState state) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.restoreFoldingState must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.restoreFoldingState must not be null");
        }
        ((DocumentFoldingInfo)state).setToEditor(editor);
    }

    @Override
    public void writeFoldingState(@NotNull CodeFoldingState state, @NotNull Element element) throws WriteExternalException {
        if (state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.writeFoldingState must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.writeFoldingState must not be null");
        }
        ((DocumentFoldingInfo)state).writeExternal(element);
    }

    @Override
    public CodeFoldingState readFoldingState(@NotNull Element element, @NotNull Document document) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.readFoldingState must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.readFoldingState must not be null");
        }
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(document);
        info.readExternal(element);
        return info;
    }

    private DocumentFoldingInfo getDocumentFoldingInfo(Document document) {
        DocumentFoldingInfo info = (DocumentFoldingInfo)document.getUserData(this.FOLDING_INFO_IN_DOCUMENT_KEY);
        if (info == null) {
            info = new DocumentFoldingInfo(this.myProject, document);
            document.putUserData(this.FOLDING_INFO_IN_DOCUMENT_KEY, (Object)info);
            this.myDocumentsWithFoldingInfo.add((Object)document);
        }
        return info;
    }

    private static void resetFoldingInfo(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl.resetFoldingInfo must not be null");
        }
        Boolean foldingInfoStatus = (Boolean)document.getUserData(FOLDING_STATE_INFO_IN_DOCUMENT_KEY);
        if (Boolean.TRUE.equals(foldingInfoStatus)) {
            Editor[] editors;
            for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
                EditorFoldingInfo.resetInfo(editor);
            }
            document.putUserData(FOLDING_STATE_INFO_IN_DOCUMENT_KEY, null);
        }
    }
}

