/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.WordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;

public class DocTagSelectioner
extends WordSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiDocTag;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        PsiElement child;
        int childStartOffset;
        List<TextRange> result = super.select(e, editorText, cursorOffset, editor);
        TextRange range = e.getTextRange();
        int endOffset = range.getEndOffset();
        int startOffset = range.getStartOffset();
        PsiElement[] children = e.getChildren();
        for (int i = children.length - 1; i >= 0 && (childStartOffset = (child = children[i]).getTextRange().getStartOffset()) > cursorOffset; --i) {
            if (child instanceof PsiDocToken) {
                PsiDocToken token = (PsiDocToken)child;
                IElementType type = token.getTokenType();
                char[] chars = token.textToCharArray();
                int shift = CharArrayUtil.shiftForward((char[])chars, (int)0, (String)" \t\n\r");
                if (shift != chars.length && type != JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) {
                    break;
                }
            } else if (!(child instanceof PsiWhiteSpace)) break;
            endOffset = Math.min(childStartOffset, endOffset);
        }
        startOffset = CharArrayUtil.shiftBackward((CharSequence)editorText, (int)(startOffset - 1), (String)"* \t") + 1;
        result.add(new TextRange(startOffset, endOffset));
        return result;
    }
}

