/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.impl.source.jsp.jspJava.JspMethodCall;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;

public class MethodCallFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        PsiExpressionList args = null;
        if (psiElement instanceof PsiMethodCallExpression && !(psiElement instanceof JspMethodCall)) {
            args = ((PsiMethodCallExpression)psiElement).getArgumentList();
        } else if (psiElement instanceof PsiNewExpression) {
            args = ((PsiNewExpression)psiElement).getArgumentList();
        }
        if (args == null) {
            return;
        }
        PsiElement parenth = args.getLastChild();
        if (parenth == null || !")".equals(parenth.getText())) {
            PsiExpression[] params;
            int endOffset = -1;
            for (PsiElement child = args.getFirstChild(); child != null; child = child.getNextSibling()) {
                PsiErrorElement errorElement;
                if (!(child instanceof PsiErrorElement) || (errorElement = (PsiErrorElement)child).getErrorDescription().indexOf("')'") < 0) continue;
                endOffset = errorElement.getTextRange().getStartOffset();
                break;
            }
            if (endOffset == -1) {
                endOffset = args.getTextRange().getEndOffset();
            }
            if ((params = args.getExpressions()).length > 0 && this.startLine(editor, (PsiElement)args) != this.startLine(editor, (PsiElement)params[0])) {
                endOffset = args.getTextRange().getStartOffset() + 1;
            }
            endOffset = CharArrayUtil.shiftBackward((CharSequence)editor.getDocument().getCharsSequence(), (int)(endOffset - 1), (String)" \t\n") + 1;
            editor.getDocument().insertString(endOffset, (CharSequence)")");
        }
    }

    private int startLine(Editor editor, PsiElement psiElement) {
        return editor.getDocument().getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

