/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.awt.Component;
import java.util.List;

public class UnSelectWordHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public UnSelectWordHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void execute(Editor editor, DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, dataContext);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UnSelectWordHandler.doAction(editor, file);
    }

    private static void doAction(Editor editor, PsiFile file) {
        PsiElement anotherElement;
        PsiElement element;
        if (!editor.getSelectionModel().hasSelection()) {
            return;
        }
        CharSequence text = editor.getDocument().getCharsSequence();
        int caretOffset = editor.getCaretModel().getOffset();
        if (caretOffset > 0 && !Character.isJavaIdentifierPart(text.charAt(caretOffset)) && Character.isJavaIdentifierPart(text.charAt(caretOffset - 1))) {
            --caretOffset;
        }
        if ((element = file.findElementAt(caretOffset)) instanceof PsiWhiteSpace && caretOffset > 0 && !((anotherElement = file.findElementAt(caretOffset - 1)) instanceof PsiWhiteSpace)) {
            element = anotherElement;
        }
        while (element instanceof PsiWhiteSpace) {
            if (element.getNextSibling() == null) {
                element = element.getParent();
            }
            element = element.getNextSibling();
            caretOffset = element.getTextRange().getStartOffset();
        }
        if (element != null) {
            file = element.getContainingFile();
        }
        TextRange selectionRange = new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        TextRange newRange = null;
        while (element != null && element.getContainingFile() == file) {
            TextRange range = UnSelectWordHandler.advance(selectionRange, element, text, caretOffset, editor);
            if (range != null && (newRange == null || range.contains(newRange))) {
                newRange = range;
            }
            element = element.getParent();
        }
        if (newRange == null) {
            editor.getSelectionModel().setSelection(caretOffset, caretOffset);
        } else {
            editor.getSelectionModel().setSelection(newRange.getStartOffset(), newRange.getEndOffset());
        }
    }

    private static TextRange advance(TextRange selectionRange, PsiElement element, CharSequence text, int cursorOffset, Editor editor) {
        TextRange maximum = null;
        for (ExtendWordSelectionHandler selectioner : SelectWordUtil.getExtendWordSelectionHandlers()) {
            List ranges;
            if (!selectioner.canSelect(element) || (ranges = selectioner.select(element, text, cursorOffset, editor)) == null) continue;
            for (TextRange range : ranges) {
                if (range == null || range.isEmpty() || !selectionRange.contains(range) || range.equals((Object)selectionRange) || !range.contains(cursorOffset) && cursorOffset != range.getEndOffset() || maximum != null && !range.contains(maximum)) continue;
                maximum = range;
            }
        }
        return maximum;
    }
}

