/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;

public class DeclarationJoinLinesHandler
implements JoinLinesHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler");

    public int tryJoinLines(Document document, PsiFile file, int start, int end) {
        PsiExpression initializerExpression;
        PsiElement elementAtStartLineEnd = file.findElementAt(start);
        PsiElement elementAtNextLineStart = file.findElementAt(end);
        if (elementAtStartLineEnd == null || elementAtNextLineStart == null) {
            return -1;
        }
        if (!(elementAtStartLineEnd instanceof PsiJavaToken)) {
            return -1;
        }
        PsiJavaToken lastFirstLineToken = (PsiJavaToken)elementAtStartLineEnd;
        if (lastFirstLineToken.getTokenType() != JavaTokenType.SEMICOLON) {
            return -1;
        }
        if (!(lastFirstLineToken.getParent() instanceof PsiLocalVariable)) {
            return -1;
        }
        PsiLocalVariable var = (PsiLocalVariable)lastFirstLineToken.getParent();
        if (!(var.getParent() instanceof PsiDeclarationStatement)) {
            return -1;
        }
        PsiDeclarationStatement decl = (PsiDeclarationStatement)var.getParent();
        if (decl.getDeclaredElements().length > 1) {
            return -1;
        }
        if (!(elementAtNextLineStart instanceof PsiJavaToken)) {
            return -1;
        }
        PsiJavaToken firstNextLineToken = (PsiJavaToken)elementAtNextLineStart;
        if (firstNextLineToken.getTokenType() != JavaTokenType.IDENTIFIER) {
            return -1;
        }
        if (!(firstNextLineToken.getParent() instanceof PsiReferenceExpression)) {
            return -1;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)firstNextLineToken.getParent();
        PsiElement refResolved = ref.resolve();
        PsiManager psiManager = ref.getManager();
        if (!psiManager.areElementsEquivalent(refResolved, (PsiElement)var)) {
            return -1;
        }
        if (!(ref.getParent() instanceof PsiAssignmentExpression)) {
            return -1;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ref.getParent();
        if (!(assignment.getParent() instanceof PsiExpressionStatement)) {
            return -1;
        }
        if (ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope((PsiElement)assignment.getRExpression()), (boolean)false).findFirst() != null) {
            return -1;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        IElementType originalOpSign = assignment.getOperationSign().getTokenType();
        if (originalOpSign == JavaTokenType.EQ) {
            initializerExpression = assignment.getRExpression();
        } else {
            if (var.getInitializer() == null) {
                return -1;
            }
            String opSign = null;
            if (originalOpSign == JavaTokenType.ANDEQ) {
                opSign = "&";
            } else if (originalOpSign == JavaTokenType.ASTERISKEQ) {
                opSign = "*";
            } else if (originalOpSign == JavaTokenType.DIVEQ) {
                opSign = "/";
            } else if (originalOpSign == JavaTokenType.GTGTEQ) {
                opSign = ">>";
            } else if (originalOpSign == JavaTokenType.GTGTGTEQ) {
                opSign = ">>>";
            } else if (originalOpSign == JavaTokenType.LTLTEQ) {
                opSign = "<<";
            } else if (originalOpSign == JavaTokenType.MINUSEQ) {
                opSign = "-";
            } else if (originalOpSign == JavaTokenType.OREQ) {
                opSign = "|";
            } else if (originalOpSign == JavaTokenType.PERCEQ) {
                opSign = "%";
            } else if (originalOpSign == JavaTokenType.PLUSEQ) {
                opSign = "+";
            } else if (originalOpSign == JavaTokenType.XOREQ) {
                opSign = "^";
            }
            try {
                initializerExpression = factory.createExpressionFromText(var.getInitializer().getText() + opSign + assignment.getRExpression().getText(), (PsiElement)var);
                initializerExpression = (PsiExpression)CodeStyleManager.getInstance((PsiManager)psiManager).reformat((PsiElement)initializerExpression);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return -1;
            }
        }
        PsiExpressionStatement statement = (PsiExpressionStatement)assignment.getParent();
        int startOffset = decl.getTextRange().getStartOffset();
        try {
            PsiDeclarationStatement newDecl = factory.createVariableDeclarationStatement(var.getName(), var.getType(), initializerExpression);
            PsiVariable newVar = (PsiVariable)newDecl.getDeclaredElements()[0];
            if (var.getModifierList().getText().length() > 0) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)newVar, (String)"final", (boolean)true);
            }
            newVar.getModifierList().replace((PsiElement)var.getModifierList());
            PsiVariable variable = (PsiVariable)newDecl.getDeclaredElements()[0];
            int offsetBeforeEQ = variable.getNameIdentifier().getTextRange().getEndOffset();
            int offsetAfterEQ = variable.getInitializer().getTextRange().getStartOffset() + 1;
            newDecl = (PsiDeclarationStatement)CodeStyleManager.getInstance((PsiManager)psiManager).reformatRange((PsiElement)newDecl, offsetBeforeEQ, offsetAfterEQ);
            decl.replace((PsiElement)newDecl);
            statement.delete();
            return startOffset + newDecl.getTextRange().getEndOffset() - newDecl.getTextRange().getStartOffset();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return -1;
        }
    }
}

