/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class BraceMatcherBasedSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        FileType fileType;
        VirtualFile file = e.getContainingFile().getVirtualFile();
        FileType fileType2 = fileType = file == null ? null : file.getFileType();
        if (fileType == null) {
            return super.select(e, editorText, cursorOffset, editor);
        }
        TextRange totalRange = e.getTextRange();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(totalRange.getStartOffset());
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        LinkedList<Pair> stack = new LinkedList<Pair>();
        while (!iterator.atEnd() && iterator.getStart() < totalRange.getEndOffset()) {
            if (braceMatcher.isLBraceToken(iterator, editorText, fileType)) {
                stack.addLast(Pair.create((Object)iterator.getStart(), (Object)iterator.getTokenType()));
            } else if (braceMatcher.isRBraceToken(iterator, editorText, fileType) && !stack.isEmpty()) {
                Pair last = (Pair)stack.getLast();
                if (braceMatcher.isPairBraces((IElementType)last.second, iterator.getTokenType())) {
                    stack.removeLast();
                    int start = (Integer)last.first;
                    result.addAll(BraceMatcherBasedSelectioner.expandToWholeLine(editorText, new TextRange(start, iterator.getEnd())));
                    int bodyStart = start + 1;
                    int bodyEnd = iterator.getEnd() - 1;
                    while (Character.isWhitespace(editorText.charAt(bodyStart))) {
                        ++bodyStart;
                    }
                    while (Character.isWhitespace(editorText.charAt(bodyEnd - 1))) {
                        --bodyEnd;
                    }
                    result.addAll(BraceMatcherBasedSelectioner.expandToWholeLine(editorText, new TextRange(bodyStart, bodyEnd)));
                }
            }
            iterator.advance();
        }
        result.add(e.getTextRange());
        return result;
    }
}

