/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import java.util.HashMap;

public class VariableParameterizedTypeFix {
    public static void registerIntentions(HighlightInfo highlightInfo, PsiVariable variable, PsiReferenceParameterList parameterList) {
        PsiType type = variable.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        if (DumbService.getInstance((Project)variable.getProject()).isDumb()) {
            return;
        }
        String shortName = ((PsiClassType)type).getClassName();
        PsiManager manager = parameterList.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiShortNamesCache shortNamesCache = facade.getShortNamesCache();
        PsiClass[] classes = shortNamesCache.getClassesByName(shortName, GlobalSearchScope.allScope((Project)manager.getProject()));
        PsiElementFactory factory = facade.getElementFactory();
        for (PsiClass aClass : classes) {
            if (GenericsHighlightUtil.checkReferenceTypeArgumentList((PsiTypeParameterListOwner)aClass, parameterList, PsiSubstitutor.EMPTY, false) != null) continue;
            PsiType[] actualTypeParameters = parameterList.getTypeArguments();
            PsiTypeParameter[] classTypeParameters = aClass.getTypeParameters();
            HashMap<PsiTypeParameter, PsiType> map = new HashMap<PsiTypeParameter, PsiType>();
            for (int j = 0; j < classTypeParameters.length; ++j) {
                PsiTypeParameter classTypeParameter = classTypeParameters[j];
                PsiType actualTypeParameter = actualTypeParameters[j];
                map.put(classTypeParameter, actualTypeParameter);
            }
            PsiSubstitutor substitutor = factory.createSubstitutor(map);
            PsiClassType suggestedType = factory.createType(aClass, substitutor);
            HighlightUtil.registerChangeVariableTypeFixes(variable, (PsiType)suggestedType, highlightInfo);
        }
    }
}

