/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RenameWrongRefFix
implements IntentionAction {
    private final PsiReferenceExpression myRefExpr;
    @NonNls
    private static final String INPUT_VARIABLE_NAME = "INPUTVAR";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OTHERVAR";

    public RenameWrongRefFix(PsiReferenceExpression refExpr) {
        this.myRefExpr = refExpr;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("rename.wrong.reference.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RenameWrongRefFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("rename.wrong.reference.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RenameWrongRefFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RenameWrongRefFix.isAvailable must not be null");
        }
        if (!this.myRefExpr.isValid() || !this.myRefExpr.getManager().isInProject((PsiElement)this.myRefExpr)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement refName = this.myRefExpr.getReferenceNameElement();
        if (refName == null) {
            return false;
        }
        TextRange textRange = refName.getTextRange();
        if (textRange == null || offset < textRange.getStartOffset() || offset > textRange.getEndOffset()) {
            return false;
        }
        return !CreateFromUsageUtils.isValidReference((PsiReference)this.myRefExpr, false);
    }

    private LookupElement[] collectItems() {
        boolean qualified;
        LinkedHashSet<LookupElementBuilder> items = new LinkedHashSet<LookupElementBuilder>();
        boolean bl = qualified = this.myRefExpr.getQualifierExpression() != null;
        if (!qualified && !(this.myRefExpr.getParent() instanceof PsiMethodCallExpression)) {
            PsiVariable[] vars;
            for (PsiVariable var : vars = CreateFromUsageUtils.guessMatchingVariables((PsiExpression)this.myRefExpr)) {
                items.add(LookupElementBuilder.create((String)var.getName()));
            }
        } else {
            PsiElement[] variants;
            class MyScopeProcessor
            extends BaseScopeProcessor {
                ArrayList<PsiElement> myResult = new ArrayList();
                boolean myFilterMethods;
                boolean myFilterStatics = false;

                MyScopeProcessor(PsiReferenceExpression refExpression) {
                    this.myFilterMethods = refExpression.getParent() instanceof PsiMethodCallExpression;
                    PsiExpression qualifier = refExpression.getQualifierExpression();
                    if (qualifier instanceof PsiReferenceExpression) {
                        PsiElement e = ((PsiReferenceExpression)qualifier).resolve();
                        this.myFilterStatics = e instanceof PsiClass;
                    } else if (qualifier == null) {
                        PsiModifierListOwner scope = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiModifierListOwner.class);
                        this.myFilterStatics = scope != null && scope.hasModifierProperty("static");
                    }
                }

                public boolean execute(PsiElement element, ResolveState state) {
                    if (element instanceof PsiNamedElement && element instanceof PsiModifierListOwner && this.myFilterMethods == element instanceof PsiMethod && ((PsiModifierListOwner)element).hasModifierProperty("static") == this.myFilterStatics) {
                        this.myResult.add(element);
                    }
                    return true;
                }

                public PsiElement[] getVariants() {
                    return this.myResult.toArray(new PsiElement[this.myResult.size()]);
                }
            }
            MyScopeProcessor processor = new MyScopeProcessor(this.myRefExpr);
            this.myRefExpr.processVariants((PsiScopeProcessor)processor);
            for (PsiElement variant : variants = processor.getVariants()) {
                items.add(LookupElementBuilder.create((String)((PsiNamedElement)variant).getName()));
            }
        }
        return items.toArray(new LookupElement[items.size()]);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RenameWrongRefFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiReferenceExpression[] refs = CreateFromUsageUtils.collectExpressions((PsiExpression)this.myRefExpr, PsiMember.class, PsiFile.class);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)this.myRefExpr, (Class[])new Class[]{PsiMember.class, PsiFile.class});
            LookupElement[] items = this.collectItems();
            ReferenceNameExpression refExpr = new ReferenceNameExpression(items, this.myRefExpr.getReferenceName());
            TemplateBuilderImpl builder = new TemplateBuilderImpl(element);
            for (PsiReferenceExpression expr : refs) {
                if (!expr.equals(this.myRefExpr)) {
                    builder.replaceElement(expr.getReferenceNameElement(), OTHER_VARIABLE_NAME, INPUT_VARIABLE_NAME, false);
                    continue;
                }
                builder.replaceElement(expr.getReferenceNameElement(), INPUT_VARIABLE_NAME, (Expression)refExpr, true);
            }
            float proportion = EditorUtil.calcVerticalScrollProportion(editor);
            editor.getCaretModel().moveToOffset(element.getTextRange().getStartOffset());
            Template template = builder.buildInlineTemplate();
            editor.getCaretModel().moveToOffset(element.getTextRange().getStartOffset());
            TemplateManager.getInstance(project).startTemplate(editor, template);
            EditorUtil.setVerticalScrollProportion(editor, proportion);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private class ReferenceNameExpression
    extends Expression {
        LookupElement[] myItems;
        private final String myOldReferenceName;

        ReferenceNameExpression(LookupElement[] items, String oldReferenceName) {
            this.myItems = items;
            this.myOldReferenceName = oldReferenceName;
            Arrays.sort(this.myItems, new HammingComparator());
        }

        public Result calculateResult(ExpressionContext context) {
            if (this.myItems == null || this.myItems.length == 0) {
                return new TextResult(this.myOldReferenceName);
            }
            return new TextResult(this.myItems[0].getLookupString());
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return null;
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            if (this.myItems == null || this.myItems.length == 1) {
                return null;
            }
            return this.myItems;
        }

        class HammingComparator
        implements Comparator<LookupElement> {
            HammingComparator() {
            }

            @Override
            public int compare(LookupElement lookupItem1, LookupElement lookupItem2) {
                String s1 = lookupItem1.getLookupString();
                String s2 = lookupItem2.getLookupString();
                int diff1 = 0;
                for (int i = 0; i < Math.min(s1.length(), ReferenceNameExpression.this.myOldReferenceName.length()); ++i) {
                    if (s1.charAt(i) == ReferenceNameExpression.this.myOldReferenceName.charAt(i)) continue;
                    ++diff1;
                }
                int diff2 = 0;
                for (int i = 0; i < Math.min(s2.length(), ReferenceNameExpression.this.myOldReferenceName.length()); ++i) {
                    if (s2.charAt(i) == ReferenceNameExpression.this.myOldReferenceName.charAt(i)) continue;
                    ++diff2;
                }
                return diff1 - diff2;
            }
        }
    }
}

