/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MethodThrowsFix
extends IntentionAndQuickFixAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix");
    private final PsiMethod myMethod;
    private final String myThrowsCanonicalText;
    private final boolean myShouldThrow;
    private final boolean myShowContainingClass;

    public MethodThrowsFix(PsiMethod method, PsiClassType exceptionType, boolean shouldThrow, boolean showContainingClass) {
        this.myMethod = method;
        this.myThrowsCanonicalText = exceptionType.getCanonicalText();
        this.myShouldThrow = shouldThrow;
        this.myShowContainingClass = showContainingClass;
    }

    @NotNull
    public String getName() {
        String methodName = PsiFormatUtil.formatMethod((PsiMethod)this.myMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)(1 | (this.myShowContainingClass ? 4096 : 0)), (int)0);
        String string = QuickFixBundle.message(this.myShouldThrow ? "fix.throws.list.add.exception" : "fix.throws.list.remove.exception", this.myThrowsCanonicalText, methodName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.throws.list.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix.isAvailable must not be null");
        }
        return this.myMethod != null && this.myMethod.isValid() && this.myMethod.getManager().isInProject((PsiElement)this.myMethod);
    }

    public void applyFix(Project project, PsiFile file, Editor editor) {
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myMethod.getContainingFile())) {
            return;
        }
        PsiJavaCodeReferenceElement[] referenceElements = this.myMethod.getThrowsList().getReferenceElements();
        try {
            boolean alreadyThrows = false;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
                if (!referenceElement.getCanonicalText().equals(this.myThrowsCanonicalText)) continue;
                alreadyThrows = true;
                if (this.myShouldThrow) continue;
                referenceElement.delete();
                break;
            }
            if (this.myShouldThrow && !alreadyThrows) {
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
                PsiClassType type = (PsiClassType)factory.createTypeFromText(this.myThrowsCanonicalText, (PsiElement)this.myMethod);
                PsiJavaCodeReferenceElement ref = factory.createReferenceElementByType(type);
                ref = (PsiJavaCodeReferenceElement)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)ref);
                this.myMethod.getThrowsList().add((PsiElement)ref);
            }
            UndoUtil.markPsiFileForUndo((PsiFile)file);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

