/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementMethodsFix
extends IntentionAndQuickFixAction {
    private final PsiClass myClass;

    public ImplementMethodsFix(PsiClass aClass) {
        this.myClass = aClass;
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("implement.methods.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("implement.methods.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix.isAvailable must not be null");
        }
        return this.myClass.isValid() && this.myClass.getManager().isInProject((PsiElement)this.myClass);
    }

    public void applyFix(Project project, PsiFile file, @Nullable Editor editor) {
        if (editor == null || !CodeInsightUtilBase.prepareFileForWrite(this.myClass.getContainingFile())) {
            return;
        }
        OverrideImplementUtil.chooseAndImplementMethods(project, editor, this.myClass);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

