/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateGetterOrSetterFix
implements IntentionAction {
    private final boolean myCreateGetter;
    private final boolean myCreateSetter;
    private final PsiField myField;
    private final String myPropertyName;

    public CreateGetterOrSetterFix(boolean createGetter, boolean createSetter, PsiField field) {
        this.myCreateGetter = createGetter;
        this.myCreateSetter = createSetter;
        this.myField = field;
        Project project = field.getProject();
        this.myPropertyName = PropertyUtil.suggestPropertyName((Project)project, (PsiField)field);
    }

    @NotNull
    public String getText() {
        String what;
        if (this.myCreateGetter && this.myCreateSetter) {
            what = "create.getter.and.setter.for.field";
        } else if (this.myCreateGetter) {
            what = "create.getter.for.field";
        } else if (this.myCreateSetter) {
            what = "create.setter.for.field";
        } else {
            what = "";
            assert (false);
        }
        String string = QuickFixBundle.message(what, this.myField.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateGetterOrSetterFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.accessor.for.unused.field.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateGetterOrSetterFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateGetterOrSetterFix.isAvailable must not be null");
        }
        if (!this.myField.isValid()) {
            return false;
        }
        PsiClass aClass = this.myField.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (this.myCreateGetter && PropertyUtil.findPropertyGetter((PsiClass)aClass, (String)this.myPropertyName, (boolean)this.myField.hasModifierProperty("static"), (boolean)false) != null) {
            return false;
        }
        return !this.myCreateSetter || PropertyUtil.findPropertySetter((PsiClass)aClass, (String)this.myPropertyName, (boolean)this.myField.hasModifierProperty("static"), (boolean)false) == null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateGetterOrSetterFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)this.myField)) {
            return;
        }
        PsiClass aClass = this.myField.getContainingClass();
        if (this.myCreateGetter) {
            aClass.add((PsiElement)PropertyUtil.generateGetterPrototype((PsiField)this.myField));
        }
        if (this.myCreateSetter) {
            aClass.add((PsiElement)PropertyUtil.generateSetterPrototype((PsiField)this.myField));
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

