/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeUtil;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.proc.VariablesProcessor;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.ExpressionUtil;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class CreateFromUsageUtils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils");
    private static final int MAX_GUESSED_MEMBERS_COUNT = 10;

    public static boolean isValidReference(PsiReference reference, boolean unresolvedOnly) {
        if (!(reference instanceof PsiJavaReference)) {
            return false;
        }
        JavaResolveResult[] results = ((PsiJavaReference)reference).multiResolve(true);
        if (results.length == 0) {
            return false;
        }
        if (!unresolvedOnly) {
            for (JavaResolveResult result : results) {
                if (result.isValidResult()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidMethodReference(PsiReference reference, PsiMethodCallExpression call) {
        if (!(reference instanceof PsiJavaReference)) {
            return false;
        }
        try {
            JavaResolveResult candidate = ((PsiJavaReference)reference).advancedResolve(true);
            PsiElement result = candidate.getElement();
            return result instanceof PsiMethod && PsiUtil.isApplicable((PsiMethod)((PsiMethod)result), (PsiSubstitutor)candidate.getSubstitutor(), (PsiExpressionList)call.getArgumentList());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public static boolean shouldCreateConstructor(PsiClass targetClass, PsiExpressionList argList, PsiMethod candidate) {
        if (argList == null) {
            return false;
        }
        if (candidate == null) {
            return targetClass != null && !targetClass.isInterface() && !(targetClass instanceof PsiTypeParameter) && (argList.getExpressions().length != 0 || targetClass.getConstructors().length != 0);
        }
        return !PsiUtil.isApplicable((PsiMethod)candidate, (PsiSubstitutor)PsiSubstitutor.EMPTY, (PsiExpressionList)argList);
    }

    public static void setupMethodBody(PsiMethod method) throws IncorrectOperationException {
        PsiClass aClass = method.getContainingClass();
        CreateFromUsageUtils.setupMethodBody(method, aClass);
    }

    public static void setupMethodBody(PsiMethod method, PsiClass aClass) throws IncorrectOperationException {
        FileTemplate template = FileTemplateManager.getInstance().getCodeTemplate("New Method Body.java");
        CreateFromUsageUtils.setupMethodBody(method, aClass, template);
    }

    public static void setupMethodBody(PsiMethod method, PsiClass aClass, FileTemplate template) throws IncorrectOperationException {
        String methodText;
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            returnType = PsiType.VOID;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        LOG.assertTrue(!aClass.isInterface(), (Object)"Interface bodies should be already set up");
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(template.getExtension());
        Properties properties = new Properties();
        properties.setProperty("RETURN_TYPE", returnType.getPresentableText());
        properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)returnType));
        JavaTemplateUtil.setClassAndMethodNameProperties(properties, aClass, method);
        CodeStyleManager csManager = CodeStyleManager.getInstance((Project)method.getProject());
        try {
            String bodyText = template.getText(properties);
            if (!"".equals(bodyText)) {
                bodyText = bodyText + "\n";
            }
            methodText = returnType.getPresentableText() + " foo () {\n" + bodyText + "}";
            methodText = FileTemplateUtil.indent(methodText, method.getProject(), fileType);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Failed to parse file template", e);
        }
        if (methodText != null) {
            PsiMethod m;
            try {
                m = factory.createMethodFromText(methodText, (PsiElement)aClass);
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)QuickFixBundle.message("new.method.body.template.error.text", new Object[0]), (String)QuickFixBundle.message("new.method.body.template.error.title", new Object[0]));
                    }
                });
                return;
            }
            PsiCodeBlock oldBody = method.getBody();
            PsiCodeBlock newBody = m.getBody();
            LOG.assertTrue(newBody != null);
            if (oldBody != null) {
                oldBody.replace((PsiElement)newBody);
            } else {
                method.addBefore((PsiElement)newBody, null);
            }
            csManager.reformat((PsiElement)method);
        }
    }

    public static void setupEditor(PsiMethod method, Editor newEditor) {
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            PsiElement l = PsiTreeUtil.skipSiblingsForward((PsiElement)body.getLBrace(), (Class[])new Class[]{PsiWhiteSpace.class});
            PsiElement r = PsiTreeUtil.skipSiblingsBackward((PsiElement)body.getRBrace(), (Class[])new Class[]{PsiWhiteSpace.class});
            if (l != null && r != null) {
                int start = l.getTextRange().getStartOffset();
                int end = r.getTextRange().getEndOffset();
                newEditor.getCaretModel().moveToOffset(Math.max(start, end));
                newEditor.getSelectionModel().setSelection(Math.min(start, end), Math.max(start, end));
                newEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }
    }

    public static void setupMethodParameters(PsiMethod method, TemplateBuilder builder, PsiExpressionList argumentList, PsiSubstitutor substitutor) throws IncorrectOperationException {
        if (argumentList == null) {
            return;
        }
        PsiExpression[] args = argumentList.getExpressions();
        CreateFromUsageUtils.setupMethodParameters(method, builder, (PsiElement)argumentList, substitutor, args);
    }

    public static void setupMethodParameters(PsiMethod method, TemplateBuilder builder, PsiElement contextElement, PsiSubstitutor substitutor, PsiExpression[] arguments) {
        CreateFromUsageUtils.setupMethodParameters(method, builder, contextElement, substitutor, ContainerUtil.map2List((Object[])arguments, (Function)new Function<PsiExpression, Pair<PsiExpression, PsiType>>(){

            public Pair<PsiExpression, PsiType> fun(PsiExpression psiExpression) {
                return Pair.create((Object)psiExpression, null);
            }
        }));
    }

    public static void setupMethodParameters(PsiMethod method, TemplateBuilder builder, PsiElement contextElement, PsiSubstitutor substitutor, List<Pair<PsiExpression, PsiType>> arguments) throws IncorrectOperationException {
        PsiManager psiManager = method.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        PsiParameterList parameterList = method.getParameterList();
        GlobalSearchScope resolveScope = method.getResolveScope();
        GuessTypeParameters guesser = new GuessTypeParameters(factory);
        boolean isInterface = method.getContainingClass().isInterface();
        for (int i = 0; i < arguments.size(); ++i) {
            PsiParameter parameter;
            Pair<PsiExpression, PsiType> arg = arguments.get(i);
            PsiExpression exp = (PsiExpression)arg.first;
            PsiType argType = exp == null ? (PsiType)arg.second : exp.getType();
            SuggestedNameInfo suggestedInfo = JavaCodeStyleManager.getInstance((Project)psiManager.getProject()).suggestVariableName(VariableKind.PARAMETER, null, exp, argType);
            String[] names = suggestedInfo.names;
            if (names.length == 0) {
                names = new String[]{"p" + i};
            }
            if (argType == null || PsiType.NULL.equals(argType)) {
                argType = PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)resolveScope);
            }
            if (parameterList.getParametersCount() <= i) {
                parameter = factory.createParameter(names[0], argType);
                if (isInterface) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)false);
                }
                parameter = (PsiParameter)parameterList.add((PsiElement)parameter);
            } else {
                parameter = parameterList.getParameters()[i];
            }
            ExpectedTypeInfo info = ExpectedTypesProvider.createInfo(argType, 2, argType, TailType.NONE);
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)contextElement, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
            guesser.setupTypeElement(parameter.getTypeElement(), new ExpectedTypeInfo[]{info}, substitutor, builder, context, method.getContainingClass());
            ParameterNameExpression expression = new ParameterNameExpression(names);
            builder.replaceElement((PsiElement)parameter.getNameIdentifier(), (Expression)expression);
        }
    }

    @Nullable
    public static PsiClass createClass(PsiJavaCodeReferenceElement referenceElement, final CreateClassKind classKind, String superClassName) {
        PsiDirectory targetDirectory;
        PsiElement qualifierElement;
        final String name = referenceElement.getReferenceName();
        if (referenceElement.getQualifier() instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement qualifier = (PsiJavaCodeReferenceElement)referenceElement.getQualifier();
            PsiElement psiElement = qualifierElement = qualifier == null ? null : qualifier.resolve();
            if (qualifierElement instanceof PsiClass) {
                return (PsiClass)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiClass>(){

                    public PsiClass compute() {
                        try {
                            PsiClass psiClass = (PsiClass)qualifierElement;
                            if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)psiClass)) {
                                return null;
                            }
                            PsiManager manager = psiClass.getManager();
                            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
                            PsiClass result = classKind == CreateClassKind.INTERFACE ? elementFactory.createInterface(name) : (classKind == CreateClassKind.CLASS ? elementFactory.createClass(name) : elementFactory.createEnum(name));
                            result = (PsiClass)manager.getCodeStyleManager().reformat((PsiElement)result);
                            return (PsiClass)psiClass.add((PsiElement)result);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                            return null;
                        }
                    }
                });
            }
        } else {
            qualifierElement = null;
        }
        PsiManager manager = referenceElement.getManager();
        PsiFile sourceFile = referenceElement.getContainingFile();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)sourceFile);
        PsiPackage aPackage = null;
        if (qualifierElement instanceof PsiPackage) {
            aPackage = (PsiPackage)qualifierElement;
        } else {
            PsiDirectory directory = sourceFile.getContainingDirectory();
            if (directory != null) {
                aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            }
            if (aPackage == null) {
                aPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage("");
            }
        }
        if (aPackage == null) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Project project = manager.getProject();
            String title = QuickFixBundle.message("create.class.title", StringUtil.capitalize((String)classKind.getDescription()));
            CreateClassDialog dialog = new CreateClassDialog(project, title, name, aPackage.getQualifiedName(), classKind, false, module);
            dialog.show();
            if (dialog.getExitCode() != 0) {
                return null;
            }
            targetDirectory = dialog.getTargetDirectory();
            if (targetDirectory == null) {
                return null;
            }
        } else {
            targetDirectory = null;
        }
        return CreateFromUsageUtils.createClass(classKind, targetDirectory, name, manager, (PsiElement)referenceElement, sourceFile, superClassName);
    }

    public static PsiClass createClass(final CreateClassKind classKind, final PsiDirectory directory, final String name, PsiManager manager, final PsiElement contextElement, final PsiFile sourceFile, final String superClassName) {
        final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        final PsiElementFactory factory = facade.getElementFactory();
        return (PsiClass)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                try {
                    PsiClass targetClass;
                    if (directory != null) {
                        block17: {
                            try {
                                if (classKind == CreateClassKind.INTERFACE) {
                                    targetClass = JavaDirectoryService.getInstance().createInterface(directory, name);
                                    break block17;
                                }
                                if (classKind == CreateClassKind.CLASS) {
                                    targetClass = JavaDirectoryService.getInstance().createClass(directory, name);
                                    break block17;
                                }
                                if (classKind == CreateClassKind.ENUM) {
                                    targetClass = JavaDirectoryService.getInstance().createEnum(directory, name);
                                    break block17;
                                }
                                LOG.error("Unknown kind of a class to create");
                                return null;
                            }
                            catch (IncorrectOperationException e) {
                                CreateFromUsageUtils.scheduleFileOrPackageCreationFailedMessageBox(e, name, directory, false);
                                return null;
                            }
                        }
                        if (!facade.getResolveHelper().isAccessible((PsiMember)targetClass, contextElement, null)) {
                            PsiUtil.setModifierProperty((PsiModifierListOwner)targetClass, (String)"public", (boolean)true);
                        }
                    } else {
                        PsiClass aClass;
                        if (classKind == CreateClassKind.INTERFACE) {
                            aClass = factory.createInterface(name);
                        } else if (classKind == CreateClassKind.CLASS) {
                            aClass = factory.createClass(name);
                        } else if (classKind == CreateClassKind.ENUM) {
                            aClass = factory.createEnum(name);
                        } else {
                            LOG.error("Unknown kind of a class to create");
                            return null;
                        }
                        targetClass = (PsiClass)sourceFile.add((PsiElement)aClass);
                    }
                    if (superClassName != null) {
                        PsiClass superClass = facade.findClass(superClassName, targetClass.getResolveScope());
                        PsiJavaCodeReferenceElement superClassReference = factory.createReferenceElementByFQClassName(superClassName, targetClass.getResolveScope());
                        PsiReferenceList list = classKind == CreateClassKind.INTERFACE || superClass == null || !superClass.isInterface() ? targetClass.getExtendsList() : targetClass.getImplementsList();
                        list.add((PsiElement)superClassReference);
                    }
                    return targetClass;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
        });
    }

    public static void scheduleFileOrPackageCreationFailedMessageBox(final IncorrectOperationException e, final String name, final PsiDirectory directory, final boolean isPackage) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((String)QuickFixBundle.message(isPackage ? "cannot.create.java.package.error.text" : "cannot.create.java.file.error.text", name, directory.getVirtualFile().getName(), e.getLocalizedMessage()), (String)QuickFixBundle.message(isPackage ? "cannot.create.java.package.error.title" : "cannot.create.java.file.error.title", new Object[0]));
            }
        });
    }

    public static PsiReferenceExpression[] collectExpressions(final PsiExpression expression, Class<? extends PsiElement> ... scopes) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])scopes);
        final ArrayList result = new ArrayList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            public List getResult() {
                return result;
            }

            public void visitReferenceExpression(PsiReferenceExpression expr) {
                if (expression instanceof PsiReferenceExpression && expr.textMatches((PsiElement)expression)) {
                    result.add(expr);
                }
                this.visitElement((PsiElement)expr);
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expr) {
                PsiReferenceExpression methodExpression;
                if (expression instanceof PsiMethodCallExpression && (methodExpression = expr.getMethodExpression()).textMatches((PsiElement)((PsiMethodCallExpression)expression).getMethodExpression())) {
                    result.add(expr.getMethodExpression());
                }
                this.visitElement((PsiElement)expr);
            }
        };
        parent.accept((PsiElementVisitor)visitor);
        return result.toArray(new PsiReferenceExpression[result.size()]);
    }

    public static PsiVariable[] guessMatchingVariables(final PsiExpression expression) {
        ArrayList<ExpectedTypeInfo[]> typesList = new ArrayList<ExpectedTypeInfo[]>();
        ArrayList<String> expectedMethodNames = new ArrayList<String>();
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        CreateFromUsageUtils.getExpectedInformation(expression, typesList, expectedMethodNames, expectedFieldNames);
        ArrayList list = new ArrayList();
        VariablesProcessor varproc = new VariablesProcessor("", true, list){

            @Override
            public boolean execute(PsiElement element, ResolveState state) {
                if (!(element instanceof PsiField) || JavaPsiFacade.getInstance((Project)element.getProject()).getResolveHelper().isAccessible((PsiMember)((PsiField)element), (PsiElement)expression, null)) {
                    return super.execute(element, state);
                }
                return true;
            }
        };
        PsiScopesUtil.treeWalkUp(varproc, (PsiElement)expression, null);
        PsiVariable[] allVars = varproc.getResultsAsArray();
        ExpectedTypeInfo[] infos = ExpectedTypeUtil.intersect(typesList);
        ArrayList<PsiVariable> result = new ArrayList<PsiVariable>();
        block0: for (PsiVariable variable : allVars) {
            PsiType varType = variable.getType();
            boolean matched = infos.length == 0;
            for (ExpectedTypeInfo info : infos) {
                if (!ExpectedTypeUtil.matches(varType, info)) continue;
                matched = true;
                break;
            }
            if (!matched) continue;
            if (!expectedFieldNames.isEmpty() && !expectedMethodNames.isEmpty()) {
                PsiClass aClass;
                if (!(varType instanceof PsiClassType) || (aClass = ((PsiClassType)varType).resolve()) == null) continue;
                for (String name : expectedFieldNames) {
                    if (aClass.findFieldByName(name, true) != null) continue;
                    continue block0;
                }
                for (String name : expectedMethodNames) {
                    PsiMethod[] methods = aClass.findMethodsByName(name, true);
                    if (methods.length != 0) continue;
                    continue block0;
                }
            }
            result.add(variable);
        }
        return result.toArray(new PsiVariable[result.size()]);
    }

    private static void getExpectedInformation(PsiExpression expression, List<ExpectedTypeInfo[]> types, List<String> expectedMethodNames, List<String> expectedFieldNames) {
        PsiReferenceExpression[] expressions;
        for (PsiReferenceExpression expr : expressions = CreateFromUsageUtils.collectExpressions(expression, PsiMember.class, PsiFile.class)) {
            PsiElement parent = expr.getParent();
            if (parent instanceof PsiReferenceExpression) {
                String refName;
                PsiElement pparent = parent.getParent();
                if (pparent instanceof PsiMethodCallExpression) {
                    refName = ((PsiReferenceExpression)parent).getReferenceName();
                    if (refName == null) continue;
                    expectedMethodNames.add(refName);
                    continue;
                }
                if (!(pparent instanceof PsiReferenceExpression) && !(pparent instanceof PsiVariable) && !(pparent instanceof PsiExpression) || (refName = ((PsiReferenceExpression)parent).getReferenceName()) == null) continue;
                expectedFieldNames.add(refName);
                continue;
            }
            ExpectedTypeInfo[] someExpectedTypes = ExpectedTypesProvider.getInstance(expression.getProject()).getExpectedTypes((PsiExpression)expr, false);
            if (someExpectedTypes.length <= 0) continue;
            types.add(someExpectedTypes);
        }
    }

    public static ExpectedTypeInfo[] guessExpectedTypes(PsiExpression expression, boolean allowVoidType) {
        ExpectedTypeInfo[] expectedTypes;
        ExpectedTypeInfo[] infos;
        PsiManager manager = expression.getManager();
        GlobalSearchScope resolveScope = expression.getResolveScope();
        ExpectedTypesProvider provider = ExpectedTypesProvider.getInstance(manager.getProject());
        ArrayList<ExpectedTypeInfo[]> typesList = new ArrayList<ExpectedTypeInfo[]>();
        ArrayList<String> expectedMethodNames = new ArrayList<String>();
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        CreateFromUsageUtils.getExpectedInformation(expression, typesList, expectedMethodNames, expectedFieldNames);
        if (!(typesList.size() != 1 || expectedFieldNames.isEmpty() && expectedMethodNames.isEmpty() || (infos = (ExpectedTypeInfo[])typesList.get(0)).length != 1 || infos[0].getKind() != 1 || !infos[0].getType().equals(PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope)))) {
            typesList.clear();
        }
        if (typesList.isEmpty()) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiElementFactory factory = facade.getElementFactory();
            for (String fieldName : expectedFieldNames) {
                PsiField[] fields = facade.getShortNamesCache().getFieldsByName(fieldName, resolveScope);
                CreateFromUsageUtils.addMemberInfo((PsiMember[])fields, expression, typesList, factory);
            }
            for (String methodName : expectedMethodNames) {
                PsiMethod[] methods = facade.getShortNamesCache().getMethodsByName(methodName, resolveScope);
                CreateFromUsageUtils.addMemberInfo((PsiMember[])methods, expression, typesList, factory);
            }
        }
        if ((expectedTypes = ExpectedTypeUtil.intersect(typesList)).length == 0 && !typesList.isEmpty()) {
            ArrayList<ExpectedTypeInfo> union = new ArrayList<ExpectedTypeInfo>();
            for (ExpectedTypeInfo[] aTypesList : typesList) {
                union.addAll(Arrays.asList(aTypesList));
            }
            expectedTypes = union.toArray(new ExpectedTypeInfo[union.size()]);
        }
        if (expectedTypes == null || expectedTypes.length == 0) {
            PsiType t = allowVoidType ? PsiType.VOID : PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope);
            ExpectedTypeInfo[] expectedTypeInfoArray = new ExpectedTypeInfo[1];
            expectedTypeInfoArray[0] = ExpectedTypesProvider.createInfo(t, 1, t, TailType.NONE);
            expectedTypes = expectedTypeInfoArray;
        }
        return expectedTypes;
    }

    public static PsiType[] guessType(PsiExpression expression, final boolean allowVoidType) {
        ExpectedTypeInfo[] expectedTypes;
        ExpectedTypeInfo[] infos;
        final PsiManager manager = expression.getManager();
        final GlobalSearchScope resolveScope = expression.getResolveScope();
        ArrayList<ExpectedTypeInfo[]> typesList = new ArrayList<ExpectedTypeInfo[]>();
        final ArrayList<String> expectedMethodNames = new ArrayList<String>();
        final ArrayList<String> expectedFieldNames = new ArrayList<String>();
        CreateFromUsageUtils.getExpectedInformation(expression, typesList, expectedMethodNames, expectedFieldNames);
        if (!(typesList.size() != 1 || expectedFieldNames.isEmpty() && expectedMethodNames.isEmpty() || (infos = (ExpectedTypeInfo[])typesList.get(0)).length != 1 || infos[0].getKind() != 1 || !infos[0].getType().equals(PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope)))) {
            typesList.clear();
        }
        if (typesList.isEmpty()) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiElementFactory factory = facade.getElementFactory();
            for (String fieldName : expectedFieldNames) {
                PsiField[] fields = facade.getShortNamesCache().getFieldsByName(fieldName, resolveScope);
                CreateFromUsageUtils.addMemberInfo((PsiMember[])fields, expression, typesList, factory);
            }
            for (String methodName : expectedMethodNames) {
                PsiMethod[] methods = facade.getShortNamesCache().getMethodsByName(methodName, resolveScope);
                CreateFromUsageUtils.addMemberInfo((PsiMember[])methods, expression, typesList, factory);
            }
        }
        if ((expectedTypes = ExpectedTypeUtil.intersect(typesList)).length == 0 && !typesList.isEmpty()) {
            ArrayList<ExpectedTypeInfo> union = new ArrayList<ExpectedTypeInfo>();
            for (ExpectedTypeInfo[] aTypesList : typesList) {
                union.addAll(Arrays.asList(aTypesList));
            }
            expectedTypes = union.toArray(new ExpectedTypeInfo[union.size()]);
        }
        if (expectedTypes == null || expectedTypes.length == 0) {
            PsiType[] psiTypeArray;
            if (allowVoidType) {
                PsiType[] psiTypeArray2 = new PsiType[1];
                psiTypeArray = psiTypeArray2;
                psiTypeArray2[0] = PsiType.VOID;
            } else {
                PsiType[] psiTypeArray3 = new PsiType[1];
                psiTypeArray = psiTypeArray3;
                psiTypeArray3[0] = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope);
            }
            return psiTypeArray;
        }
        final HashSet typesSet = new HashSet();
        PsiTypeVisitor<PsiType> visitor = new PsiTypeVisitor<PsiType>(){

            public PsiType visitType(PsiType type) {
                if (PsiType.NULL.equals(type)) {
                    type = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope);
                } else if (PsiType.VOID.equals(type) && !allowVoidType) {
                    type = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope);
                }
                if (!typesSet.contains(type)) {
                    PsiClass aClass;
                    if (!(!(type instanceof PsiClassType) || expectedFieldNames.isEmpty() && expectedMethodNames.isEmpty() || (aClass = ((PsiClassType)type).resolve()) == null)) {
                        for (String fieldName : expectedFieldNames) {
                            if (aClass.findFieldByName(fieldName, true) != null) continue;
                            return null;
                        }
                        for (String methodName : expectedMethodNames) {
                            PsiMethod[] methods = aClass.findMethodsByName(methodName, true);
                            if (methods.length != 0) continue;
                            return null;
                        }
                    }
                    typesSet.add(type);
                    return type;
                }
                return null;
            }

            public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return (PsiType)capturedWildcardType.getUpperBound().accept((PsiTypeVisitor)this);
            }
        };
        ExpectedTypesProvider provider = ExpectedTypesProvider.getInstance(manager.getProject());
        PsiType[] types = ExpectedTypesProvider.processExpectedTypes(expectedTypes, visitor, manager.getProject());
        if (types.length == 0) {
            PsiType[] psiTypeArray;
            if (allowVoidType) {
                PsiType[] psiTypeArray4 = new PsiType[1];
                psiTypeArray = psiTypeArray4;
                psiTypeArray4[0] = PsiType.VOID;
            } else {
                PsiType[] psiTypeArray5 = new PsiType[1];
                psiTypeArray = psiTypeArray5;
                psiTypeArray5[0] = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope);
            }
            return psiTypeArray;
        }
        return types;
    }

    private static void addMemberInfo(PsiMember[] members, PsiExpression expression, List<ExpectedTypeInfo[]> types, PsiElementFactory factory) {
        Arrays.sort(members, new Comparator<PsiMember>(){

            @Override
            public int compare(PsiMember m1, PsiMember m2) {
                int result = JavaStatisticsManager.createInfo(null, (PsiMember)m2).getUseCount() - JavaStatisticsManager.createInfo(null, (PsiMember)m1).getUseCount();
                if (result != 0) {
                    return result;
                }
                PsiClass aClass = m1.getContainingClass();
                PsiClass bClass = m2.getContainingClass();
                if (aClass == null || bClass == null) {
                    return 0;
                }
                return JavaStatisticsManager.createInfo(null, (PsiMember)bClass).getUseCount() - JavaStatisticsManager.createInfo(null, (PsiMember)aClass).getUseCount();
            }
        });
        ArrayList<ExpectedTypeInfo> l = new ArrayList<ExpectedTypeInfo>();
        PsiManager manager = expression.getManager();
        ExpectedTypesProvider provider = ExpectedTypesProvider.getInstance(manager.getProject());
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        for (int i = 0; i < Math.min(10, members.length); ++i) {
            PsiSubstitutor substitutor;
            ProgressManager.checkCanceled();
            PsiMember member = members[i];
            PsiClass aClass = member.getContainingClass();
            if (aClass instanceof PsiAnonymousClass || !facade.getResolveHelper().isAccessible((PsiMember)aClass, (PsiElement)expression, null)) continue;
            PsiElement pparent = expression.getParent().getParent();
            PsiClassType type = pparent instanceof PsiMethodCallExpression && member instanceof PsiMethod ? ((substitutor = ExpectedTypeUtil.inferSubstitutor((PsiMethod)member, (PsiMethodCallExpression)pparent, false)) == null ? factory.createType(aClass) : factory.createType(aClass, substitutor)) : factory.createType(aClass);
            l.add(ExpectedTypesProvider.createInfo((PsiType)type, 1, (PsiType)type, TailType.NONE));
        }
        if (!l.isEmpty()) {
            types.add(l.toArray(new ExpectedTypeInfo[l.size()]));
        }
    }

    public static boolean isAccessedForWriting(PsiExpression[] expressionOccurences) {
        for (PsiExpression expression : expressionOccurences) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)expression)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldShowTag(int offset, PsiElement namedElement, PsiElement element) {
        if (namedElement == null) {
            return false;
        }
        TextRange range = namedElement.getTextRange();
        if (range.getLength() == 0) {
            return false;
        }
        boolean isInNamedElement = range.contains(offset);
        return isInNamedElement || element.getTextRange().contains(offset - 1);
    }

    public static void addClassesWithMember(String memberName, PsiFile file, Set<String> possibleClassNames, boolean method, boolean staticAccess) {
        CreateFromUsageUtils.addClassesWithMember(memberName, file, possibleClassNames, method, staticAccess, true);
    }

    public static void addClassesWithMember(final String memberName, PsiFile file, final Set<String> possibleClassNames, final boolean method, boolean staticAccess, boolean addObjectInheritors) {
        Project project = file.getProject();
        Module moduleForFile = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (moduleForFile == null) {
            return;
        }
        final GlobalSearchScope searchScope = file.getResolveScope();
        GlobalSearchScope descendantsSearchScope = GlobalSearchScope.moduleWithDependenciesScope((Module)moduleForFile);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        final PsiShortNamesCache cache = facade.getShortNamesCache();
        if (CreateFromUsageUtils.handleObjectMethod(possibleClassNames, facade, searchScope, method, memberName, staticAccess, addObjectInheritors)) {
            return;
        }
        PsiMember[] members = (PsiMember[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMember[]>(){

            public PsiMember[] compute() {
                return method ? cache.getMethodsByName(memberName, searchScope) : cache.getFieldsByName(memberName, searchScope);
            }
        });
        for (int i = 0; i < members.length; ++i) {
            PsiClass containingClass;
            PsiMember member = members[i];
            if (CreateFromUsageUtils.hasCorrectModifiers(member, staticAccess) && (containingClass = member.getContainingClass()) != null) {
                String qName = CreateFromUsageUtils.getQualifiedName(containingClass);
                if (qName == null) continue;
                ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)descendantsSearchScope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new Processor<PsiClass>(){

                    public boolean process(PsiClass psiClass) {
                        ContainerUtil.addIfNotNull((Object)CreateFromUsageUtils.getQualifiedName(psiClass), (Collection)possibleClassNames);
                        return true;
                    }
                });
                possibleClassNames.add(qName);
            }
            members[i] = null;
        }
    }

    private static boolean handleObjectMethod(Set<String> possibleClassNames, final JavaPsiFacade facade, final GlobalSearchScope searchScope, final boolean method, final String memberName, final boolean staticAccess, boolean addInheritors) {
        final PsiShortNamesCache cache = facade.getShortNamesCache();
        final boolean[] allClasses = new boolean[]{false};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass objectClass = facade.findClass("java.lang.Object", searchScope);
                if (objectClass != null) {
                    PsiField field;
                    if (method && objectClass.findMethodsByName(memberName, false).length > 0) {
                        allClasses[0] = true;
                    } else if (!method && CreateFromUsageUtils.hasCorrectModifiers((PsiMember)(field = objectClass.findFieldByName(memberName, false)), staticAccess)) {
                        allClasses[0] = true;
                    }
                }
            }
        });
        if (allClasses[0]) {
            String[] strings;
            possibleClassNames.add("java.lang.Object");
            if (!addInheritors) {
                return true;
            }
            for (final String className : strings = (String[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<String[]>(){

                public String[] compute() {
                    return cache.getAllClassNames();
                }
            })) {
                PsiClass[] classes;
                for (PsiClass aClass : classes = (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

                    public PsiClass[] compute() {
                        return cache.getClassesByName(className, searchScope);
                    }
                })) {
                    String qname = CreateFromUsageUtils.getQualifiedName(aClass);
                    ContainerUtil.addIfNotNull((Object)qname, possibleClassNames);
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static String getQualifiedName(final PsiClass aClass) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return aClass.getQualifiedName();
            }
        });
    }

    private static boolean hasCorrectModifiers(final @Nullable PsiMember member, final boolean staticAccess) {
        if (member == null) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return !member.hasModifierProperty("private") && member.hasModifierProperty("static") == staticAccess;
            }
        });
    }

    private static class ParameterNameExpression
    extends Expression {
        private final String[] myNames;

        public ParameterNameExpression(String[] names) {
            this.myNames = names;
        }

        public Result calculateResult(ExpressionContext context) {
            LookupElement[] lookupItems = this.calculateLookupItems(context);
            if (lookupItems.length == 0) {
                return new TextResult("");
            }
            return new TextResult(lookupItems[0].getLookupString());
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return null;
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            PsiParameter[] parameters;
            Project project = context.getProject();
            int offset = context.getStartOffset();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
            PsiElement elementAt = file.findElementAt(offset);
            PsiParameterList parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiParameterList.class);
            if (parameterList == null) {
                return LookupElement.EMPTY_ARRAY;
            }
            PsiParameter parameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiParameter.class);
            HashSet<String> parameterNames = new HashSet<String>();
            for (PsiParameter psiParameter : parameters = parameterList.getParameters()) {
                if (psiParameter == parameter) continue;
                parameterNames.add(psiParameter.getName());
            }
            HashSet<String> names = new HashSet<String>();
            LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
            for (String name : this.myNames) {
                if (parameterNames.contains(name)) {
                    int j = 1;
                    while (parameterNames.contains(name + j)) {
                        ++j;
                    }
                    name = name + j;
                }
                names.add(name);
                LookupItemUtil.addLookupItem(set, name);
            }
            String[] suggestedNames = ExpressionUtil.getNames(context);
            if (suggestedNames != null) {
                for (String name : suggestedNames) {
                    if (parameterNames.contains(name)) {
                        int j = 1;
                        while (parameterNames.contains(name + j)) {
                            ++j;
                        }
                        name = name + j;
                    }
                    if (names.contains(name)) continue;
                    LookupItemUtil.addLookupItem(set, name);
                }
            }
            return set.toArray(new LookupElement[set.size()]);
        }
    }
}

