/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CreateConstructorMatchingSuperFix
extends BaseIntentionAction {
    private final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorMatchingSuperFix");
    private final PsiClass myClass;

    public CreateConstructorMatchingSuperFix(PsiClass aClass) {
        this.myClass = aClass;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.constructor.matching.super", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorMatchingSuperFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorMatchingSuperFix.isAvailable must not be null");
        }
        if (!this.myClass.isValid() || !this.myClass.getManager().isInProject((PsiElement)this.myClass)) {
            return false;
        }
        this.setText(QuickFixBundle.message("create.constructor.matching.super", new Object[0]));
        return true;
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) {
        PsiMethod[] baseConstrs;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorMatchingSuperFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myClass.getContainingFile())) {
            return;
        }
        PsiClass baseClass = this.myClass.getSuperClass();
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)this.myClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        this.LOG.assertTrue(baseClass != null);
        ArrayList<PsiMethodMember> baseConstructors = new ArrayList<PsiMethodMember>();
        for (PsiMethod baseConstr : baseConstrs = baseClass.getConstructors()) {
            if (!PsiUtil.isAccessible((PsiMember)baseConstr, (PsiElement)this.myClass, (PsiClass)this.myClass)) continue;
            baseConstructors.add(new PsiMethodMember(baseConstr, substitutor));
        }
        ClassMember[] constructors = baseConstructors.toArray(new PsiMethodMember[baseConstructors.size()]);
        if (constructors.length == 0) {
            constructors = new PsiMethodMember[baseConstrs.length];
            for (int i = 0; i < baseConstrs.length; ++i) {
                constructors[i] = new PsiMethodMember(baseConstrs[i], substitutor);
            }
        }
        this.LOG.assertTrue(constructors.length >= 1);
        boolean isCopyJavadoc = true;
        if (constructors.length > 1) {
            MemberChooser chooser = new MemberChooser(constructors, false, true, project);
            chooser.setTitle(QuickFixBundle.message("super.class.constructors.chooser.title", new Object[0]));
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return;
            }
            constructors = (PsiMethodMember[])chooser.getSelectedElements(new PsiMethodMember[0]);
            isCopyJavadoc = chooser.isCopyJavadoc();
        }
        ClassMember[] constructors1 = constructors;
        boolean isCopyJavadoc1 = isCopyJavadoc;
        ApplicationManager.getApplication().runWriteAction(new Runnable((PsiMethodMember[])constructors1, isCopyJavadoc1, editor){
            final /* synthetic */ PsiMethodMember[] val$constructors1;
            final /* synthetic */ boolean val$isCopyJavadoc1;
            final /* synthetic */ Editor val$editor;
            {
                this.val$constructors1 = psiMethodMemberArray;
                this.val$isCopyJavadoc1 = bl;
                this.val$editor = editor;
            }

            @Override
            public void run() {
                try {
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)CreateConstructorMatchingSuperFix.this.myClass.getProject()).getElementFactory();
                    CodeStyleManager reformatter = CodeStyleManager.getInstance((Project)project);
                    PsiMethod derived = null;
                    for (PsiMethodMember candidate : this.val$constructors1) {
                        PsiDocComment docComment;
                        PsiMethod base = (PsiMethod)candidate.getElement();
                        derived = GenerateMembersUtil.substituteGenericMethod(base, candidate.getSubstitutor());
                        if (!this.val$isCopyJavadoc1 && (docComment = derived.getDocComment()) != null) {
                            docComment.delete();
                        }
                        derived.getNameIdentifier().replace((PsiElement)CreateConstructorMatchingSuperFix.this.myClass.getNameIdentifier());
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("void foo () {\nsuper(");
                        PsiParameter[] params = derived.getParameterList().getParameters();
                        for (int j = 0; j < params.length; ++j) {
                            PsiParameter param = params[j];
                            buffer.append(param.getName());
                            if (j >= params.length - 1) continue;
                            buffer.append(",");
                        }
                        buffer.append(");\n}");
                        PsiMethod stub = factory.createMethodFromText(buffer.toString(), (PsiElement)CreateConstructorMatchingSuperFix.this.myClass);
                        derived.getBody().replace((PsiElement)stub.getBody());
                        derived = (PsiMethod)reformatter.reformat((PsiElement)derived);
                        derived = (PsiMethod)CreateConstructorMatchingSuperFix.this.myClass.add((PsiElement)derived);
                    }
                    if (derived != null) {
                        this.val$editor.getCaretModel().moveToOffset(derived.getTextRange().getStartOffset());
                        this.val$editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    }
                }
                catch (IncorrectOperationException e) {
                    CreateConstructorMatchingSuperFix.this.LOG.error((Throwable)e);
                }
                UndoUtil.markPsiFileForUndo((PsiFile)CreateConstructorMatchingSuperFix.this.myClass.getContainingFile());
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

