/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AddExceptionToThrowsFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToThrowsFix");
    private final PsiElement myWrongElement;

    public AddExceptionToThrowsFix(PsiElement wrongElement) {
        this.myWrongElement = wrongElement;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiMethod targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, PsiMethod.class);
        PsiElement element = AddExceptionToThrowsFix.findElement(this.myWrongElement, targetMethod);
        LOG.assertTrue(element != null);
        Set<PsiClassType> unhandledExceptions = AddExceptionToThrowsFix.filterInProjectExceptions(targetMethod, ExceptionUtil.getUnhandledExceptions(element));
        AddExceptionToThrowsFix.addExceptionsToThrowsList(project, targetMethod, unhandledExceptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void addExceptionsToThrowsList(final Project project, final PsiMethod targetMethod, final Set<PsiClassType> unhandledExceptions) {
        boolean processSuperMethods;
        final PsiMethod[] superMethods = AddExceptionToThrowsFix.getSuperMethods(targetMethod);
        boolean hasSuperMethodsWithoutExceptions = AddExceptionToThrowsFix.hasSuperMethodsWithoutExceptions(superMethods, unhandledExceptions);
        if (hasSuperMethodsWithoutExceptions && superMethods.length > 0) {
            int result = Messages.showYesNoCancelDialog((String)QuickFixBundle.message("add.exception.to.throws.inherited.method.warning.text", targetMethod.getName()), (String)QuickFixBundle.message("add.exception.to.throws.inherited.method.warning.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                processSuperMethods = true;
            } else {
                if (result != 1) return;
                processSuperMethods = false;
            }
        } else {
            processSuperMethods = false;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (!CodeInsightUtilBase.prepareFileForWrite(targetMethod.getContainingFile())) {
                    return;
                }
                if (processSuperMethods) {
                    for (PsiMethod superMethod : superMethods) {
                        if (CodeInsightUtilBase.prepareFileForWrite(superMethod.getContainingFile())) continue;
                        return;
                    }
                }
                try {
                    AddExceptionToThrowsFix.processMethod(project, targetMethod, unhandledExceptions);
                    if (processSuperMethods) {
                        for (PsiMethod superMethod : superMethods) {
                            AddExceptionToThrowsFix.processMethod(project, superMethod, unhandledExceptions);
                        }
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    private static PsiMethod[] getSuperMethods(PsiMethod targetMethod) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        AddExceptionToThrowsFix.collectSuperMethods(targetMethod, result);
        return result.toArray(new PsiMethod[result.size()]);
    }

    private static void collectSuperMethods(PsiMethod method, List<PsiMethod> result) {
        PsiMethod[] superMethods;
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            result.add(superMethod);
            AddExceptionToThrowsFix.collectSuperMethods(superMethod, result);
        }
    }

    private static boolean hasSuperMethodsWithoutExceptions(PsiMethod[] superMethods, Set<PsiClassType> unhandledExceptions) {
        for (PsiMethod superMethod : superMethods) {
            PsiClassType[] referencedTypes = superMethod.getThrowsList().getReferencedTypes();
            HashSet<PsiClassType> exceptions = new HashSet<PsiClassType>(unhandledExceptions);
            for (PsiClassType referencedType : referencedTypes) {
                for (PsiClassType exception : unhandledExceptions) {
                    if (!referencedType.isAssignableFrom((PsiType)exception)) continue;
                    exceptions.remove(exception);
                }
            }
            if (exceptions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void processMethod(Project project, PsiMethod targetMethod, Set<PsiClassType> unhandledExceptions) throws IncorrectOperationException {
        for (PsiClassType unhandledException : unhandledExceptions) {
            PsiClass exceptionClass = unhandledException.resolve();
            if (exceptionClass == null) continue;
            PsiUtil.addException((PsiMethod)targetMethod, (PsiClass)exceptionClass);
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)targetMethod.getThrowsList());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix.isAvailable must not be null");
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (this.myWrongElement == null || !this.myWrongElement.isValid()) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, PsiMethod.class);
        if (method == null || !method.getThrowsList().isPhysical()) {
            return false;
        }
        PsiElement element = AddExceptionToThrowsFix.findElement(this.myWrongElement, method);
        if (element == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("add.exception.to.throws.text", new Object[0]));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.exception.to.throws.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix.getFamilyName must not return null");
        }
        return string;
    }

    private static PsiElement findElement(PsiElement element, PsiMethod topElement) {
        if (element == null) {
            return null;
        }
        List<PsiClassType> unhandledExceptions = ExceptionUtil.getUnhandledExceptions(element);
        if (!AddExceptionToThrowsFix.filterInProjectExceptions(topElement, unhandledExceptions).isEmpty()) {
            return element;
        }
        return AddExceptionToThrowsFix.findElement(element.getParent(), topElement);
    }

    private static Set<PsiClassType> filterInProjectExceptions(PsiMethod targetMethod, List<PsiClassType> unhandledExceptions) {
        if (targetMethod == null) {
            return Collections.emptySet();
        }
        HashSet<PsiClassType> result = new HashSet<PsiClassType>();
        if (!targetMethod.getManager().isInProject((PsiElement)targetMethod)) {
            PsiClassType[] referencedTypes;
            for (PsiClassType referencedType : referencedTypes = targetMethod.getThrowsList().getReferencedTypes()) {
                PsiClass psiClass = referencedType.resolve();
                if (psiClass == null) continue;
                for (PsiClassType exception : unhandledExceptions) {
                    if (!referencedType.isAssignableFrom((PsiType)exception)) continue;
                    result.add(exception);
                }
            }
        } else {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = targetMethod.findSuperMethods()) {
                Set<PsiClassType> classTypes = AddExceptionToThrowsFix.filterInProjectExceptions(superMethod, unhandledExceptions);
                result.addAll(classTypes);
            }
            if (superMethods.length == 0) {
                result.addAll(unhandledExceptions);
            }
        }
        return result;
    }
}

