/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlErrorQuickFixProvider
implements ErrorQuickFixProvider {
    @NonNls
    private static final String AMP_ENTITY = "&amp;";

    @Override
    public void registerErrorQuickFix(PsiErrorElement element, HighlightInfo highlightInfo) {
        if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class) != null) {
            XmlErrorQuickFixProvider.registerXmlErrorQuickFix(element, highlightInfo);
        }
    }

    private static void registerXmlErrorQuickFix(final PsiErrorElement element, HighlightInfo highlightInfo) {
        String text = element.getErrorDescription();
        if (text != null && text.startsWith(XmlErrorMessages.message("unescaped.ampersand", new Object[0]))) {
            QuickFixAction.registerQuickFixAction(highlightInfo, new IntentionAction(){

                @NotNull
                public String getText() {
                    String string = XmlErrorMessages.message("escape.ampersand.quickfix", new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1.getText must not return null");
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = this.getText();
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1.getFamilyName must not return null");
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1.isAvailable must not be null");
                    }
                    return true;
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1.invoke must not be null");
                    }
                    if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
                        return;
                    }
                    int textOffset = element.getTextOffset();
                    editor.getDocument().replaceString(textOffset, textOffset + 1, (CharSequence)XmlErrorQuickFixProvider.AMP_ENTITY);
                }

                public boolean startInWriteAction() {
                    return true;
                }
            });
        }
    }
}

