/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightNamesUtil {
    @Nullable
    public static HighlightInfo highlightMethodName(PsiMethod method, PsiElement elementToHighlight, boolean isDeclaration) {
        HighlightInfoType type = HighlightNamesUtil.getMethodNameHighlightType(method, isDeclaration);
        if (type != null && elementToHighlight != null) {
            TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)method, type);
            HighlightInfo info = HighlightInfo.createHighlightInfo(type, elementToHighlight.getTextRange(), null, null, attributes);
            if (info != null) {
                return info;
            }
        }
        return null;
    }

    private static TextAttributes mergeWithScopeAttributes(PsiElement element, HighlightInfoType type) {
        TextAttributes regularAttributes = HighlightInfo.getAttributesByType(element, type);
        if (element == null) {
            return regularAttributes;
        }
        TextAttributes scopeAttributes = HighlightNamesUtil.getScopeAttributes(element);
        return TextAttributes.merge((TextAttributes)scopeAttributes, (TextAttributes)regularAttributes);
    }

    @Nullable
    public static HighlightInfo highlightClassName(PsiClass aClass, PsiElement elementToHighlight) {
        HighlightInfoType type = HighlightNamesUtil.getClassNameHighlightType(aClass);
        if (type != null && elementToHighlight != null) {
            PsiElement parent;
            TextRange paramListRange;
            PsiJavaCodeReferenceElement referenceElement;
            PsiReferenceParameterList parameterList;
            TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)aClass, type);
            TextRange range = elementToHighlight.getTextRange();
            if (elementToHighlight instanceof PsiJavaCodeReferenceElement && (parameterList = (referenceElement = (PsiJavaCodeReferenceElement)elementToHighlight).getParameterList()) != null && (paramListRange = parameterList.getTextRange()).getEndOffset() > paramListRange.getStartOffset()) {
                range = new TextRange(range.getStartOffset(), paramListRange.getStartOffset());
            }
            if ((parent = elementToHighlight.getParent()) instanceof PsiAnnotation) {
                PsiAnnotation psiAnnotation = (PsiAnnotation)parent;
                range = new TextRange(psiAnnotation.getTextRange().getStartOffset(), range.getEndOffset());
            }
            return HighlightInfo.createHighlightInfo(type, range, null, null, attributes);
        }
        return null;
    }

    @Nullable
    public static HighlightInfo highlightVariable(PsiVariable variable, PsiElement elementToHighlight) {
        HighlightInfoType varType = HighlightNamesUtil.getVariableNameHighlightType(variable);
        if (varType != null) {
            if (variable instanceof PsiField) {
                TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)variable, varType);
                return HighlightInfo.createHighlightInfo(varType, elementToHighlight.getTextRange(), null, null, attributes);
            }
            return HighlightInfo.createHighlightInfo(varType, elementToHighlight, null);
        }
        return null;
    }

    @Nullable
    public static HighlightInfo highlightClassNameInQualifier(PsiJavaCodeReferenceElement element) {
        PsiElement resolved;
        PsiExpression qualifierExpression = null;
        if (element instanceof PsiReferenceExpression) {
            qualifierExpression = ((PsiReferenceExpression)element).getQualifierExpression();
        }
        if (qualifierExpression instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)qualifierExpression).resolve()) instanceof PsiClass) {
            return HighlightNamesUtil.highlightClassName((PsiClass)resolved, (PsiElement)qualifierExpression);
        }
        return null;
    }

    private static HighlightInfoType getMethodNameHighlightType(PsiMethod method, boolean isDeclaration) {
        if (method.isConstructor()) {
            return isDeclaration ? HighlightInfoType.CONSTRUCTOR_DECLARATION : HighlightInfoType.CONSTRUCTOR_CALL;
        }
        if (isDeclaration) {
            return HighlightInfoType.METHOD_DECLARATION;
        }
        if (method.hasModifierProperty("static")) {
            return HighlightInfoType.STATIC_METHOD;
        }
        return HighlightInfoType.METHOD_CALL;
    }

    @Nullable
    private static HighlightInfoType getVariableNameHighlightType(PsiVariable var) {
        if (var instanceof PsiLocalVariable || var instanceof PsiParameter && ((PsiParameter)var).getDeclarationScope() instanceof PsiForeachStatement) {
            return HighlightInfoType.LOCAL_VARIABLE;
        }
        if (var instanceof PsiField) {
            return var.hasModifierProperty("static") ? HighlightInfoType.STATIC_FIELD : HighlightInfoType.INSTANCE_FIELD;
        }
        if (var instanceof PsiParameter) {
            return HighlightInfoType.PARAMETER;
        }
        return null;
    }

    private static HighlightInfoType getClassNameHighlightType(PsiClass aClass) {
        if (aClass != null) {
            if (aClass.isAnnotationType()) {
                return HighlightInfoType.ANNOTATION_NAME;
            }
            if (aClass.isInterface()) {
                return HighlightInfoType.INTERFACE_NAME;
            }
            if (aClass instanceof PsiTypeParameter) {
                return HighlightInfoType.TYPE_PARAMETER_NAME;
            }
            PsiModifierList modList = aClass.getModifierList();
            if (modList != null && modList.hasModifierProperty("abstract")) {
                return HighlightInfoType.ABSTRACT_CLASS_NAME;
            }
        }
        return HighlightInfoType.CLASS_NAME;
    }

    @Nullable
    public static HighlightInfo highlightReassignedVariable(PsiVariable variable, PsiElement elementToHighlight) {
        if (variable instanceof PsiLocalVariable) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.REASSIGNED_LOCAL_VARIABLE, elementToHighlight, null);
        }
        if (variable instanceof PsiParameter) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.REASSIGNED_PARAMETER, elementToHighlight, null);
        }
        return null;
    }

    private static TextAttributes getScopeAttributes(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        TextAttributes result = null;
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)element.getProject());
        List<Pair<NamedScope, NamedScopesHolder>> scopes = daemonCodeAnalyzer.getScopeBasedHighlightingCachedScopes();
        for (Pair<NamedScope, NamedScopesHolder> scope : scopes) {
            TextAttributesKey scopeKey;
            TextAttributes attributes;
            NamedScope namedScope = (NamedScope)scope.getFirst();
            NamedScopesHolder scopesHolder = (NamedScopesHolder)scope.getSecond();
            PackageSet packageSet = namedScope.getValue();
            if (packageSet == null || !packageSet.contains(file, scopesHolder) || (attributes = scheme.getAttributes(scopeKey = ColorAndFontOptions.getScopeTextAttributeKey(namedScope.getName()))) == null || attributes.isEmpty()) continue;
            result = TextAttributes.merge((TextAttributes)attributes, result);
        }
        return result;
    }

    public static TextRange getMethodDeclarationTextRange(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil.getMethodDeclarationTextRange must not be null");
        }
        if (method instanceof JspHolderMethod) {
            return new TextRange(0, 0);
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)method.getModifierList());
        int end = method.getThrowsList().getTextRange().getEndOffset();
        return new TextRange(start, end);
    }

    public static TextRange getFieldDeclarationTextRange(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil.getFieldDeclarationTextRange must not be null");
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)field.getModifierList());
        int end = field.getNameIdentifier().getTextRange().getEndOffset();
        return new TextRange(start, end);
    }

    public static TextRange getClassDeclarationTextRange(@NotNull PsiClass aClass) {
        PsiJavaCodeReferenceElement psiElement;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil.getClassDeclarationTextRange must not be null");
        }
        if (aClass instanceof PsiEnumConstantInitializer) {
            return aClass.getLBrace().getTextRange();
        }
        Object object = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassReference() : (psiElement = aClass.getModifierList() == null ? aClass.getNameIdentifier() : aClass.getModifierList());
        if (psiElement == null) {
            return new TextRange(aClass.getTextRange().getStartOffset(), aClass.getTextRange().getStartOffset());
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)psiElement);
        PsiReferenceList endElement = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassReference() : aClass.getImplementsList();
        TextRange endTextRange = endElement == null ? null : endElement.getTextRange();
        int end = endTextRange == null ? start : endTextRange.getEndOffset();
        return new TextRange(start, end);
    }

    private static int stripAnnotationsFromModifierList(PsiElement element) {
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return 0;
        }
        PsiAnnotation lastAnnotation = null;
        for (PsiElement child : element.getChildren()) {
            if (!(child instanceof PsiAnnotation)) continue;
            lastAnnotation = (PsiAnnotation)child;
        }
        if (lastAnnotation == null) {
            return textRange.getStartOffset();
        }
        ASTNode node = lastAnnotation.getNode();
        if (node != null) {
            while ((node = TreeUtil.nextLeaf(node)) != null && JavaTokenType.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(node.getElementType())) {
            }
        }
        if (node != null) {
            return node.getTextRange().getStartOffset();
        }
        return textRange.getStartOffset();
    }
}

