/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AddNoInspectionCommentFix;
import com.intellij.codeInsight.daemon.impl.actions.AddSuppressInspectionFix;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.source.jsp.jspJava.JspMethodCall;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class AddNoInspectionJavaCommentFix
extends AddNoInspectionCommentFix {
    public AddNoInspectionJavaCommentFix(HighlightDisplayKey key) {
        super(key, PsiStatement.class);
    }

    @Override
    @Nullable
    protected PsiElement getContainer(PsiElement context) {
        if (context == null || PsiTreeUtil.getParentOfType((PsiElement)context, JspMethodCall.class) != null) {
            return null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class, (boolean)false);
    }

    @Override
    protected void createSuppression(Project project, Editor editor, PsiElement element, PsiElement container) throws IncorrectOperationException {
        boolean added = false;
        if (container instanceof PsiDeclarationStatement && SuppressManager.getInstance().canHave15Suppressions(element)) {
            PsiElement[] declaredElements;
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)container;
            for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                PsiModifierList modifierList;
                if (!(declaredElement instanceof PsiLocalVariable) || (modifierList = ((PsiLocalVariable)declaredElement).getModifierList()) == null) continue;
                AddSuppressInspectionFix.addSuppressAnnotation(project, editor, container, modifierList, this.myID);
                added = true;
                break;
            }
        }
        if (!added) {
            super.createSuppression(project, editor, element, container);
        }
    }
}

