/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExternalToolPass
extends TextEditorHighlightingPass {
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;
    private final AnnotationHolderImpl myAnnotationHolder;

    public ExternalToolPass(@NotNull PsiFile file, @NotNull Editor editor, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ExternalToolPass.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ExternalToolPass.<init> must not be null");
        }
        super(file.getProject(), editor.getDocument(), false);
        this.myFile = file;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myAnnotationHolder = new AnnotationHolderImpl();
    }

    @Override
    public void doCollectInformation(ProgressIndicator progress) {
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        for (Language language : relevantLanguages) {
            List externalAnnotators;
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightLevelUtil.shouldInspect((PsiElement)psiRoot) || (externalAnnotators = ExternalLanguageAnnotators.INSTANCE.allForLanguage(language)).isEmpty()) continue;
            boolean errorFound = ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject)).getFileStatusMap().wasErrorFound(this.myDocument);
            if (errorFound) {
                return;
            }
            for (ExternalAnnotator externalAnnotator : externalAnnotators) {
                externalAnnotator.annotate(psiRoot, (AnnotationHolder)this.myAnnotationHolder);
            }
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        List<HighlightInfo> infos = this.getHighlights();
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myStartOffset, this.myEndOffset, infos, this.getId());
        DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        ((DaemonCodeAnalyzerImpl)daemonCodeAnalyzer).getFileStatusMap().markFileUpToDate(this.myDocument, this.myFile, this.getId());
    }

    private List<HighlightInfo> getHighlights() {
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        Iterator i$ = this.myAnnotationHolder.iterator();
        while (i$.hasNext()) {
            Annotation annotation = (Annotation)i$.next();
            infos.add(HighlightInfo.fromAnnotation(annotation));
        }
        return infos;
    }
}

