/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.proc;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.List;

public class VariablesProcessor
extends BaseScopeProcessor
implements ElementClassHint {
    private final String myPrefix;
    private boolean myStaticScopeFlag = false;
    private final boolean myStaticSensitiveFlag;
    private final List<PsiVariable> myResultList;

    public VariablesProcessor(String _prefix, boolean staticSensitiveFlag) {
        this(_prefix, staticSensitiveFlag, new ArrayList<PsiVariable>());
    }

    public VariablesProcessor(String _prefix, boolean staticSensitiveFlag, List<PsiVariable> lst) {
        this.myPrefix = _prefix;
        this.myStaticSensitiveFlag = staticSensitiveFlag;
        this.myResultList = lst;
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclaractionKind kind) {
        return kind == ElementClassHint.DeclaractionKind.VARIABLE || kind == ElementClassHint.DeclaractionKind.FIELD || kind == ElementClassHint.DeclaractionKind.ENUM_CONST;
    }

    public boolean execute(PsiElement pe, ResolveState state) {
        PsiVariable pvar;
        String pvar_name;
        if (pe instanceof PsiVariable && (pvar_name = (pvar = (PsiVariable)pe).getName()).startsWith(this.myPrefix) && (!this.myStaticSensitiveFlag || !this.myStaticScopeFlag || pvar.hasModifierProperty("static"))) {
            this.myResultList.add(pvar);
        }
        return true;
    }

    @Override
    public final void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        }
    }

    public PsiVariable[] getResultsAsArray() {
        PsiVariable[] ret = new PsiVariable[this.myResultList.size()];
        this.myResultList.toArray(ret);
        return ret;
    }

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }
}

