/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.HtmlUtil;

public class XmlAttributeInsertHandler
implements InsertHandler<MutableLookupElement> {
    public static final XmlAttributeInsertHandler INSTANCE = new XmlAttributeInsertHandler();

    public void handleInsert(InsertionContext context, MutableLookupElement item) {
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        PsiFile file = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(document);
        if (file.getLanguage() == HTMLLanguage.INSTANCE && HtmlUtil.isSingleHtmlAttribute((String)item.getObject())) {
            return;
        }
        CharSequence chars = document.getCharsSequence();
        if (!CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=\"") && !CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"='")) {
            PsiElement fileContext = file.getContext();
            String toInsert = "=\"\"";
            if (fileContext != null && fileContext.getText().startsWith("\"")) {
                toInsert = "=''";
            }
            if (caretOffset >= document.getTextLength() || "/> \n\t\r".indexOf(document.getCharsSequence().charAt(caretOffset)) < 0) {
                document.insertString(caretOffset, (CharSequence)(toInsert + " "));
            } else {
                document.insertString(caretOffset, (CharSequence)toInsert);
            }
            if ('=' == context.getCompletionChar()) {
                context.setAddCompletionChar(false);
            }
        }
        editor.getCaretModel().moveToOffset(caretOffset + 2);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }
}

