/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.SyntaxTableCompletionData;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageWordCompletion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.getters.AllWordsGetter;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class WordCompletionContributor
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        if (parameters.getCompletionType() == CompletionType.BASIC && WordCompletionContributor.shouldPerformWordCompletion(parameters)) {
            WordCompletionContributor.addWordCompletionVariants(result, parameters, Collections.<String>emptySet());
        }
    }

    public static void addWordCompletionVariants(CompletionResultSet result, CompletionParameters parameters, Set<String> excludes) {
        int startOffset = parameters.getOffset();
        PsiElement insertedElement = parameters.getPosition();
        CompletionResultSet javaResultSet = result.withPrefixMatcher(CompletionUtil.findJavaIdentifierPrefix(insertedElement, startOffset));
        CompletionResultSet plainResultSet = result.withPrefixMatcher(CompletionUtil.findIdentifierPrefix(insertedElement, startOffset, (ElementPattern<Character>)StandardPatterns.character().javaIdentifierPart().andNot((ElementPattern)StandardPatterns.character().equalTo((Object)Character.valueOf('$'))), (ElementPattern<Character>)StandardPatterns.character().javaIdentifierStart()));
        for (String word : AllWordsGetter.getAllWords(insertedElement, startOffset)) {
            if (excludes.contains(word)) continue;
            LookupElementBuilder item = LookupElementBuilder.create((String)word);
            javaResultSet.addElement((LookupElement)item);
            plainResultSet.addElement((LookupElement)item);
        }
    }

    private static boolean shouldPerformWordCompletion(CompletionParameters parameters) {
        ASTNode textContainer;
        PsiElement insertedElement = parameters.getPosition();
        boolean dumb = DumbService.getInstance((Project)insertedElement.getProject()).isDumb();
        if (dumb) {
            return true;
        }
        final PsiFile file = insertedElement.getContainingFile();
        CompletionData data = CompletionUtil.getCompletionDataByElement(file);
        if (!(data instanceof SyntaxTableCompletionData)) {
            HashSet<CompletionVariant> toAdd = new HashSet<CompletionVariant>();
            data.addKeywordVariants(toAdd, insertedElement, file);
            for (CompletionVariant completionVariant : toAdd) {
                if (!completionVariant.hasKeywordCompletions()) continue;
                return false;
            }
        }
        final int startOffset = parameters.getOffset();
        PsiReference reference = (PsiReference)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiReference>(){

            public PsiReference compute() {
                return file.findReferenceAt(startOffset);
            }
        });
        if (reference != null) {
            return false;
        }
        PsiElement element = (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

            public PsiElement compute() {
                return file.findElementAt(startOffset - 1);
            }
        });
        ASTNode aSTNode = textContainer = element != null ? element.getNode() : null;
        while (textContainer != null) {
            IElementType elementType = textContainer.getElementType();
            if (LanguageWordCompletion.INSTANCE.isEnabledIn(elementType) || elementType == PlainTextTokenTypes.PLAIN_TEXT) {
                return true;
            }
            textContainer = textContainer.getTreeParent();
        }
        return false;
    }
}

