/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import org.jetbrains.annotations.NotNull;

public class JavaClassReferenceCompletionContributor
extends CompletionContributor {
    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        JavaClassReference classReference;
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaClassReferenceCompletionContributor.beforeCompletion must not be null");
        }
        PsiFile file = context.getFile();
        Project project = context.getProject();
        JavaCompletionUtil.initOffsets(file, project, context.getOffsetMap());
        PsiReference reference = file.findReferenceAt(context.getStartOffset());
        if (reference instanceof PsiMultiReference) {
            for (PsiReference psiReference : ((PsiMultiReference)reference).getReferences()) {
                if (!(psiReference instanceof JavaClassReference)) continue;
                reference = psiReference;
                break;
            }
        }
        if (reference instanceof JavaClassReference && (classReference = (JavaClassReference)reference).getExtendClassNames() != null) {
            PsiReference[] references = classReference.getJavaClassReferenceSet().getReferences();
            PsiReference lastReference = references[references.length - 1];
            int endOffset = lastReference.getRangeInElement().getEndOffset() + lastReference.getElement().getTextRange().getStartOffset();
            context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, endOffset);
        }
    }
}

