/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionBundle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.lang.LangBundle;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.classes.ThisOrAnyInnerFilter;
import com.intellij.psi.filters.element.ExcludeDeclaredFilter;
import com.intellij.psi.filters.types.AssignableFromFilter;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JavaClassNameCompletionContributor
extends CompletionContributor {
    private static final PsiJavaElementPattern.Capture<PsiElement> AFTER_THROW_NEW = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("new")).afterLeaf(new String[]{"throw"}));
    private static final PsiJavaElementPattern.Capture<PsiElement> AFTER_NEW = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"new"});
    private static final PsiJavaElementPattern.Capture<PsiElement> IN_TYPE_PARAMETER = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"extends", "super", "&"})).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceList.class).withParent(PsiTypeParameter.class));
    private static final PsiJavaElementPattern.Capture<PsiElement> INSIDE_METHOD_THROWS_CLAUSE = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"throws", ","})).inside(PsiMethod.class)).andNot((ElementPattern)PsiJavaPatterns.psiElement().inside(PsiCodeBlock.class))).andNot((ElementPattern)PsiJavaPatterns.psiElement().inside(PsiParameterList.class));

    public JavaClassNameCompletionContributor() {
        this.extend(CompletionType.CLASS_NAME, (ElementPattern)PsiJavaPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(false){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext matchingContext, final @NotNull CompletionResultSet result) {
                PsiExpression expr;
                StatisticsInfo[] infos;
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaClassNameCompletionContributor$1.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/JavaClassNameCompletionContributor$1.addCompletions must not be null");
                }
                PsiElement insertedElement = parameters.getPosition();
                String prefix = result.getPrefixMatcher().getPrefix();
                final PsiFile file = parameters.getOriginalFile();
                final Project project = file.getProject();
                AllClassesGetter getter = new AllClassesGetter(TrueFilter.INSTANCE);
                boolean afterNew = AFTER_NEW.accepts((Object)insertedElement);
                if (AFTER_THROW_NEW.accepts((Object)insertedElement)) {
                    getter = new AllClassesGetter(new AssignableFromFilter("java.lang.Throwable"));
                } else if (IN_TYPE_PARAMETER.accepts((Object)insertedElement)) {
                    getter = new AllClassesGetter(new ExcludeDeclaredFilter(new ClassFilter(PsiTypeParameter.class)));
                } else if (INSIDE_METHOD_THROWS_CLAUSE.accepts((Object)insertedElement)) {
                    getter = new AllClassesGetter(new ThisOrAnyInnerFilter((ElementFilter)new AssignableFromFilter("java.lang.Throwable")));
                }
                for (final StatisticsInfo info : infos = StatisticsManager.getInstance().getAllValues("classNameCompletion#" + StringUtil.capitalsOnly((String)prefix))) {
                    PsiClass[] classes;
                    for (final PsiClass psiClass : classes = (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

                        public PsiClass[] compute() {
                            return JavaPsiFacade.getInstance((Project)project).findClasses(info.getValue(), file.getResolveScope());
                        }
                    })) {
                        boolean isExcluded = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                            public Boolean compute() {
                                return JavaCompletionUtil.isInExcludedPackage(psiClass);
                            }
                        });
                        if (isExcluded) continue;
                        result.addElement(AllClassesGetter.createLookupItem(psiClass));
                    }
                }
                if (afterNew && (expr = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)insertedElement, PsiExpression.class, (boolean)true)) != null) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            for (ExpectedTypeInfo info : ExpectedTypesProvider.getInstance(project).getExpectedTypes(expr, true)) {
                                PsiClass defClass;
                                PsiType defaultType;
                                PsiType type = info.getType();
                                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
                                if (psiClass != null) {
                                    result.addElement(AllClassesGetter.createLookupItem(psiClass));
                                }
                                if ((defaultType = info.getDefaultType()).equals(type) || (defClass = PsiUtil.resolveClassInType((PsiType)defaultType)) == null) continue;
                                result.addElement(AllClassesGetter.createLookupItem(defClass));
                            }
                        }
                    });
                }
                getter.getClasses(insertedElement, result, parameters.getOffset(), parameters.getInvocationCount() == 1);
            }
        });
    }

    public String advertise(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaClassNameCompletionContributor.advertise must not be null");
        }
        if (JavaClassNameCompletionContributor.shouldShowSecondSmartCompletionHint(parameters) && CompletionUtil.shouldShowFeature(parameters, "editing.completion.second.classname")) {
            return CompletionBundle.message("completion.class.name.hint.2", JavaClassNameCompletionContributor.getActionShortcut((String)"ClassNameCompletion"));
        }
        return null;
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaClassNameCompletionContributor.handleEmptyLookup must not be null");
        }
        if (!(parameters.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        if (JavaClassNameCompletionContributor.shouldShowSecondSmartCompletionHint(parameters)) {
            return LangBundle.message("completion.no.suggestions", new Object[0]) + "; " + StringUtil.decapitalize((String)CompletionBundle.message("completion.class.name.hint.2", JavaClassNameCompletionContributor.getActionShortcut((String)"ClassNameCompletion")));
        }
        return null;
    }

    private static boolean shouldShowSecondSmartCompletionHint(CompletionParameters parameters) {
        return parameters.getCompletionType() == CompletionType.CLASS_NAME && parameters.getInvocationCount() == 1 && parameters.getOriginalFile().getLanguage() == StdLanguages.JAVA;
    }
}

