/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;

public class DefaultCharFilter
extends CharFilter {
    private static boolean isWithinLiteral(Lookup lookup) {
        PsiElement psiElement = lookup.getPsiElement();
        return psiElement != null && psiElement.getParent() instanceof PsiLiteralExpression;
    }

    @Override
    public CharFilter.Result acceptChar(char c, int prefixLength, Lookup lookup) {
        for (CharFilter extension : (CharFilter[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            CharFilter.Result result = extension.acceptChar(c, prefixLength, lookup);
            if (result == null) continue;
            return result;
        }
        if (Character.isJavaIdentifierPart(c)) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        switch (c) {
            case '.': {
                if (DefaultCharFilter.isWithinLiteral(lookup)) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
            }
            case ' ': 
            case '\"': 
            case '\'': 
            case '(': 
            case ',': 
            case ':': 
            case ';': 
            case '=': {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
        }
        return CharFilter.Result.HIDE_LOOKUP;
    }
}

