/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class NewColorAndFontPanel
extends JPanel {
    private final ColorSettingsPage mySettingsPage;
    private final SchemesPanel mySchemesPanel;
    private final OptionsPanel myOptionsPanel;
    private final PreviewPanel myPreviewPanel;
    private final String myCategory;
    private final Collection<String> myOptionList;

    public NewColorAndFontPanel(final SchemesPanel schemesPanel, final OptionsPanel optionsPanel, final PreviewPanel previewPanel, String category, Collection<String> optionList, ColorSettingsPage page) {
        super(new BorderLayout());
        this.mySchemesPanel = schemesPanel;
        this.myOptionsPanel = optionsPanel;
        this.myPreviewPanel = previewPanel;
        this.myCategory = category;
        this.myOptionList = optionList;
        this.mySettingsPage = page;
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)this.mySchemesPanel, "North");
        top.add((Component)this.myOptionsPanel.getPanel(), "Center");
        if (this.myPreviewPanel.getPanel() != null) {
            this.add((Component)top, "North");
            this.add(this.myPreviewPanel.getPanel(), "Center");
        } else {
            this.add((Component)top, "Center");
        }
        previewPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void selectionInPreviewChanged(String typeToSelect) {
                optionsPanel.selectOption(typeToSelect);
            }
        });
        optionsPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void settingsChanged() {
                if (schemesPanel.updateDescription(true)) {
                    optionsPanel.applyChangesToScheme();
                    previewPanel.updateView();
                }
            }

            @Override
            public void selectedOptionChanged(Object selected) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    NewColorAndFontPanel.this.myPreviewPanel.blinkSelectedHighlightType(selected);
                }
            }
        });
        this.mySchemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void schemeChanged(Object source) {
                NewColorAndFontPanel.this.myOptionsPanel.updateOptionsList();
                NewColorAndFontPanel.this.myPreviewPanel.updateView();
            }
        });
    }

    public static NewColorAndFontPanel create(PreviewPanel previewPanel, String category, ColorAndFontOptions options, Collection<String> optionList, ColorSettingsPage page) {
        SchemesPanel schemesPanel = new SchemesPanel(options);
        ColorAndFontDescriptionPanel descriptionPanel = new ColorAndFontDescriptionPanel();
        OptionsPanelImpl optionsPanel = new OptionsPanelImpl(descriptionPanel, options, schemesPanel, category);
        return new NewColorAndFontPanel(schemesPanel, optionsPanel, previewPanel, category, optionList, page);
    }

    public Runnable showOption(String option) {
        return this.myOptionsPanel.showOption(option);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Set<String> processListOptions() {
        Set<String> set;
        if (this.myOptionList == null) {
            set = this.myOptionsPanel.processListOptions();
            if (set == null) throw new IllegalStateException("@NotNull method com/intellij/application/options/colors/NewColorAndFontPanel.processListOptions must not return null");
            return set;
        }
        HashSet<String> result = new HashSet<String>();
        for (String s : this.myOptionList) {
            result.add(s);
        }
        set = result;
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method com/intellij/application/options/colors/NewColorAndFontPanel.processListOptions must not return null");
    }

    public String getDisplayName() {
        return this.myCategory;
    }

    public void reset(Object source) {
        this.resetSchemesCombo(source);
    }

    public void disposeUIResources() {
        this.myPreviewPanel.disposeUIResources();
        this.mySchemesPanel.disposeUIResources();
    }

    public void addSchemesListener(ColorAndFontSettingsListener schemeListener) {
        this.mySchemesPanel.addListener(schemeListener);
    }

    private void resetSchemesCombo(Object source) {
        this.mySchemesPanel.resetSchemesCombo(source);
    }

    public boolean contains(EditorSchemeAttributeDescriptor descriptor) {
        return descriptor.getGroup().equals(this.myCategory);
    }

    public JComponent getPanel() {
        return this;
    }

    public void updatePreview() {
        this.myPreviewPanel.updateView();
    }

    public void addDescriptionListener(ColorAndFontSettingsListener listener) {
        this.myOptionsPanel.addListener(listener);
    }

    public boolean containsFontOptions() {
        return false;
    }

    public ColorSettingsPage getSettingsPage() {
        return this.mySettingsPage;
    }
}

