/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SaveSchemeDialog
extends DialogWrapper {
    private final JTextField mySchemeName = new JTextField();
    private final ArrayList myInvalidNames;

    public SaveSchemeDialog(Component parent, String title, ArrayList invalidNames) {
        super(parent, false);
        this.myInvalidNames = invalidNames;
        this.setTitle(title);
        this.init();
    }

    public String getSchemeName() {
        return this.mySchemeName.getText();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 0.0;
        gc.insets = new Insets(5, 0, 5, 5);
        panel.add((Component)new JLabel(ApplicationBundle.message((String)"label.name", (Object[])new Object[0])), gc);
        gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.gridwidth = 2;
        gc.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)this.mySchemeName, gc);
        panel.setPreferredSize(new Dimension(220, 40));
        return panel;
    }

    protected void doOKAction() {
        if (this.getSchemeName().trim().length() == 0) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)ApplicationBundle.message((String)"error.scheme.must.have.a.name", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        if ("default".equals(this.getSchemeName())) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)ApplicationBundle.message((String)"error.illegal.scheme.name", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        if (this.myInvalidNames.contains(this.getSchemeName())) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)ApplicationBundle.message((String)"error.a.scheme.with.this.name.already.exists.or.was.deleted.without.applying.the.changes", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySchemeName;
    }
}

