/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jnlp.runtime.JNLPProxySelector;
import net.sourceforge.jnlp.util.TimedHashMap;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginDebug;

public class PluginProxySelector
extends JNLPProxySelector {
    private TimedHashMap<String, Proxy> proxyCache = new TimedHashMap();

    protected List<Proxy> getFromBrowser(URI uri) {
        ArrayList<Proxy> proxyList = new ArrayList<Proxy>();
        Proxy cachedProxy = this.checkCache(uri);
        if (cachedProxy != null) {
            proxyList.add(cachedProxy);
            return proxyList;
        }
        Proxy proxy = Proxy.NO_PROXY;
        Object o = PluginAppletViewer.requestPluginProxyInfo(uri);
        try {
            if (o != null) {
                PluginDebug.debug("Proxy URI = ", o);
                URI proxyURI = (URI)o;
                if (uri.getScheme().startsWith("http") || uri.getScheme().equals("ftp") || proxyURI.getScheme().startsWith("socks")) {
                    Proxy.Type type = proxyURI.getScheme().equals("http") ? Proxy.Type.HTTP : Proxy.Type.SOCKS;
                    InetSocketAddress socketAddr = new InetSocketAddress(proxyURI.getHost(), proxyURI.getPort());
                    proxy = new Proxy(type, socketAddr);
                    String uriKey = uri.getScheme() + "://" + uri.getHost();
                    this.proxyCache.put((Object)uriKey, (Object)proxy);
                } else {
                    PluginDebug.debug("Proxy ", proxyURI, " cannot be used for ", uri, ". Falling back to DIRECT");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        proxyList.add(proxy);
        PluginDebug.debug("Proxy for ", uri.toString(), " is ", proxy);
        return proxyList;
    }

    private Proxy checkCache(URI uri) {
        String uriKey = uri.getScheme() + "://" + uri.getHost();
        if (this.proxyCache.get((Object)uriKey) != null) {
            return (Proxy)this.proxyCache.get((Object)uriKey);
        }
        return null;
    }
}

