/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.util.ArrayList;
import java.util.LinkedList;
import sun.applet.PluginDebug;
import sun.applet.PluginMessageHandlerWorker;
import sun.applet.PluginStreamHandler;

class PluginMessageConsumer {
    private static final int MAX_PARALLEL_INITS = 1;
    private static final int MAX_WORKERS = 4;
    private static final int PRIORITY_WORKERS = 2;
    private static LinkedList<String> priorityWaitQueue = new LinkedList();
    private LinkedList<String> readQueue = new LinkedList();
    private ArrayList<PluginMessageHandlerWorker> workers = new ArrayList();
    private PluginStreamHandler streamHandler;
    private ConsumerThread consumerThread = new ConsumerThread();

    public PluginMessageConsumer(PluginStreamHandler streamHandler) {
        this.streamHandler = streamHandler;
        this.consumerThread.start();
    }

    public static void registerPriorityWait(Long reference) {
        PluginDebug.debug("Registering priority for reference ", reference);
        PluginMessageConsumer.registerPriorityWait("reference " + reference.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerPriorityWait(String searchString) {
        PluginDebug.debug("Registering priority for string ", searchString);
        LinkedList<String> linkedList = priorityWaitQueue;
        synchronized (linkedList) {
            if (!priorityWaitQueue.contains(searchString)) {
                priorityWaitQueue.add(searchString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unRegisterPriorityWait(String searchString) {
        LinkedList<String> linkedList = priorityWaitQueue;
        synchronized (linkedList) {
            priorityWaitQueue.remove(searchString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPriorityStrIfPriority(String message) {
        if (message.endsWith("destroy")) {
            return "destroy";
        }
        LinkedList<String> linkedList = priorityWaitQueue;
        synchronized (linkedList) {
            for (String priorityStr : priorityWaitQueue) {
                if (message.indexOf(priorityStr) <= 0) continue;
                return priorityStr;
            }
        }
        return null;
    }

    public void notifyWorkerIsFree(PluginMessageHandlerWorker worker) {
        this.consumerThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(String message) {
        LinkedList<String> linkedList = this.readQueue;
        synchronized (linkedList) {
            this.readQueue.addLast(message);
        }
        this.consumerThread.interrupt();
    }

    private PluginMessageHandlerWorker getFreeWorker(boolean prioritized) {
        for (PluginMessageHandlerWorker worker : this.workers) {
            if (!worker.isFree(prioritized)) continue;
            PluginDebug.debug("Found free worker (", worker.isPriority(), ") with id ", worker.getWorkerId());
            worker.busy();
            return worker;
        }
        if (this.workers.size() <= 4) {
            PluginMessageHandlerWorker worker = null;
            if (this.workers.size() < 2) {
                PluginDebug.debug("Cannot find free worker, creating worker ", this.workers.size());
                worker = new PluginMessageHandlerWorker(this, this.streamHandler, this.workers.size(), false);
            } else if (prioritized) {
                PluginDebug.debug("Cannot find free worker, creating priority worker ", this.workers.size());
                worker = new PluginMessageHandlerWorker(this, this.streamHandler, this.workers.size(), true);
            } else {
                return null;
            }
            worker.start();
            worker.busy();
            this.workers.add(worker);
            return worker;
        }
        return null;
    }

    protected class ConsumerThread
    extends Thread {
        public ConsumerThread() {
            super("PluginMessageConsumer.ConsumerThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bringPriorityMessagesToFront() {
            LinkedList linkedList = PluginMessageConsumer.this.readQueue;
            synchronized (linkedList) {
                for (int i = 0; i < PluginMessageConsumer.this.readQueue.size(); ++i) {
                    String message = (String)PluginMessageConsumer.this.readQueue.remove(i);
                    if (PluginMessageConsumer.getPriorityStrIfPriority(message) != null) {
                        PluginMessageConsumer.this.readQueue.addFirst(message);
                        continue;
                    }
                    PluginMessageConsumer.this.readQueue.add(i, message);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                String message = null;
                LinkedList linkedList = PluginMessageConsumer.this.readQueue;
                synchronized (linkedList) {
                    message = (String)PluginMessageConsumer.this.readQueue.poll();
                }
                if (message != null) {
                    String priorityStr = PluginMessageConsumer.getPriorityStrIfPriority(message);
                    boolean isPriorityResponse = priorityStr != null;
                    PluginMessageHandlerWorker worker = PluginMessageConsumer.this.getFreeWorker(isPriorityResponse);
                    if (worker == null) {
                        LinkedList linkedList2 = PluginMessageConsumer.this.readQueue;
                        synchronized (linkedList2) {
                            PluginMessageConsumer.this.readQueue.addFirst(message);
                        }
                        this.bringPriorityMessagesToFront();
                        continue;
                    }
                    if (isPriorityResponse) {
                        PluginMessageConsumer.unRegisterPriorityWait(priorityStr);
                    }
                    worker.setmessage(message);
                    worker.interrupt();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

